/*
 * Decompiled with CFR 0.152.
 */
package org.soundsofscala.graph;

import java.io.Serializable;
import org.scalajs.dom.AudioContext;
import org.scalajs.dom.BiquadFilterNode;
import org.scalajs.dom.DelayNode;
import org.scalajs.dom.GainNode;
import org.scalajs.dom.OscillatorNode;
import org.scalajs.dom.PeriodicWave;
import org.soundsofscala.graph.AudioNode$;
import org.soundsofscala.graph.AudioNode$Delay$;
import org.soundsofscala.graph.AudioNode$Filter$;
import org.soundsofscala.graph.AudioNode$Gain$;
import org.soundsofscala.graph.AudioNode$SawtoothOscillator$;
import org.soundsofscala.graph.AudioNode$SineOscillator$;
import org.soundsofscala.graph.AudioNode$SquareOscillator$;
import org.soundsofscala.graph.AudioNode$TriangleOscillator$;
import org.soundsofscala.graph.AudioNode$WaveTableOscillator$;
import org.soundsofscala.graph.AudioParam;
import org.soundsofscala.models.AudioTypes;
import org.soundsofscala.models.AudioTypes$FilterModel$;
import org.soundsofscala.models.AudioTypes$WaveType$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.scalajs.js.typedarray.Float32Array;

public interface AudioNode {
    public static Filter bandPassFilter() {
        return AudioNode$.MODULE$.bandPassFilter();
    }

    public static Delay delay() {
        return AudioNode$.MODULE$.delay();
    }

    public static Filter lowPassFilter() {
        return AudioNode$.MODULE$.lowPassFilter();
    }

    public static int ordinal(AudioNode audioNode) {
        return AudioNode$.MODULE$.ordinal(audioNode);
    }

    public static SawtoothOscillator sawtoothOscillator(double d, double d2) {
        return AudioNode$.MODULE$.sawtoothOscillator(d, d2);
    }

    public static SineOscillator sineOscillator(double d, double d2) {
        return AudioNode$.MODULE$.sineOscillator(d, d2);
    }

    public static SquareOscillator squareOscillator(double d, double d2) {
        return AudioNode$.MODULE$.squareOscillator(d, d2);
    }

    public static TriangleOscillator triangleOscillator(double d, double d2) {
        return AudioNode$.MODULE$.triangleOscillator(d, d2);
    }

    public static WaveTableOscillator waveTableOscillator(double d, double d2, Float32Array float32Array, Float32Array float32Array2) {
        return AudioNode$.MODULE$.waveTableOscillator(d, d2, float32Array, float32Array2);
    }

    public static void play$(AudioNode $this, AudioContext context, AudioContext x$0) {
        $this.play(context, x$0);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    default public void play(AudioContext context, AudioContext contextual$1) {
        org.scalajs.dom.AudioNode node = this.create(contextual$1);
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("Playing node: ").append(node).toString());
        node.connect((org.scalajs.dom.AudioNode)context.destination());
    }

    public static org.scalajs.dom.AudioNode create$(AudioNode $this, AudioContext context) {
        return $this.create(context);
    }

    default public org.scalajs.dom.AudioNode create(AudioContext context) {
        AudioNode audioNode = this;
        if (audioNode instanceof Gain) {
            Gain gain = AudioNode$Gain$.MODULE$.unapply((Gain)audioNode);
            List<AudioSource> list = gain._1();
            AudioParam audioParam = gain._2();
            List<AudioSource> sources = list;
            AudioParam gainParam = audioParam;
            GainNode gainNode = context.createGain();
            gainParam.set(gainNode.gain());
            Predef$.MODULE$.println((Object)new StringBuilder(30).append("Creating gain node with gain: ").append(gainNode.gain().value()).toString());
            sources.foreach((Function1 & Serializable)source -> {
                AudioNode.create$$anonfun$1(context, gainNode, source);
                return BoxedUnit.UNIT;
            });
            gainNode.connect((org.scalajs.dom.AudioNode)context.destination());
            return gainNode;
        }
        if (audioNode instanceof Filter) {
            String string;
            Filter filter = AudioNode$Filter$.MODULE$.unapply((Filter)audioNode);
            List<AudioSource> list = filter._1();
            AudioParam audioParam = filter._2();
            AudioParam audioParam2 = filter._3();
            AudioTypes.FilterModel filterModel = filter._4();
            List<AudioSource> sources = list;
            AudioParam frequency = audioParam;
            AudioParam bandWidth = audioParam2;
            AudioTypes.FilterModel filterModel2 = filterModel;
            BiquadFilterNode filterNode = context.createBiquadFilter();
            frequency.set(filterNode.frequency());
            AudioTypes.FilterModel filterModel3 = filterModel2;
            AudioTypes.FilterModel filterModel4 = AudioTypes$FilterModel$.LowPass;
            AudioTypes.FilterModel filterModel5 = filterModel3;
            if (!(filterModel4 != null ? !filterModel4.equals(filterModel5) : filterModel5 != null)) {
                string = "lowpass";
            } else {
                AudioTypes.FilterModel filterModel6 = AudioTypes$FilterModel$.HighPass;
                AudioTypes.FilterModel filterModel7 = filterModel3;
                if (!(filterModel6 != null ? !filterModel6.equals(filterModel7) : filterModel7 != null)) {
                    string = "highpass";
                } else {
                    AudioTypes.FilterModel filterModel8 = AudioTypes$FilterModel$.BandPass;
                    AudioTypes.FilterModel filterModel9 = filterModel3;
                    if (!(filterModel8 != null ? !filterModel8.equals(filterModel9) : filterModel9 != null)) {
                        string = "bandpass";
                    } else {
                        AudioTypes.FilterModel filterModel10 = AudioTypes$FilterModel$.LowShelf;
                        AudioTypes.FilterModel filterModel11 = filterModel3;
                        if (!(filterModel10 != null ? !filterModel10.equals(filterModel11) : filterModel11 != null)) {
                            string = "lowshelf";
                        } else {
                            AudioTypes.FilterModel filterModel12 = AudioTypes$FilterModel$.HighShelf;
                            AudioTypes.FilterModel filterModel13 = filterModel3;
                            if (!(filterModel12 != null ? !filterModel12.equals(filterModel13) : filterModel13 != null)) {
                                string = "highshelf";
                            } else {
                                AudioTypes.FilterModel filterModel14 = AudioTypes$FilterModel$.Peaking;
                                AudioTypes.FilterModel filterModel15 = filterModel3;
                                if (!(filterModel14 != null ? !filterModel14.equals(filterModel15) : filterModel15 != null)) {
                                    string = "peaking";
                                } else {
                                    AudioTypes.FilterModel filterModel16 = AudioTypes$FilterModel$.Notch;
                                    AudioTypes.FilterModel filterModel17 = filterModel3;
                                    if (!(filterModel16 != null ? !filterModel16.equals(filterModel17) : filterModel17 != null)) {
                                        string = "notch";
                                    } else {
                                        AudioTypes.FilterModel filterModel18 = AudioTypes$FilterModel$.AllPass;
                                        AudioTypes.FilterModel filterModel19 = filterModel3;
                                        if (!(filterModel18 != null ? !filterModel18.equals(filterModel19) : filterModel19 != null)) {
                                            string = "allpass";
                                        } else {
                                            throw new MatchError((Object)filterModel3);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            filterNode.type_$eq(string);
            bandWidth.set(filterNode.Q());
            sources.foreach((Function1 & Serializable)source -> {
                AudioNode.create$$anonfun$2(context, filterNode, source);
                return BoxedUnit.UNIT;
            });
            return filterNode;
        }
        if (audioNode instanceof Delay) {
            Delay delay = AudioNode$Delay$.MODULE$.unapply((Delay)audioNode);
            List<AudioSource> list = delay._1();
            AudioParam audioParam = delay._2();
            List<AudioSource> sources = list;
            AudioParam delayTime = audioParam;
            DelayNode delayNode = context.createDelay(100);
            delayTime.set(delayNode.delayTime());
            sources.foreach((Function1 & Serializable)source -> {
                AudioNode.create$$anonfun$3(context, delayNode, source);
                return BoxedUnit.UNIT;
            });
            return delayNode;
        }
        if (audioNode instanceof SineOscillator) {
            SineOscillator sineOscillator = AudioNode$SineOscillator$.MODULE$.unapply((SineOscillator)audioNode);
            double d = sineOscillator._1();
            double d2 = sineOscillator._2();
            AudioParam audioParam = sineOscillator._3();
            AudioParam audioParam3 = sineOscillator._4();
            double when = d;
            double duration = d2;
            AudioParam frequency = audioParam;
            AudioParam detune = audioParam3;
            return this.buildOscillatorNode(when, duration, AudioTypes$WaveType$.Sine, frequency, detune, context);
        }
        if (audioNode instanceof SawtoothOscillator) {
            SawtoothOscillator sawtoothOscillator = AudioNode$SawtoothOscillator$.MODULE$.unapply((SawtoothOscillator)audioNode);
            double d = sawtoothOscillator._1();
            double d3 = sawtoothOscillator._2();
            AudioParam audioParam = sawtoothOscillator._3();
            AudioParam audioParam4 = sawtoothOscillator._4();
            double when = d;
            double duration = d3;
            AudioParam frequency = audioParam;
            AudioParam detune = audioParam4;
            return this.buildOscillatorNode(when, duration, AudioTypes$WaveType$.Sawtooth, frequency, detune, context);
        }
        if (audioNode instanceof TriangleOscillator) {
            TriangleOscillator triangleOscillator = AudioNode$TriangleOscillator$.MODULE$.unapply((TriangleOscillator)audioNode);
            double d = triangleOscillator._1();
            double d4 = triangleOscillator._2();
            AudioParam audioParam = triangleOscillator._3();
            AudioParam audioParam5 = triangleOscillator._4();
            double when = d;
            double duration = d4;
            AudioParam frequency = audioParam;
            AudioParam detune = audioParam5;
            return this.buildOscillatorNode(when, duration, AudioTypes$WaveType$.Triangle, frequency, detune, context);
        }
        if (audioNode instanceof SquareOscillator) {
            SquareOscillator squareOscillator = AudioNode$SquareOscillator$.MODULE$.unapply((SquareOscillator)audioNode);
            double d = squareOscillator._1();
            double d5 = squareOscillator._2();
            AudioParam audioParam = squareOscillator._3();
            AudioParam audioParam6 = squareOscillator._4();
            double when = d;
            double duration = d5;
            AudioParam frequency = audioParam;
            AudioParam detune = audioParam6;
            return this.buildOscillatorNode(when, duration, AudioTypes$WaveType$.Square, frequency, detune, context);
        }
        if (audioNode instanceof WaveTableOscillator) {
            WaveTableOscillator waveTableOscillator = AudioNode$WaveTableOscillator$.MODULE$.unapply((WaveTableOscillator)audioNode);
            double d = waveTableOscillator._1();
            double d6 = waveTableOscillator._2();
            AudioParam audioParam = waveTableOscillator._3();
            AudioParam audioParam7 = waveTableOscillator._4();
            Float32Array float32Array = waveTableOscillator._5();
            Float32Array float32Array2 = waveTableOscillator._6();
            double when = d;
            double duration = d6;
            AudioParam frequency = audioParam;
            AudioParam detune = audioParam7;
            Float32Array realArray = float32Array;
            Float32Array imagArray = float32Array2;
            PeriodicWave waveTable = context.createPeriodicWave(realArray, imagArray);
            OscillatorNode oscillatorNode = context.createOscillator();
            oscillatorNode.setPeriodicWave(waveTable);
            detune.set(oscillatorNode.detune());
            frequency.set(oscillatorNode.frequency());
            oscillatorNode.start(when);
            oscillatorNode.stop(when + duration + 0.4);
            return oscillatorNode;
        }
        throw new MatchError((Object)audioNode);
    }

    private OscillatorNode buildOscillatorNode(double when, double duration, AudioTypes.WaveType waveType, AudioParam frequency, AudioParam detune, AudioContext context) {
        OscillatorNode oscillatorNode = context.createOscillator();
        oscillatorNode.type_$eq(waveType.toString().toLowerCase());
        detune.set(oscillatorNode.detune());
        frequency.set(oscillatorNode.frequency());
        oscillatorNode.start(when);
        oscillatorNode.stop(when + duration);
        return oscillatorNode;
    }

    private static /* synthetic */ void create$$anonfun$1(AudioContext context$1, GainNode gainNode$1, AudioSource source) {
        source.create(context$1).connect((org.scalajs.dom.AudioNode)gainNode$1);
    }

    private static /* synthetic */ void create$$anonfun$2(AudioContext context$2, BiquadFilterNode filterNode$1, AudioSource source) {
        source.create(context$2).connect((org.scalajs.dom.AudioNode)filterNode$1);
    }

    private static /* synthetic */ void create$$anonfun$3(AudioContext context$3, DelayNode delayNode$1, AudioSource source) {
        source.create(context$3).connect((org.scalajs.dom.AudioNode)delayNode$1);
    }

    public static interface AudioPipe
    extends AudioSource {
        public AudioPipe addSource(AudioSource var1);
    }

    public static interface AudioSource
    extends AudioNode {
        public static AudioPipe pipeTo$(AudioSource $this, AudioPipe sink) {
            return $this.pipeTo(sink);
        }

        default public AudioPipe pipeTo(AudioPipe sink) {
            return sink.addSource(this);
        }
    }

    public static final class Delay
    implements AudioNode,
    AudioSource,
    AudioPipe,
    Product,
    Serializable {
        private final List<AudioSource> sources;
        private final AudioParam delayTime;

        public static Delay apply(List<AudioSource> list, AudioParam audioParam) {
            return AudioNode$Delay$.MODULE$.apply(list, audioParam);
        }

        public static Delay fromProduct(Product product) {
            return AudioNode$Delay$.MODULE$.fromProduct(product);
        }

        public static Delay unapply(Delay delay) {
            return AudioNode$Delay$.MODULE$.unapply(delay);
        }

        public Delay(List<AudioSource> sources, AudioParam delayTime) {
            this.sources = sources;
            this.delayTime = delayTime;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Delay)) return false;
            Delay delay = (Delay)object;
            List<AudioSource> list = this.sources();
            List<AudioSource> list2 = delay.sources();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            AudioParam audioParam = this.delayTime();
            AudioParam audioParam2 = delay.delayTime();
            if (audioParam == null) {
                if (audioParam2 == null) return true;
                return false;
            } else {
                if (!((Object)audioParam).equals(audioParam2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Delay;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Delay";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "sources";
            }
            if (1 == n2) {
                return "delayTime";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<AudioSource> sources() {
            return this.sources;
        }

        public AudioParam delayTime() {
            return this.delayTime;
        }

        @Override
        public AudioPipe addSource(AudioSource source) {
            return this.copy((List<AudioSource>)((List)this.sources().$colon$plus((Object)source)), this.copy$default$2());
        }

        public Delay withDelayTime(AudioParam delayTime) {
            return this.copy(this.copy$default$1(), delayTime);
        }

        public Delay copy(List<AudioSource> sources, AudioParam delayTime) {
            return new Delay(sources, delayTime);
        }

        public List<AudioSource> copy$default$1() {
            return this.sources();
        }

        public AudioParam copy$default$2() {
            return this.delayTime();
        }

        public List<AudioSource> _1() {
            return this.sources();
        }

        public AudioParam _2() {
            return this.delayTime();
        }
    }

    public static final class Filter
    implements AudioNode,
    AudioSource,
    AudioPipe,
    Product,
    Serializable {
        private final List<AudioSource> sources;
        private final AudioParam frequency;
        private final AudioParam bandWidth;
        private final AudioTypes.FilterModel filterType;

        public static Filter apply(List<AudioSource> list, AudioParam audioParam, AudioParam audioParam2, AudioTypes.FilterModel filterModel) {
            return AudioNode$Filter$.MODULE$.apply(list, audioParam, audioParam2, filterModel);
        }

        public static Filter fromProduct(Product product) {
            return AudioNode$Filter$.MODULE$.fromProduct(product);
        }

        public static Filter unapply(Filter filter) {
            return AudioNode$Filter$.MODULE$.unapply(filter);
        }

        public Filter(List<AudioSource> sources, AudioParam frequency, AudioParam bandWidth, AudioTypes.FilterModel filterType) {
            this.sources = sources;
            this.frequency = frequency;
            this.bandWidth = bandWidth;
            this.filterType = filterType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Filter)) return false;
            Filter filter = (Filter)object;
            List<AudioSource> list = this.sources();
            List<AudioSource> list2 = filter.sources();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            AudioParam audioParam = this.frequency();
            AudioParam audioParam2 = filter.frequency();
            if (audioParam == null) {
                if (audioParam2 != null) {
                    return false;
                }
            } else if (!((Object)audioParam).equals(audioParam2)) return false;
            AudioParam audioParam3 = this.bandWidth();
            AudioParam audioParam4 = filter.bandWidth();
            if (audioParam3 == null) {
                if (audioParam4 != null) {
                    return false;
                }
            } else if (!((Object)audioParam3).equals(audioParam4)) return false;
            AudioTypes.FilterModel filterModel = this.filterType();
            AudioTypes.FilterModel filterModel2 = filter.filterType();
            if (filterModel == null) {
                if (filterModel2 == null) return true;
                return false;
            } else {
                if (!filterModel.equals(filterModel2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Filter;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Filter";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "sources";
                }
                case 1: {
                    return "frequency";
                }
                case 2: {
                    return "bandWidth";
                }
                case 3: {
                    return "filterType";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<AudioSource> sources() {
            return this.sources;
        }

        public AudioParam frequency() {
            return this.frequency;
        }

        public AudioParam bandWidth() {
            return this.bandWidth;
        }

        public AudioTypes.FilterModel filterType() {
            return this.filterType;
        }

        @Override
        public AudioPipe addSource(AudioSource source) {
            return this.copy((List<AudioSource>)((List)this.sources().$colon$plus((Object)source)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
        }

        public Filter withFrequency(AudioParam frequency) {
            return this.copy(this.copy$default$1(), frequency, this.copy$default$3(), this.copy$default$4());
        }

        public Filter withBandWidth(AudioParam bandWidth) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), bandWidth, this.copy$default$4());
        }

        public Filter copy(List<AudioSource> sources, AudioParam frequency, AudioParam bandWidth, AudioTypes.FilterModel filterType) {
            return new Filter(sources, frequency, bandWidth, filterType);
        }

        public List<AudioSource> copy$default$1() {
            return this.sources();
        }

        public AudioParam copy$default$2() {
            return this.frequency();
        }

        public AudioParam copy$default$3() {
            return this.bandWidth();
        }

        public AudioTypes.FilterModel copy$default$4() {
            return this.filterType();
        }

        public List<AudioSource> _1() {
            return this.sources();
        }

        public AudioParam _2() {
            return this.frequency();
        }

        public AudioParam _3() {
            return this.bandWidth();
        }

        public AudioTypes.FilterModel _4() {
            return this.filterType();
        }
    }

    public static final class Gain
    implements AudioNode,
    AudioSource,
    AudioPipe,
    Product,
    Serializable {
        private final List<AudioSource> sources;
        private final AudioParam gain;

        public static Gain apply(List<AudioSource> list, AudioParam audioParam) {
            return AudioNode$Gain$.MODULE$.apply(list, audioParam);
        }

        public static Gain fromProduct(Product product) {
            return AudioNode$Gain$.MODULE$.fromProduct(product);
        }

        public static Gain unapply(Gain gain) {
            return AudioNode$Gain$.MODULE$.unapply(gain);
        }

        public Gain(List<AudioSource> sources, AudioParam gain) {
            this.sources = sources;
            this.gain = gain;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Gain)) return false;
            Gain gain = (Gain)object;
            List<AudioSource> list = this.sources();
            List<AudioSource> list2 = gain.sources();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            AudioParam audioParam = this.gain();
            AudioParam audioParam2 = gain.gain();
            if (audioParam == null) {
                if (audioParam2 == null) return true;
                return false;
            } else {
                if (!((Object)audioParam).equals(audioParam2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Gain;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Gain";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "sources";
            }
            if (1 == n2) {
                return "gain";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<AudioSource> sources() {
            return this.sources;
        }

        public AudioParam gain() {
            return this.gain;
        }

        @Override
        public AudioPipe addSource(AudioSource source) {
            return this.copy((List<AudioSource>)((List)this.sources().$colon$plus((Object)source)), this.copy$default$2());
        }

        public Gain withGain(AudioParam gain) {
            return this.copy(this.copy$default$1(), gain);
        }

        public Gain copy(List<AudioSource> sources, AudioParam gain) {
            return new Gain(sources, gain);
        }

        public List<AudioSource> copy$default$1() {
            return this.sources();
        }

        public AudioParam copy$default$2() {
            return this.gain();
        }

        public List<AudioSource> _1() {
            return this.sources();
        }

        public AudioParam _2() {
            return this.gain();
        }
    }

    public static final class SawtoothOscillator
    implements AudioNode,
    AudioSource,
    Product,
    Serializable {
        private final double when;
        private final double duration;
        private final AudioParam frequency;
        private final AudioParam detune;

        public static SawtoothOscillator apply(double d, double d2, AudioParam audioParam, AudioParam audioParam2) {
            return AudioNode$SawtoothOscillator$.MODULE$.apply(d, d2, audioParam, audioParam2);
        }

        public static SawtoothOscillator fromProduct(Product product) {
            return AudioNode$SawtoothOscillator$.MODULE$.fromProduct(product);
        }

        public static SawtoothOscillator unapply(SawtoothOscillator sawtoothOscillator) {
            return AudioNode$SawtoothOscillator$.MODULE$.unapply(sawtoothOscillator);
        }

        public SawtoothOscillator(double when, double duration, AudioParam frequency, AudioParam detune) {
            this.when = when;
            this.duration = duration;
            this.frequency = frequency;
            this.detune = detune;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.when()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.duration()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.frequency()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.detune()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SawtoothOscillator)) return false;
            SawtoothOscillator sawtoothOscillator = (SawtoothOscillator)object;
            if (this.when() != sawtoothOscillator.when()) return false;
            if (this.duration() != sawtoothOscillator.duration()) return false;
            AudioParam audioParam = this.frequency();
            AudioParam audioParam2 = sawtoothOscillator.frequency();
            if (audioParam == null) {
                if (audioParam2 != null) {
                    return false;
                }
            } else if (!((Object)audioParam).equals(audioParam2)) return false;
            AudioParam audioParam3 = this.detune();
            AudioParam audioParam4 = sawtoothOscillator.detune();
            if (audioParam3 == null) {
                if (audioParam4 == null) return true;
                return false;
            } else {
                if (!((Object)audioParam3).equals(audioParam4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SawtoothOscillator;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "SawtoothOscillator";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "when";
                }
                case 1: {
                    return "duration";
                }
                case 2: {
                    return "frequency";
                }
                case 3: {
                    return "detune";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double when() {
            return this.when;
        }

        public double duration() {
            return this.duration;
        }

        public AudioParam frequency() {
            return this.frequency;
        }

        public AudioParam detune() {
            return this.detune;
        }

        public SawtoothOscillator withFrequency(AudioParam frequency) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), frequency, this.copy$default$4());
        }

        public SawtoothOscillator withDetune(AudioParam detune) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), detune);
        }

        public SawtoothOscillator copy(double when, double duration, AudioParam frequency, AudioParam detune) {
            return new SawtoothOscillator(when, duration, frequency, detune);
        }

        public double copy$default$1() {
            return this.when();
        }

        public double copy$default$2() {
            return this.duration();
        }

        public AudioParam copy$default$3() {
            return this.frequency();
        }

        public AudioParam copy$default$4() {
            return this.detune();
        }

        public double _1() {
            return this.when();
        }

        public double _2() {
            return this.duration();
        }

        public AudioParam _3() {
            return this.frequency();
        }

        public AudioParam _4() {
            return this.detune();
        }
    }

    public static final class SineOscillator
    implements AudioNode,
    AudioSource,
    Product,
    Serializable {
        private final double when;
        private final double duration;
        private final AudioParam frequency;
        private final AudioParam detune;

        public static SineOscillator apply(double d, double d2, AudioParam audioParam, AudioParam audioParam2) {
            return AudioNode$SineOscillator$.MODULE$.apply(d, d2, audioParam, audioParam2);
        }

        public static SineOscillator fromProduct(Product product) {
            return AudioNode$SineOscillator$.MODULE$.fromProduct(product);
        }

        public static SineOscillator unapply(SineOscillator sineOscillator) {
            return AudioNode$SineOscillator$.MODULE$.unapply(sineOscillator);
        }

        public SineOscillator(double when, double duration, AudioParam frequency, AudioParam detune) {
            this.when = when;
            this.duration = duration;
            this.frequency = frequency;
            this.detune = detune;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.when()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.duration()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.frequency()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.detune()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SineOscillator)) return false;
            SineOscillator sineOscillator = (SineOscillator)object;
            if (this.when() != sineOscillator.when()) return false;
            if (this.duration() != sineOscillator.duration()) return false;
            AudioParam audioParam = this.frequency();
            AudioParam audioParam2 = sineOscillator.frequency();
            if (audioParam == null) {
                if (audioParam2 != null) {
                    return false;
                }
            } else if (!((Object)audioParam).equals(audioParam2)) return false;
            AudioParam audioParam3 = this.detune();
            AudioParam audioParam4 = sineOscillator.detune();
            if (audioParam3 == null) {
                if (audioParam4 == null) return true;
                return false;
            } else {
                if (!((Object)audioParam3).equals(audioParam4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SineOscillator;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "SineOscillator";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "when";
                }
                case 1: {
                    return "duration";
                }
                case 2: {
                    return "frequency";
                }
                case 3: {
                    return "detune";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double when() {
            return this.when;
        }

        public double duration() {
            return this.duration;
        }

        public AudioParam frequency() {
            return this.frequency;
        }

        public AudioParam detune() {
            return this.detune;
        }

        public SineOscillator withFrequency(AudioParam frequency) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), frequency, this.copy$default$4());
        }

        public SineOscillator withDetune(AudioParam detune) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), detune);
        }

        public SineOscillator copy(double when, double duration, AudioParam frequency, AudioParam detune) {
            return new SineOscillator(when, duration, frequency, detune);
        }

        public double copy$default$1() {
            return this.when();
        }

        public double copy$default$2() {
            return this.duration();
        }

        public AudioParam copy$default$3() {
            return this.frequency();
        }

        public AudioParam copy$default$4() {
            return this.detune();
        }

        public double _1() {
            return this.when();
        }

        public double _2() {
            return this.duration();
        }

        public AudioParam _3() {
            return this.frequency();
        }

        public AudioParam _4() {
            return this.detune();
        }
    }

    public static final class SquareOscillator
    implements AudioNode,
    AudioSource,
    Product,
    Serializable {
        private final double when;
        private final double duration;
        private final AudioParam frequency;
        private final AudioParam detune;

        public static SquareOscillator apply(double d, double d2, AudioParam audioParam, AudioParam audioParam2) {
            return AudioNode$SquareOscillator$.MODULE$.apply(d, d2, audioParam, audioParam2);
        }

        public static SquareOscillator fromProduct(Product product) {
            return AudioNode$SquareOscillator$.MODULE$.fromProduct(product);
        }

        public static SquareOscillator unapply(SquareOscillator squareOscillator) {
            return AudioNode$SquareOscillator$.MODULE$.unapply(squareOscillator);
        }

        public SquareOscillator(double when, double duration, AudioParam frequency, AudioParam detune) {
            this.when = when;
            this.duration = duration;
            this.frequency = frequency;
            this.detune = detune;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.when()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.duration()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.frequency()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.detune()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SquareOscillator)) return false;
            SquareOscillator squareOscillator = (SquareOscillator)object;
            if (this.when() != squareOscillator.when()) return false;
            if (this.duration() != squareOscillator.duration()) return false;
            AudioParam audioParam = this.frequency();
            AudioParam audioParam2 = squareOscillator.frequency();
            if (audioParam == null) {
                if (audioParam2 != null) {
                    return false;
                }
            } else if (!((Object)audioParam).equals(audioParam2)) return false;
            AudioParam audioParam3 = this.detune();
            AudioParam audioParam4 = squareOscillator.detune();
            if (audioParam3 == null) {
                if (audioParam4 == null) return true;
                return false;
            } else {
                if (!((Object)audioParam3).equals(audioParam4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SquareOscillator;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "SquareOscillator";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "when";
                }
                case 1: {
                    return "duration";
                }
                case 2: {
                    return "frequency";
                }
                case 3: {
                    return "detune";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double when() {
            return this.when;
        }

        public double duration() {
            return this.duration;
        }

        public AudioParam frequency() {
            return this.frequency;
        }

        public AudioParam detune() {
            return this.detune;
        }

        public SquareOscillator withFrequency(AudioParam frequency) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), frequency, this.copy$default$4());
        }

        public SquareOscillator withDetune(AudioParam detune) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), detune);
        }

        public SquareOscillator copy(double when, double duration, AudioParam frequency, AudioParam detune) {
            return new SquareOscillator(when, duration, frequency, detune);
        }

        public double copy$default$1() {
            return this.when();
        }

        public double copy$default$2() {
            return this.duration();
        }

        public AudioParam copy$default$3() {
            return this.frequency();
        }

        public AudioParam copy$default$4() {
            return this.detune();
        }

        public double _1() {
            return this.when();
        }

        public double _2() {
            return this.duration();
        }

        public AudioParam _3() {
            return this.frequency();
        }

        public AudioParam _4() {
            return this.detune();
        }
    }

    public static final class TriangleOscillator
    implements AudioNode,
    AudioSource,
    Product,
    Serializable {
        private final double when;
        private final double duration;
        private final AudioParam frequency;
        private final AudioParam detune;

        public static TriangleOscillator apply(double d, double d2, AudioParam audioParam, AudioParam audioParam2) {
            return AudioNode$TriangleOscillator$.MODULE$.apply(d, d2, audioParam, audioParam2);
        }

        public static TriangleOscillator fromProduct(Product product) {
            return AudioNode$TriangleOscillator$.MODULE$.fromProduct(product);
        }

        public static TriangleOscillator unapply(TriangleOscillator triangleOscillator) {
            return AudioNode$TriangleOscillator$.MODULE$.unapply(triangleOscillator);
        }

        public TriangleOscillator(double when, double duration, AudioParam frequency, AudioParam detune) {
            this.when = when;
            this.duration = duration;
            this.frequency = frequency;
            this.detune = detune;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.when()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.duration()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.frequency()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.detune()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TriangleOscillator)) return false;
            TriangleOscillator triangleOscillator = (TriangleOscillator)object;
            if (this.when() != triangleOscillator.when()) return false;
            if (this.duration() != triangleOscillator.duration()) return false;
            AudioParam audioParam = this.frequency();
            AudioParam audioParam2 = triangleOscillator.frequency();
            if (audioParam == null) {
                if (audioParam2 != null) {
                    return false;
                }
            } else if (!((Object)audioParam).equals(audioParam2)) return false;
            AudioParam audioParam3 = this.detune();
            AudioParam audioParam4 = triangleOscillator.detune();
            if (audioParam3 == null) {
                if (audioParam4 == null) return true;
                return false;
            } else {
                if (!((Object)audioParam3).equals(audioParam4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TriangleOscillator;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "TriangleOscillator";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "when";
                }
                case 1: {
                    return "duration";
                }
                case 2: {
                    return "frequency";
                }
                case 3: {
                    return "detune";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double when() {
            return this.when;
        }

        public double duration() {
            return this.duration;
        }

        public AudioParam frequency() {
            return this.frequency;
        }

        public AudioParam detune() {
            return this.detune;
        }

        public TriangleOscillator withFrequency(AudioParam frequency) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), frequency, this.copy$default$4());
        }

        public TriangleOscillator withDetune(AudioParam detune) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), detune);
        }

        public TriangleOscillator copy(double when, double duration, AudioParam frequency, AudioParam detune) {
            return new TriangleOscillator(when, duration, frequency, detune);
        }

        public double copy$default$1() {
            return this.when();
        }

        public double copy$default$2() {
            return this.duration();
        }

        public AudioParam copy$default$3() {
            return this.frequency();
        }

        public AudioParam copy$default$4() {
            return this.detune();
        }

        public double _1() {
            return this.when();
        }

        public double _2() {
            return this.duration();
        }

        public AudioParam _3() {
            return this.frequency();
        }

        public AudioParam _4() {
            return this.detune();
        }
    }

    public static final class WaveTableOscillator
    implements AudioNode,
    AudioSource,
    Product,
    Serializable {
        private final double when;
        private final double duration;
        private final AudioParam frequency;
        private final AudioParam detune;
        private final Float32Array realArray;
        private final Float32Array imaginaryArray;

        public static WaveTableOscillator apply(double d, double d2, AudioParam audioParam, AudioParam audioParam2, Float32Array float32Array, Float32Array float32Array2) {
            return AudioNode$WaveTableOscillator$.MODULE$.apply(d, d2, audioParam, audioParam2, float32Array, float32Array2);
        }

        public static WaveTableOscillator fromProduct(Product product) {
            return AudioNode$WaveTableOscillator$.MODULE$.fromProduct(product);
        }

        public static WaveTableOscillator unapply(WaveTableOscillator waveTableOscillator) {
            return AudioNode$WaveTableOscillator$.MODULE$.unapply(waveTableOscillator);
        }

        public WaveTableOscillator(double when, double duration, AudioParam frequency, AudioParam detune, Float32Array realArray, Float32Array imaginaryArray) {
            this.when = when;
            this.duration = duration;
            this.frequency = frequency;
            this.detune = detune;
            this.realArray = realArray;
            this.imaginaryArray = imaginaryArray;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.when()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.duration()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.frequency()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.detune()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.realArray()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.imaginaryArray()));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WaveTableOscillator)) return false;
            WaveTableOscillator waveTableOscillator = (WaveTableOscillator)object;
            if (this.when() != waveTableOscillator.when()) return false;
            if (this.duration() != waveTableOscillator.duration()) return false;
            AudioParam audioParam = this.frequency();
            AudioParam audioParam2 = waveTableOscillator.frequency();
            if (audioParam == null) {
                if (audioParam2 != null) {
                    return false;
                }
            } else if (!((Object)audioParam).equals(audioParam2)) return false;
            AudioParam audioParam3 = this.detune();
            AudioParam audioParam4 = waveTableOscillator.detune();
            if (audioParam3 == null) {
                if (audioParam4 != null) {
                    return false;
                }
            } else if (!((Object)audioParam3).equals(audioParam4)) return false;
            Float32Array float32Array = this.realArray();
            Float32Array float32Array2 = waveTableOscillator.realArray();
            if (float32Array == null) {
                if (float32Array2 != null) {
                    return false;
                }
            } else if (!float32Array.equals(float32Array2)) return false;
            Float32Array float32Array3 = this.imaginaryArray();
            Float32Array float32Array4 = waveTableOscillator.imaginaryArray();
            if (float32Array3 == null) {
                if (float32Array4 == null) return true;
                return false;
            } else {
                if (!float32Array3.equals(float32Array4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WaveTableOscillator;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "WaveTableOscillator";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "when";
                }
                case 1: {
                    return "duration";
                }
                case 2: {
                    return "frequency";
                }
                case 3: {
                    return "detune";
                }
                case 4: {
                    return "realArray";
                }
                case 5: {
                    return "imaginaryArray";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double when() {
            return this.when;
        }

        public double duration() {
            return this.duration;
        }

        public AudioParam frequency() {
            return this.frequency;
        }

        public AudioParam detune() {
            return this.detune;
        }

        public Float32Array realArray() {
            return this.realArray;
        }

        public Float32Array imaginaryArray() {
            return this.imaginaryArray;
        }

        public WaveTableOscillator withFrequency(AudioParam frequency) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), frequency, this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }

        public WaveTableOscillator withDetune(AudioParam detune) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), detune, this.copy$default$5(), this.copy$default$6());
        }

        public WaveTableOscillator copy(double when, double duration, AudioParam frequency, AudioParam detune, Float32Array realArray, Float32Array imaginaryArray) {
            return new WaveTableOscillator(when, duration, frequency, detune, realArray, imaginaryArray);
        }

        public double copy$default$1() {
            return this.when();
        }

        public double copy$default$2() {
            return this.duration();
        }

        public AudioParam copy$default$3() {
            return this.frequency();
        }

        public AudioParam copy$default$4() {
            return this.detune();
        }

        public Float32Array copy$default$5() {
            return this.realArray();
        }

        public Float32Array copy$default$6() {
            return this.imaginaryArray();
        }

        public double _1() {
            return this.when();
        }

        public double _2() {
            return this.duration();
        }

        public AudioParam _3() {
            return this.frequency();
        }

        public AudioParam _4() {
            return this.detune();
        }

        public Float32Array _5() {
            return this.realArray();
        }

        public Float32Array _6() {
            return this.imaginaryArray();
        }
    }
}

