/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.s2ks;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.soulwing.s2ks.Metadata;

public final class SimpleMetadata
implements Metadata {
    private static final SimpleMetadata EMPTY = new SimpleMetadata(Collections.emptyMap());
    private final Map<String, Object> delegate;

    private SimpleMetadata(Map<String, Object> delegate) {
        this.delegate = delegate;
    }

    public static Metadata empty() {
        return EMPTY;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Set<String> names() {
        return this.delegate.keySet();
    }

    @Override
    public Map<String, Object> toMap() {
        return new HashMap<String, Object>(this.delegate);
    }

    @Override
    public <T> T get(String name, Class<? extends T> type) {
        Object value = this.delegate.get(name);
        if (Number.class.isAssignableFrom(type) && value instanceof Number && !type.isInstance(value)) {
            if (Integer.class.equals(type)) {
                value = ((Number)value).intValue();
            } else if (Long.class.equals(type)) {
                value = ((Number)value).longValue();
            } else if (Double.class.equals(type)) {
                value = ((Number)value).doubleValue();
            }
        }
        return type.cast(value);
    }

    public int hashCode() {
        return this.toMap().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Metadata && ((Metadata)obj).toMap().equals(this.toMap());
    }

    public static class Builder
    implements Metadata.Builder {
        private Map<String, Object> metadata = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Metadata.Builder set(String name, Object value) {
            if (value instanceof String) {
                this.metadata.put(name, value);
            } else if (value instanceof Integer) {
                this.metadata.put(name, value);
            } else if (value instanceof Long) {
                this.metadata.put(name, value);
            } else if (value instanceof Boolean) {
                this.metadata.put(name, value);
            } else if (value instanceof Double) {
                this.metadata.put(name, value);
            } else {
                throw new IllegalArgumentException("value type must be string, boolean, integer, long, or double; not " + value.getClass().getSimpleName());
            }
            return this;
        }

        @Override
        public Metadata build() {
            return new SimpleMetadata(this.metadata);
        }
    }
}

