/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.s2ks;

import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.soulwing.s2ks.KeyStorage;
import org.soulwing.s2ks.MutableKeyStorage;
import org.soulwing.s2ks.NoSuchProviderException;
import org.soulwing.s2ks.ProviderConfigurationException;
import org.soulwing.s2ks.spi.KeyStorageProvider;

public final class KeyStorageLocator {
    public static KeyStorage getInstance(String provider, Properties properties) throws NoSuchProviderException, ProviderConfigurationException {
        return KeyStorageLocator.getInstance(provider, properties, () -> ServiceLoader.load(KeyStorageProvider.class));
    }

    public static KeyStorage getInstance(String provider, Properties properties, Supplier<ServiceLoader<KeyStorageProvider>> loader) throws NoSuchProviderException, ProviderConfigurationException {
        try {
            return KeyStorageLocator.getProviderInstance(loader, p -> p.getName().equals(provider)).orElseThrow(() -> new NoSuchProviderException(provider)).getInstance(properties);
        }
        catch (Exception ex) {
            throw new ProviderConfigurationException(ex.toString(), ex);
        }
    }

    public static MutableKeyStorage getMutableInstance(String provider, Properties properties) throws NoSuchProviderException, ProviderConfigurationException {
        return KeyStorageLocator.getMutableInstance(provider, properties, () -> ServiceLoader.load(KeyStorageProvider.class));
    }

    public static MutableKeyStorage getMutableInstance(String provider, Properties properties, Supplier<ServiceLoader<KeyStorageProvider>> loader) throws NoSuchProviderException, ProviderConfigurationException {
        try {
            return (MutableKeyStorage)KeyStorageLocator.getProviderInstance(loader, p -> p.getName().equals(provider) && p.isMutable()).orElseThrow(() -> new NoSuchProviderException(provider)).getInstance(properties);
        }
        catch (Exception ex) {
            throw new ProviderConfigurationException(ex.getMessage(), ex);
        }
    }

    private static Optional<KeyStorageProvider> getProviderInstance(Supplier<ServiceLoader<KeyStorageProvider>> loader, Predicate<KeyStorageProvider> predicate) {
        return StreamSupport.stream(loader.get().spliterator(), false).filter(predicate).findFirst();
    }
}

