/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.s2ks;

import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.soulwing.s2ks.KeyPairStorage;
import org.soulwing.s2ks.NoSuchProviderException;
import org.soulwing.s2ks.ProviderConfigurationException;
import org.soulwing.s2ks.spi.KeyPairStorageProvider;

public final class KeyPairStorageLocator {
    public static KeyPairStorage getInstance(String provider, Properties configuration) throws NoSuchProviderException, ProviderConfigurationException {
        return KeyPairStorageLocator.getInstance(provider, configuration, () -> ServiceLoader.load(KeyPairStorageProvider.class));
    }

    public static KeyPairStorage getInstance(String provider, Properties configuration, Supplier<ServiceLoader<KeyPairStorageProvider>> loader) throws NoSuchProviderException, ProviderConfigurationException {
        try {
            return KeyPairStorageLocator.getProviderInstance(loader, p -> p.getName().equals(provider)).orElseThrow(() -> new NoSuchProviderException(provider)).getInstance(configuration);
        }
        catch (NoSuchProviderException | ProviderConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ProviderConfigurationException(ex.toString(), ex);
        }
    }

    private static Optional<KeyPairStorageProvider> getProviderInstance(Supplier<ServiceLoader<KeyPairStorageProvider>> loader, Predicate<KeyPairStorageProvider> predicate) {
        return StreamSupport.stream(loader.get().spliterator(), false).filter(predicate).findFirst();
    }
}

