/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.s2ks;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KeyPairInfo {
    private String id;
    private PrivateKey privateKey;
    private List<X509Certificate> certificates = new ArrayList<X509Certificate>();

    private KeyPairInfo() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public List<X509Certificate> getCertificates() {
        return Collections.unmodifiableList(this.certificates);
    }

    public static class Builder {
        private final KeyPairInfo info = new KeyPairInfo();

        private Builder() {
        }

        public Builder id(String id) {
            this.info.id = id;
            return this;
        }

        public Builder privateKey(PrivateKey privateKey) {
            this.info.privateKey = privateKey;
            return this;
        }

        public Builder certificates(List<X509Certificate> certificates) {
            this.info.certificates.addAll(certificates);
            return this;
        }

        public KeyPairInfo build() {
            if (this.info.privateKey == null) {
                throw new IllegalArgumentException("privateKey is required");
            }
            return this.info;
        }
    }
}

