/*
 * File created on Apr 8, 2016
 *
 * Copyright (c) 2016 Carl Harris, Jr
 * and others as noted
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.soulwing.prospecto.demo.jaxrs.service;

import javax.persistence.EntityManager;

import org.soulwing.prospecto.api.View;
import org.soulwing.prospecto.api.ViewContext;
import org.soulwing.prospecto.demo.jaxrs.domain.AbstractEntity;

/**
 * An abstract CRUD service for an entity type.
 *
 * @author Carl Harris
 */
public interface EntityService<T extends AbstractEntity> {

  View findById(Long id) throws NoSuchEntityException;

  T newEntity(View view);

  Object create(View view);

  View update(Long id, View view)
      throws UpdateConflictException, NoSuchEntityException;

  void delete(Long id);

  void setViewContext(ViewContext viewContext);

  void setEntityManager(EntityManager entityManager);

}
