CREATE USER IF NOT EXISTS SA SALT 'd237dea14419e4d0' HASH 'f0ec570b58ce37246b7e72a45ce987703e6fb352dda69326e08a47a6808d2df7' ADMIN;
DROP TABLE IF EXISTS PUBLIC.CONTACT CASCADE;
DROP TABLE IF EXISTS PUBLIC.DIVISION CASCADE;
DROP TABLE IF EXISTS PUBLIC.LEAGUE CASCADE;
DROP TABLE IF EXISTS PUBLIC.PARENT CASCADE;
DROP TABLE IF EXISTS PUBLIC.PHONE CASCADE;
DROP TABLE IF EXISTS PUBLIC.PHYSICAL_ADDRESS CASCADE;
DROP TABLE IF EXISTS PUBLIC.PLAYER CASCADE;
DROP TABLE IF EXISTS PUBLIC.ROSTER_PLAYER CASCADE;
DROP TABLE IF EXISTS PUBLIC.TEAM CASCADE;
DROP TABLE IF EXISTS PUBLIC.TEAM_COACH CASCADE;
DROP SEQUENCE IF EXISTS PUBLIC.HIBERNATE_SEQUENCE;
CREATE SEQUENCE PUBLIC.HIBERNATE_SEQUENCE START WITH 104;
CREATE MEMORY TABLE PUBLIC.CONTACT(
    CONTACT_TYPE VARCHAR(31) NOT NULL,
    ID BIGINT NOT NULL,
    VERSION BIGINT,
    GENDER VARCHAR(255),
    GIVEN_NAMES VARCHAR(255) NOT NULL,
    PREFERRED_NAME VARCHAR(255),
    SURNAME VARCHAR(255) NOT NULL,
    EMAIL_ADDRESS VARCHAR(255),
    MAILING_ADDRESS_ID BIGINT
);
ALTER TABLE PUBLIC.CONTACT ADD CONSTRAINT PUBLIC.CONSTRAINT_6 PRIMARY KEY(ID);
-- 22 +/- SELECT COUNT(*) FROM PUBLIC.CONTACT;
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 5, 0, NULL, 'Melissa', NULL, 'Phillips', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 8, 0, NULL, 'David', NULL, 'Bell', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 10, 0, NULL, 'Travis', NULL, 'Phillips', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 12, 0, NULL, 'Betty', NULL, 'Lewis', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 19, 0, NULL, 'Patricia', NULL, 'Groeschel', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 21, 0, NULL, 'Patrick', NULL, 'Groeschel', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 27, 0, NULL, 'Katherine', 'Kate', 'Costich', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 32, 0, NULL, 'Stephanie', NULL, 'Claxton', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 34, 0, NULL, 'Richard', 'Rick', 'Claxton', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 40, 0, NULL, 'Dianne', NULL, 'Alexander', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 45, 0, NULL, 'Steve', NULL, 'Johnson', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 47, 0, NULL, 'Melissa', NULL, 'Reed', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 52, 0, NULL, 'Ashley', NULL, 'Young', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 54, 0, NULL, 'Darren', NULL, 'Young', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 58, 0, NULL, 'Josh', NULL, 'Manning', 'jmanning@bds.org', NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 71, 0, NULL, 'Candice', 'Candy', 'Martin', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 73, 0, NULL, 'James', NULL, 'Martin', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 82, 0, NULL, 'Lynn', NULL, 'Callaghan', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 84, 0, NULL, 'Scott', NULL, 'Callaghan', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 90, 0, NULL, 'Laura', NULL, 'Strickland', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 92, 0, NULL, 'Mark', NULL, 'Tompkins', NULL, NULL);
INSERT INTO PUBLIC.CONTACT(CONTACT_TYPE, ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, EMAIL_ADDRESS, MAILING_ADDRESS_ID) VALUES('Contact', 96, 0, NULL, 'Paul', NULL, 'Anderson', 'panders@gmail.com', NULL);
CREATE MEMORY TABLE PUBLIC.DIVISION(
    ID BIGINT NOT NULL,
    VERSION BIGINT,
    AGE_LIMIT INTEGER,
    GENDER VARCHAR(255),
    NAME VARCHAR(255) NOT NULL,
    LEAGUE_ID BIGINT NOT NULL
);
ALTER TABLE PUBLIC.DIVISION ADD CONSTRAINT PUBLIC.CONSTRAINT_4 PRIMARY KEY(ID);
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.DIVISION;
INSERT INTO PUBLIC.DIVISION(ID, VERSION, AGE_LIMIT, GENDER, NAME, LEAGUE_ID) VALUES(2, 0, 10, 'FEMALE', 'Angels', 1);
INSERT INTO PUBLIC.DIVISION(ID, VERSION, AGE_LIMIT, GENDER, NAME, LEAGUE_ID) VALUES(68, 0, 12, 'FEMALE', 'Ponytails', 1);
INSERT INTO PUBLIC.DIVISION(ID, VERSION, AGE_LIMIT, GENDER, NAME, LEAGUE_ID) VALUES(103, 0, 15, 'FEMALE', 'Belles', 1);
CREATE MEMORY TABLE PUBLIC.LEAGUE(
    ID BIGINT NOT NULL,
    VERSION BIGINT,
    NAME VARCHAR(255) NOT NULL
);
ALTER TABLE PUBLIC.LEAGUE ADD CONSTRAINT PUBLIC.CONSTRAINT_8 PRIMARY KEY(ID);
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.LEAGUE;
INSERT INTO PUBLIC.LEAGUE(ID, VERSION, NAME) VALUES(1, 0, 'Blacksburg Dixie Softball');
CREATE MEMORY TABLE PUBLIC.PARENT(
    ID BIGINT NOT NULL,
    VERSION BIGINT,
    RELATIONSHIP INTEGER,
    CONTACT_ID BIGINT NOT NULL,
    PLAYER_ID BIGINT
);
ALTER TABLE PUBLIC.PARENT ADD CONSTRAINT PUBLIC.CONSTRAINT_8C PRIMARY KEY(ID);
-- 19 +/- SELECT COUNT(*) FROM PUBLIC.PARENT;
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(14, 0, 0, 5, 3);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(15, 0, 1, 8, 3);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(16, 0, 2, 10, 3);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(23, 0, 0, 19, 17);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(24, 0, 1, 21, 17);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(29, 0, 0, 27, 25);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(36, 0, 0, 32, 30);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(37, 0, 1, 34, 30);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(42, 0, 0, 40, 38);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(49, 0, 1, 45, 43);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(56, 0, 0, 52, 50);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(57, 0, 1, 54, 50);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(75, 0, 0, 71, 69);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(76, 0, 1, 73, 69);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(79, 0, 0, 27, 77);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(86, 0, 0, 82, 80);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(87, 0, 1, 84, 80);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(94, 0, 0, 90, 88);
INSERT INTO PUBLIC.PARENT(ID, VERSION, RELATIONSHIP, CONTACT_ID, PLAYER_ID) VALUES(95, 0, 1, 92, 88);
CREATE MEMORY TABLE PUBLIC.PHONE(
    ID BIGINT NOT NULL,
    VERSION BIGINT,
    LABEL VARCHAR(255),
    PHONE_NUMBER VARCHAR(255),
    TEXT_ENABLED BOOLEAN,
    CONTACT_ID BIGINT,
    LIST_INDEX INTEGER
);
ALTER TABLE PUBLIC.PHONE ADD CONSTRAINT PUBLIC.CONSTRAINT_48 PRIMARY KEY(ID);
-- 23 +/- SELECT COUNT(*) FROM PUBLIC.PHONE;
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(6, 0, 'Mobile', '5412300169', TRUE, 5, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(7, 0, 'Home', '5419534423', FALSE, 5, 1);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(9, 0, 'Mobile', '7538383504', TRUE, 8, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(11, 0, 'Mobile', '5412307323', TRUE, 10, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(13, 0, 'Mobile', '5418182217', TRUE, 12, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(20, 0, 'Mobile', '5412314319', TRUE, 19, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(22, 0, 'Mobile', '5412314320', TRUE, 21, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(28, 0, 'Mobile', '5418186556', TRUE, 27, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(33, 0, 'Mobile', '8012881883', TRUE, 32, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(35, 0, 'Mobile', '8012864184', TRUE, 34, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(41, 0, 'Mobile', '5418196597', TRUE, 40, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(46, 0, 'Home', '8017238817', FALSE, 45, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(48, 0, 'Home', '8017226354', FALSE, 47, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(53, 0, 'Mobile', '5418181323', TRUE, 52, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(55, 0, 'Mobile', '5418190158', TRUE, 54, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(59, 0, 'Mobile', '5412232145', TRUE, 58, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(72, 0, 'Mobile', '5412312599', TRUE, 71, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(74, 0, 'Mobile', '5412318733', TRUE, 73, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(83, 0, 'Mobile', '5418189132', TRUE, 82, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(85, 0, 'Mobile', '5412318559', TRUE, 84, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(91, 0, 'Mobile', '5418081227', TRUE, 90, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(93, 0, 'Mobile', '7587221827', TRUE, 92, 0);
INSERT INTO PUBLIC.PHONE(ID, VERSION, LABEL, PHONE_NUMBER, TEXT_ENABLED, CONTACT_ID, LIST_INDEX) VALUES(97, 0, 'Mobile', '541818772', TRUE, 96, 0);
CREATE MEMORY TABLE PUBLIC.PHYSICAL_ADDRESS(
    ID BIGINT NOT NULL,
    VERSION BIGINT,
    MUNICIPALITY VARCHAR(255),
    POSTAL_CODE VARCHAR(255),
    STATE VARCHAR(255),
    STREET_ADDRESS VARCHAR(255)
);
ALTER TABLE PUBLIC.PHYSICAL_ADDRESS ADD CONSTRAINT PUBLIC.CONSTRAINT_45 PRIMARY KEY(ID);
-- 11 +/- SELECT COUNT(*) FROM PUBLIC.PHYSICAL_ADDRESS;
INSERT INTO PUBLIC.PHYSICAL_ADDRESS(ID, VERSION, MUNICIPALITY, POSTAL_CODE, STATE, STREET_ADDRESS) VALUES(4, 0, NULL, NULL, NULL, NULL);
INSERT INTO PUBLIC.PHYSICAL_ADDRESS(ID, VERSION, MUNICIPALITY, POSTAL_CODE, STATE, STREET_ADDRESS) VALUES(18, 0, NULL, NULL, NULL, NULL);
INSERT INTO PUBLIC.PHYSICAL_ADDRESS(ID, VERSION, MUNICIPALITY, POSTAL_CODE, STATE, STREET_ADDRESS) VALUES(26, 0, NULL, NULL, NULL, NULL);
INSERT INTO PUBLIC.PHYSICAL_ADDRESS(ID, VERSION, MUNICIPALITY, POSTAL_CODE, STATE, STREET_ADDRESS) VALUES(31, 0, NULL, NULL, NULL, NULL);
INSERT INTO PUBLIC.PHYSICAL_ADDRESS(ID, VERSION, MUNICIPALITY, POSTAL_CODE, STATE, STREET_ADDRESS) VALUES(39, 0, NULL, NULL, NULL, NULL);
INSERT INTO PUBLIC.PHYSICAL_ADDRESS(ID, VERSION, MUNICIPALITY, POSTAL_CODE, STATE, STREET_ADDRESS) VALUES(44, 0, NULL, NULL, NULL, NULL);
INSERT INTO PUBLIC.PHYSICAL_ADDRESS(ID, VERSION, MUNICIPALITY, POSTAL_CODE, STATE, STREET_ADDRESS) VALUES(51, 0, NULL, NULL, NULL, NULL);
INSERT INTO PUBLIC.PHYSICAL_ADDRESS(ID, VERSION, MUNICIPALITY, POSTAL_CODE, STATE, STREET_ADDRESS) VALUES(70, 0, NULL, NULL, NULL, NULL);
INSERT INTO PUBLIC.PHYSICAL_ADDRESS(ID, VERSION, MUNICIPALITY, POSTAL_CODE, STATE, STREET_ADDRESS) VALUES(78, 0, NULL, NULL, NULL, NULL);
INSERT INTO PUBLIC.PHYSICAL_ADDRESS(ID, VERSION, MUNICIPALITY, POSTAL_CODE, STATE, STREET_ADDRESS) VALUES(81, 0, NULL, NULL, NULL, NULL);
INSERT INTO PUBLIC.PHYSICAL_ADDRESS(ID, VERSION, MUNICIPALITY, POSTAL_CODE, STATE, STREET_ADDRESS) VALUES(89, 0, NULL, NULL, NULL, NULL);
CREATE MEMORY TABLE PUBLIC.PLAYER(
    ID BIGINT NOT NULL,
    VERSION BIGINT,
    GENDER VARCHAR(255),
    GIVEN_NAMES VARCHAR(255) NOT NULL,
    PREFERRED_NAME VARCHAR(255),
    SURNAME VARCHAR(255) NOT NULL,
    BATTING_ORIENTATION VARCHAR(255),
    BIRTH_DATE DATE NOT NULL,
    INSURANCE_POLICY_NUMBER VARCHAR(255),
    INSURANCE_PROVIDER VARCHAR(255),
    MEDICAL_NOTE VARCHAR(8192),
    THROWING_ORIENTATION VARCHAR(255),
    JERSEY_SIZE VARCHAR(255),
    PREFERRED_JERSEY_NUMBERS VARCHAR(255),
    DIVISION_ID BIGINT NOT NULL,
    EMERGENCY_CONTACT_ID BIGINT,
    RESIDENCE_ADDRESS_ID BIGINT
);
ALTER TABLE PUBLIC.PLAYER ADD CONSTRAINT PUBLIC.CONSTRAINT_8CD PRIMARY KEY(ID);
-- 11 +/- SELECT COUNT(*) FROM PUBLIC.PLAYER;
INSERT INTO PUBLIC.PLAYER(ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, BATTING_ORIENTATION, BIRTH_DATE, INSURANCE_POLICY_NUMBER, INSURANCE_PROVIDER, MEDICAL_NOTE, THROWING_ORIENTATION, JERSEY_SIZE, PREFERRED_JERSEY_NUMBERS, DIVISION_ID, EMERGENCY_CONTACT_ID, RESIDENCE_ADDRESS_ID) VALUES(3, 1, NULL, 'Elizabeth', 'Lizzie', 'Bell', 'RIGHT', DATE '2005-10-01', 'A7772110TX', 'Aetna', NULL, 'RIGHT', 'YOUTH/LARGE', '8 18 3', 2, 12, 4);
INSERT INTO PUBLIC.PLAYER(ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, BATTING_ORIENTATION, BIRTH_DATE, INSURANCE_POLICY_NUMBER, INSURANCE_PROVIDER, MEDICAL_NOTE, THROWING_ORIENTATION, JERSEY_SIZE, PREFERRED_JERSEY_NUMBERS, DIVISION_ID, EMERGENCY_CONTACT_ID, RESIDENCE_ADDRESS_ID) VALUES(17, 1, NULL, 'Amy', NULL, 'Groeschel', 'RIGHT', DATE '2005-08-21', 'A2881727VV', 'Aetna', NULL, 'RIGHT', 'ADULT/SMALL', '4 14 22', 2, NULL, 18);
INSERT INTO PUBLIC.PLAYER(ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, BATTING_ORIENTATION, BIRTH_DATE, INSURANCE_POLICY_NUMBER, INSURANCE_PROVIDER, MEDICAL_NOTE, THROWING_ORIENTATION, JERSEY_SIZE, PREFERRED_JERSEY_NUMBERS, DIVISION_ID, EMERGENCY_CONTACT_ID, RESIDENCE_ADDRESS_ID) VALUES(25, 1, NULL, 'Emma', NULL, 'Parker', 'LEFT', DATE '2005-04-04', '212288U7', 'Aflac', NULL, 'LEFT', 'YOUTH/MEDIUM', '2 55 10', 2, NULL, 26);
INSERT INTO PUBLIC.PLAYER(ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, BATTING_ORIENTATION, BIRTH_DATE, INSURANCE_POLICY_NUMBER, INSURANCE_PROVIDER, MEDICAL_NOTE, THROWING_ORIENTATION, JERSEY_SIZE, PREFERRED_JERSEY_NUMBERS, DIVISION_ID, EMERGENCY_CONTACT_ID, RESIDENCE_ADDRESS_ID) VALUES(30, 1, NULL, 'Allegra', 'Ally', 'Claxton', 'RIGHT', DATE '2005-05-19', '77SGX1136', 'Signet', NULL, 'RIGHT', 'YOUTH/LARGE', '2 10 12', 2, NULL, 31);
INSERT INTO PUBLIC.PLAYER(ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, BATTING_ORIENTATION, BIRTH_DATE, INSURANCE_POLICY_NUMBER, INSURANCE_PROVIDER, MEDICAL_NOTE, THROWING_ORIENTATION, JERSEY_SIZE, PREFERRED_JERSEY_NUMBERS, DIVISION_ID, EMERGENCY_CONTACT_ID, RESIDENCE_ADDRESS_ID) VALUES(38, 1, NULL, 'Hannah', NULL, 'Alexander', 'RIGHT', DATE '2006-03-03', '213822A22', 'Anthem', NULL, 'RIGHT', 'YOUTH/SMALL', '3 7 10', 2, NULL, 39);
INSERT INTO PUBLIC.PLAYER(ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, BATTING_ORIENTATION, BIRTH_DATE, INSURANCE_POLICY_NUMBER, INSURANCE_PROVIDER, MEDICAL_NOTE, THROWING_ORIENTATION, JERSEY_SIZE, PREFERRED_JERSEY_NUMBERS, DIVISION_ID, EMERGENCY_CONTACT_ID, RESIDENCE_ADDRESS_ID) VALUES(43, 1, NULL, 'Erica', NULL, 'Johnson', 'LEFT', DATE '2006-03-03', '712628A22', 'Anthem', 'Peanut allergy', 'LEFT', 'ADULT/MEDIUM', '5 7 13', 2, 47, 44);
INSERT INTO PUBLIC.PLAYER(ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, BATTING_ORIENTATION, BIRTH_DATE, INSURANCE_POLICY_NUMBER, INSURANCE_PROVIDER, MEDICAL_NOTE, THROWING_ORIENTATION, JERSEY_SIZE, PREFERRED_JERSEY_NUMBERS, DIVISION_ID, EMERGENCY_CONTACT_ID, RESIDENCE_ADDRESS_ID) VALUES(50, 1, NULL, 'Alexis', NULL, 'Young', 'RIGHT', DATE '2006-07-08', 'A21380407XT', 'Aetna', NULL, 'LEFT', 'ADULT/MEDIUM', '5 7 19', 2, NULL, 51);
INSERT INTO PUBLIC.PLAYER(ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, BATTING_ORIENTATION, BIRTH_DATE, INSURANCE_POLICY_NUMBER, INSURANCE_PROVIDER, MEDICAL_NOTE, THROWING_ORIENTATION, JERSEY_SIZE, PREFERRED_JERSEY_NUMBERS, DIVISION_ID, EMERGENCY_CONTACT_ID, RESIDENCE_ADDRESS_ID) VALUES(69, 1, NULL, 'Bailey', NULL, 'Martin', 'RIGHT', DATE '2003-07-30', 'A31345890XT', 'Aetna', 'Allergic to penicillin.', 'RIGHT', 'ADULT/SMALL', '5 15 9', 68, NULL, 70);
INSERT INTO PUBLIC.PLAYER(ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, BATTING_ORIENTATION, BIRTH_DATE, INSURANCE_POLICY_NUMBER, INSURANCE_PROVIDER, MEDICAL_NOTE, THROWING_ORIENTATION, JERSEY_SIZE, PREFERRED_JERSEY_NUMBERS, DIVISION_ID, EMERGENCY_CONTACT_ID, RESIDENCE_ADDRESS_ID) VALUES(77, 1, NULL, 'Sophia', NULL, 'Parker', 'LEFT', DATE '2003-09-02', '212288U7', 'Aflac', NULL, 'LEFT', 'YOUTH/LARGE', '5 7 19', 68, NULL, 78);
INSERT INTO PUBLIC.PLAYER(ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, BATTING_ORIENTATION, BIRTH_DATE, INSURANCE_POLICY_NUMBER, INSURANCE_PROVIDER, MEDICAL_NOTE, THROWING_ORIENTATION, JERSEY_SIZE, PREFERRED_JERSEY_NUMBERS, DIVISION_ID, EMERGENCY_CONTACT_ID, RESIDENCE_ADDRESS_ID) VALUES(80, 1, NULL, 'Colleen', NULL, 'Callaghan', 'RIGHT', DATE '2003-06-11', '177266A22', 'Anthem', NULL, 'LEFT', 'ADULT/SMALL', '11 22 33', 68, NULL, 81);
INSERT INTO PUBLIC.PLAYER(ID, VERSION, GENDER, GIVEN_NAMES, PREFERRED_NAME, SURNAME, BATTING_ORIENTATION, BIRTH_DATE, INSURANCE_POLICY_NUMBER, INSURANCE_PROVIDER, MEDICAL_NOTE, THROWING_ORIENTATION, JERSEY_SIZE, PREFERRED_JERSEY_NUMBERS, DIVISION_ID, EMERGENCY_CONTACT_ID, RESIDENCE_ADDRESS_ID) VALUES(88, 1, NULL, 'Elizabeth', NULL, 'Tompkins', 'RIGHT', DATE '2003-02-14', 'A177345943XT', 'Aetna', NULL, 'RIGHT', 'YOUTH/MEDIUM', '7 8 18', 68, NULL, 89);
CREATE MEMORY TABLE PUBLIC.ROSTER_PLAYER(
    ID BIGINT NOT NULL,
    VERSION BIGINT,
    JERSEY_NUMBER VARCHAR(255),
    POSITION INTEGER,
    PLAYER_ID BIGINT NOT NULL,
    TEAM_ID BIGINT
);
ALTER TABLE PUBLIC.ROSTER_PLAYER ADD CONSTRAINT PUBLIC.CONSTRAINT_9 PRIMARY KEY(ID);
-- 11 +/- SELECT COUNT(*) FROM PUBLIC.ROSTER_PLAYER;
INSERT INTO PUBLIC.ROSTER_PLAYER(ID, VERSION, JERSEY_NUMBER, POSITION, PLAYER_ID, TEAM_ID) VALUES(61, 0, '8', 0, 3, 60);
INSERT INTO PUBLIC.ROSTER_PLAYER(ID, VERSION, JERSEY_NUMBER, POSITION, PLAYER_ID, TEAM_ID) VALUES(62, 0, '13', 1, 43, 60);
INSERT INTO PUBLIC.ROSTER_PLAYER(ID, VERSION, JERSEY_NUMBER, POSITION, PLAYER_ID, TEAM_ID) VALUES(63, 0, '7', 2, 50, 60);
INSERT INTO PUBLIC.ROSTER_PLAYER(ID, VERSION, JERSEY_NUMBER, POSITION, PLAYER_ID, TEAM_ID) VALUES(64, 0, '2', 2, 30, 60);
INSERT INTO PUBLIC.ROSTER_PLAYER(ID, VERSION, JERSEY_NUMBER, POSITION, PLAYER_ID, TEAM_ID) VALUES(65, 0, '3', 2, 38, 60);
INSERT INTO PUBLIC.ROSTER_PLAYER(ID, VERSION, JERSEY_NUMBER, POSITION, PLAYER_ID, TEAM_ID) VALUES(66, 0, '4', 3, 17, 60);
INSERT INTO PUBLIC.ROSTER_PLAYER(ID, VERSION, JERSEY_NUMBER, POSITION, PLAYER_ID, TEAM_ID) VALUES(67, 0, '10', 3, 25, 60);
INSERT INTO PUBLIC.ROSTER_PLAYER(ID, VERSION, JERSEY_NUMBER, POSITION, PLAYER_ID, TEAM_ID) VALUES(99, 0, '5', 0, 69, 98);
INSERT INTO PUBLIC.ROSTER_PLAYER(ID, VERSION, JERSEY_NUMBER, POSITION, PLAYER_ID, TEAM_ID) VALUES(100, 0, '11', 1, 80, 98);
INSERT INTO PUBLIC.ROSTER_PLAYER(ID, VERSION, JERSEY_NUMBER, POSITION, PLAYER_ID, TEAM_ID) VALUES(101, 0, '8', 1, 88, 98);
INSERT INTO PUBLIC.ROSTER_PLAYER(ID, VERSION, JERSEY_NUMBER, POSITION, PLAYER_ID, TEAM_ID) VALUES(102, 0, '7', 3, 77, 98);
CREATE MEMORY TABLE PUBLIC.TEAM(
    ID BIGINT NOT NULL,
    VERSION BIGINT,
    NAME VARCHAR(255) NOT NULL,
    DIVISION_ID BIGINT NOT NULL,
    MANAGER_ID BIGINT NOT NULL
);
ALTER TABLE PUBLIC.TEAM ADD CONSTRAINT PUBLIC.CONSTRAINT_2 PRIMARY KEY(ID);
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.TEAM;
INSERT INTO PUBLIC.TEAM(ID, VERSION, NAME, DIVISION_ID, MANAGER_ID) VALUES(60, 1, 'Manning', 2, 58);
INSERT INTO PUBLIC.TEAM(ID, VERSION, NAME, DIVISION_ID, MANAGER_ID) VALUES(98, 1, 'Anderson', 68, 96);
CREATE MEMORY TABLE PUBLIC.TEAM_COACH(
    TEAM_ID BIGINT NOT NULL,
    COACH_ID BIGINT NOT NULL
);
ALTER TABLE PUBLIC.TEAM_COACH ADD CONSTRAINT PUBLIC.CONSTRAINT_D PRIMARY KEY(TEAM_ID, COACH_ID);
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.TEAM_COACH;
ALTER TABLE PUBLIC.PHONE ADD CONSTRAINT PUBLIC.FK_TBP4A6165YTBB0WHWVMQGOUB7 FOREIGN KEY(CONTACT_ID) REFERENCES PUBLIC.CONTACT(ID) NOCHECK;
ALTER TABLE PUBLIC.TEAM ADD CONSTRAINT PUBLIC.FK_QWASX062E8T46KXG9L81D5AWG FOREIGN KEY(MANAGER_ID) REFERENCES PUBLIC.CONTACT(ID) NOCHECK;
ALTER TABLE PUBLIC.TEAM_COACH ADD CONSTRAINT PUBLIC.FK_M38BMGTEJNEUCPOTBA616XK2K FOREIGN KEY(TEAM_ID) REFERENCES PUBLIC.TEAM(ID) NOCHECK;
ALTER TABLE PUBLIC.ROSTER_PLAYER ADD CONSTRAINT PUBLIC.FK_JV4IBCDXNVGAE241FLITQQRHL FOREIGN KEY(TEAM_ID) REFERENCES PUBLIC.TEAM(ID) NOCHECK;
ALTER TABLE PUBLIC.DIVISION ADD CONSTRAINT PUBLIC.FK_SK7P4EXE7V9UD73M5IRSIKIA5 FOREIGN KEY(LEAGUE_ID) REFERENCES PUBLIC.LEAGUE(ID) NOCHECK;
ALTER TABLE PUBLIC.PLAYER ADD CONSTRAINT PUBLIC.FK_IHMVME3EE0C9KGYT6S0E7300E FOREIGN KEY(EMERGENCY_CONTACT_ID) REFERENCES PUBLIC.CONTACT(ID) NOCHECK;
ALTER TABLE PUBLIC.TEAM_COACH ADD CONSTRAINT PUBLIC.FK_B964YKNAJA4IKOTU7PTY0DMJQ FOREIGN KEY(COACH_ID) REFERENCES PUBLIC.CONTACT(ID) NOCHECK;
ALTER TABLE PUBLIC.CONTACT ADD CONSTRAINT PUBLIC.FK_5G5BXDX28LTLRXMWKLITGFLGB FOREIGN KEY(MAILING_ADDRESS_ID) REFERENCES PUBLIC.PHYSICAL_ADDRESS(ID) NOCHECK;
ALTER TABLE PUBLIC.TEAM ADD CONSTRAINT PUBLIC.FK_CXS3KELC13T2NXA43AYG38JMA FOREIGN KEY(DIVISION_ID) REFERENCES PUBLIC.DIVISION(ID) NOCHECK;
ALTER TABLE PUBLIC.PLAYER ADD CONSTRAINT PUBLIC.FK_6XGI0JPXJT7B3URYSD90P5BCI FOREIGN KEY(DIVISION_ID) REFERENCES PUBLIC.DIVISION(ID) NOCHECK;
ALTER TABLE PUBLIC.PARENT ADD CONSTRAINT PUBLIC.FK_B9TO5NVI429M0JTP7PF1V1N85 FOREIGN KEY(CONTACT_ID) REFERENCES PUBLIC.CONTACT(ID) NOCHECK;
ALTER TABLE PUBLIC.ROSTER_PLAYER ADD CONSTRAINT PUBLIC.FK_CH4AJ29HWY9GGYFKU9ITL56UE FOREIGN KEY(PLAYER_ID) REFERENCES PUBLIC.PLAYER(ID) NOCHECK;
ALTER TABLE PUBLIC.PARENT ADD CONSTRAINT PUBLIC.FK_BFABIKY2QY6A7DXS5GTHDX97N FOREIGN KEY(PLAYER_ID) REFERENCES PUBLIC.PLAYER(ID) NOCHECK;
ALTER TABLE PUBLIC.PLAYER ADD CONSTRAINT PUBLIC.FK_22RR2I6S2QS0LRWVHIO62TOGM FOREIGN KEY(RESIDENCE_ADDRESS_ID) REFERENCES PUBLIC.PHYSICAL_ADDRESS(ID) NOCHECK;

