/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.jdbc.source;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.soulwing.jdbc.source.ReaderSQLSource;
import org.soulwing.jdbc.source.SQLInputException;
import org.soulwing.jdbc.source.SQLResourceNotFoundException;

public class ResourceSQLSource
extends ReaderSQLSource {
    public static final String DEFAULT_ENCODING = "UTF-8";

    public ResourceSQLSource(URL location, String encoding) {
        super(ResourceSQLSource.openReader(location, encoding));
    }

    public static ResourceSQLSource with(String name, Class<?> relativeToClass) {
        return ResourceSQLSource.with(name, relativeToClass, DEFAULT_ENCODING);
    }

    public static ResourceSQLSource with(String name, Class<?> relativeToClass, String encoding) {
        return ResourceSQLSource.with(name, new ClassResourceAccessor(relativeToClass), encoding);
    }

    public static ResourceSQLSource with(String name, ClassLoader classLoader) {
        return ResourceSQLSource.with(name, classLoader, DEFAULT_ENCODING);
    }

    public static ResourceSQLSource with(String name, ClassLoader classLoader, String encoding) {
        return ResourceSQLSource.with(name, new ClassLoaderResourceAccessor(classLoader), encoding);
    }

    public static ResourceSQLSource with(String name, ResourceAccessor accessor) {
        return ResourceSQLSource.with(name, accessor, DEFAULT_ENCODING);
    }

    public static ResourceSQLSource with(String name, ResourceAccessor accessor, String encoding) {
        return ResourceSQLSource.with(accessor.getResource(name), encoding);
    }

    public static ResourceSQLSource with(String location) {
        return ResourceSQLSource.with(location, DEFAULT_ENCODING);
    }

    public static ResourceSQLSource with(String location, String encoding) {
        return ResourceSQLSource.with(URI.create(location), encoding);
    }

    public static ResourceSQLSource with(URI location) {
        return ResourceSQLSource.with(location, DEFAULT_ENCODING);
    }

    public static ResourceSQLSource with(URI location, String encoding) {
        return new ResourceSQLSource(ResourceSQLSource.translate(location), encoding);
    }

    public static ResourceSQLSource with(URL location) {
        return new ResourceSQLSource(location, DEFAULT_ENCODING);
    }

    public static ResourceSQLSource with(URL location, String encoding) {
        return new ResourceSQLSource(location, encoding);
    }

    private static URL translate(URI uri) {
        if (uri == null) {
            throw new NullPointerException("resource location is required");
        }
        if ("classpath".equals(uri.getScheme())) {
            URL url;
            String path = uri.getSchemeSpecificPart();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((url = Thread.currentThread().getContextClassLoader().getResource(path)) == null) {
                throw new SQLResourceNotFoundException(path);
            }
            return url;
        }
        try {
            return uri.toURL();
        }
        catch (MalformedURLException ex) {
            throw new SQLInputException(uri.toString(), ex);
        }
    }

    private static Reader openReader(URL location, String encoding) {
        try {
            InputStream inputStream = location.openStream();
            return new BufferedReader(new InputStreamReader(inputStream, encoding));
        }
        catch (FileNotFoundException ex) {
            throw new SQLResourceNotFoundException(location.toString());
        }
        catch (IOException ex) {
            throw new SQLInputException(ex.getMessage(), ex);
        }
    }

    private static class ClassResourceAccessor
    implements ResourceAccessor {
        private final Class clazz;

        public ClassResourceAccessor(Class clazz) {
            this.clazz = clazz;
        }

        @Override
        public URL getResource(String name) {
            URL location = this.clazz.getResource(name);
            if (location == null) {
                throw new SQLResourceNotFoundException(name, this.clazz);
            }
            return location;
        }
    }

    private static class ClassLoaderResourceAccessor
    implements ResourceAccessor {
        private final ClassLoader classLoader;

        public ClassLoaderResourceAccessor(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public URL getResource(String name) {
            URL location = this.classLoader.getResource(name);
            if (location == null) {
                throw new SQLResourceNotFoundException(name);
            }
            return location;
        }
    }

    public static interface ResourceAccessor {
        public URL getResource(String var1) throws SQLResourceNotFoundException;
    }
}

