/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.jdbc.source;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import org.soulwing.jdbc.source.Lexer;

class Parser
implements Closeable {
    private final Reader reader;
    private final Lexer lexer;

    Parser(Reader reader) {
        this.reader = reader;
        this.lexer = new Lexer(reader);
    }

    String next() throws IOException {
        String statement = this.doNext();
        while (statement != null && statement.isEmpty()) {
            statement = this.doNext();
        }
        return statement;
    }

    private String doNext() throws IOException {
        StringBuilder statement = new StringBuilder();
        Lexer.Token token = this.lexer.next();
        if (token == null) {
            return null;
        }
        while (token != null && token.type != Lexer.Token.Type.END_OF_STATEMENT) {
            if (token.type == Lexer.Token.Type.WHITESPACE) {
                statement.append(' ');
            } else if (token.type != Lexer.Token.Type.COMMENT) {
                statement.append(token.value);
            }
            token = this.lexer.next();
        }
        return statement.toString().trim();
    }

    @Override
    public void close() throws IOException {
        this.lexer.close();
    }
}

