/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.jdbc.source;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;

class Lexer
implements Closeable {
    private final int REPLACEMENT_CHARACTER = 65533;
    private final int ZERO_WIDTH_NO_BREAK_SPACE = 65279;
    private final Reader reader;
    private Token nextToken;
    private boolean ready;

    Lexer(Reader reader) {
        this.reader = reader;
    }

    Token next() throws IOException {
        if (!this.ready) {
            this.stripByteOrderMark();
            this.ready = true;
        }
        Token token = null;
        if (this.nextToken != null) {
            token = this.nextToken;
            this.nextToken = null;
        } else {
            token = this.doNext();
            if (token == null) {
                return null;
            }
            StringBuilder text = new StringBuilder();
            while (token != null && token.type == Token.Type.STATEMENT_TEXT) {
                text.append(((Character)token.value).charValue());
                token = this.doNext();
            }
            if (text.length() > 0) {
                this.nextToken = token;
                token = new Token(Token.Type.STATEMENT_TEXT, text.toString());
            }
        }
        return token;
    }

    private void stripByteOrderMark() throws IOException {
        int c = 0;
        do {
            this.reader.mark(1);
        } while ((c = this.reader.read()) == 65533 || c == 65279);
        this.reader.reset();
    }

    private Token doNext() throws IOException {
        int c = this.read();
        if (Character.isSpaceChar(c) || Character.isWhitespace(c)) {
            return new Token(Token.Type.WHITESPACE, this.readWhitespace(c));
        }
        if (c == 59) {
            return new Token(Token.Type.END_OF_STATEMENT, Character.valueOf(';'));
        }
        if (c == 45) {
            if (this.read() == 45) {
                return new Token(Token.Type.COMMENT, this.readLineComment());
            }
            this.unread();
            return new Token(Token.Type.STATEMENT_TEXT, Character.valueOf((char)c));
        }
        if (c == 47) {
            if (this.read() == 42) {
                return new Token(Token.Type.COMMENT, this.readBlockComment());
            }
            return new Token(Token.Type.STATEMENT_TEXT, Character.valueOf((char)c));
        }
        if (c == 39) {
            return new Token(Token.Type.STRING_LITERAL, this.readStringLiteral());
        }
        if (c != -1) {
            return new Token(Token.Type.STATEMENT_TEXT, Character.valueOf((char)c));
        }
        return null;
    }

    private int read() throws IOException {
        this.reader.mark(1);
        return this.reader.read();
    }

    private void unread() throws IOException {
        this.reader.reset();
    }

    private String readWhitespace(int c) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append((char)c);
        c = this.read();
        while (Character.isSpaceChar((char)c)) {
            sb.append((char)c);
            c = this.read();
        }
        this.unread();
        return sb.toString();
    }

    private String readLineComment() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("--");
        int c = this.read();
        while (c != 13 && c != 10) {
            sb.append((char)c);
            c = this.read();
        }
        if (c == 13 && (c = this.read()) != 10) {
            this.unread();
        }
        return sb.toString();
    }

    private String readBlockComment() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("/*");
        int c = this.read();
        while (true) {
            sb.append((char)c);
            if (c == 42) {
                c = this.read();
                if (c == 47) break;
                this.unread();
            }
            c = this.read();
        }
        sb.append('/');
        return sb.toString();
    }

    private String readStringLiteral() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        int c = this.read();
        while (true) {
            if (c == 39) {
                c = this.read();
                if (c != 39) break;
                sb.append("''");
            } else {
                if (c == -1) {
                    throw new IllegalStateException("unterminated string literal");
                }
                sb.append((char)c);
            }
            c = this.read();
        }
        this.unread();
        sb.append('\'');
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    static class Token {
        final Type type;
        final Object value;

        Token(Type type, Object value) {
            this.type = type;
            this.value = value;
        }

        static enum Type {
            END_OF_STATEMENT,
            STRING_LITERAL,
            COMMENT,
            WHITESPACE,
            STATEMENT_TEXT;

        }
    }
}

