/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.jdbc;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

abstract class ValueAccessor {
    ValueAccessor() {
    }

    public <T> T get(int index, Class<T> type) throws SQLException {
        if (String.class.equals(type)) {
            return (T)this.getString(index);
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            return (T)Integer.valueOf(this.getInt(index));
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return (T)Long.valueOf(this.getLong(index));
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            return (T)Boolean.valueOf(this.getBoolean(index));
        }
        if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            return (T)Double.valueOf(this.getDouble(index));
        }
        if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            return (T)Float.valueOf(this.getFloat(index));
        }
        if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            return (T)Short.valueOf(this.getShort(index));
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            return (T)Byte.valueOf(this.getByte(index));
        }
        if (Date.class.isAssignableFrom(type)) {
            return (T)this.getDate(index);
        }
        if (Time.class.isAssignableFrom(type)) {
            return (T)this.getTime(index);
        }
        return (T)this.getObject(index, type);
    }

    public <T> T get(String label, Class<T> type) throws SQLException {
        if (String.class.equals(type)) {
            return (T)this.getString(label);
        }
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            return (T)Integer.valueOf(this.getInt(label));
        }
        if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            return (T)Long.valueOf(this.getLong(label));
        }
        if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            return (T)Boolean.valueOf(this.getBoolean(label));
        }
        if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            return (T)Double.valueOf(this.getDouble(label));
        }
        if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            return (T)Float.valueOf(this.getFloat(label));
        }
        if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            return (T)Short.valueOf(this.getShort(label));
        }
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            return (T)Byte.valueOf(this.getByte(label));
        }
        if (Date.class.isAssignableFrom(type)) {
            return (T)this.getDate(label);
        }
        if (Time.class.isAssignableFrom(type)) {
            return (T)this.getTime(label);
        }
        return (T)this.getObject(label, type);
    }

    abstract String getString(String var1) throws SQLException;

    abstract String getString(int var1) throws SQLException;

    abstract int getInt(String var1) throws SQLException;

    abstract int getInt(int var1) throws SQLException;

    abstract long getLong(String var1) throws SQLException;

    abstract long getLong(int var1) throws SQLException;

    abstract boolean getBoolean(String var1) throws SQLException;

    abstract boolean getBoolean(int var1) throws SQLException;

    abstract byte getByte(String var1) throws SQLException;

    abstract byte getByte(int var1) throws SQLException;

    abstract short getShort(String var1) throws SQLException;

    abstract short getShort(int var1) throws SQLException;

    abstract double getDouble(String var1) throws SQLException;

    abstract double getDouble(int var1) throws SQLException;

    abstract float getFloat(String var1) throws SQLException;

    abstract float getFloat(int var1) throws SQLException;

    abstract Timestamp getTimestamp(String var1) throws SQLException;

    abstract Timestamp getTimestamp(int var1) throws SQLException;

    abstract Date getDate(String var1) throws SQLException;

    abstract Date getDate(int var1) throws SQLException;

    abstract Time getTime(String var1) throws SQLException;

    abstract Time getTime(int var1) throws SQLException;

    abstract Object getObject(String var1, Class<?> var2) throws SQLException;

    abstract Object getObject(int var1, Class<?> var2) throws SQLException;
}

