/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.jdbc;

import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.soulwing.jdbc.JdbcUpdate;
import org.soulwing.jdbc.JdbcUtils;
import org.soulwing.jdbc.Parameter;
import org.soulwing.jdbc.PreparedStatementCreator;
import org.soulwing.jdbc.PreparedUpdateExecutor;
import org.soulwing.jdbc.SQLRuntimeException;
import org.soulwing.jdbc.SourceUtils;
import org.soulwing.jdbc.StatementPreparer;
import org.soulwing.jdbc.source.SQLSource;

class UpdateBuilder
implements JdbcUpdate {
    private final DataSource dataSource;
    private PreparedStatementCreator psc;
    private boolean repeatable;
    private boolean executed;

    public UpdateBuilder(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public JdbcUpdate using(String sql) {
        this.assertNotExecuted();
        this.psc = StatementPreparer.with(sql);
        return this;
    }

    @Override
    public JdbcUpdate using(SQLSource source) {
        this.assertNotExecuted();
        return this.using(SourceUtils.getSingleStatement(source));
    }

    @Override
    public JdbcUpdate repeatedly() {
        this.assertNotExecuted();
        this.repeatable = true;
        return this;
    }

    @Override
    public int execute(Parameter ... parameters) {
        this.assertReady();
        PreparedUpdateExecutor executor = new PreparedUpdateExecutor(this.psc, Arrays.asList(parameters));
        try {
            int n = (Integer)executor.execute(this.dataSource);
            return n;
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
        finally {
            this.executed = true;
            if (!this.repeatable) {
                this.close();
            }
        }
    }

    private void assertReady() {
        if (this.executed && !this.repeatable) {
            throw new IllegalStateException("query has been executed and was not configured as repeatable");
        }
        if (this.psc == null) {
            throw new IllegalArgumentException("no SQL statement or source has been configured");
        }
    }

    private void assertNotExecuted() {
        if (this.executed) {
            throw new IllegalStateException("update cannot be reconfigured after is has been executed");
        }
    }

    @Override
    public void close() {
        JdbcUtils.closeQuietly(this.psc);
    }
}

