/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.soulwing.jdbc.ColumnExtractingResultSetHandler;
import org.soulwing.jdbc.ColumnExtractor;
import org.soulwing.jdbc.JdbcQuery;
import org.soulwing.jdbc.JdbcUtils;
import org.soulwing.jdbc.MultipleRowHandler;
import org.soulwing.jdbc.Parameter;
import org.soulwing.jdbc.PreparedQueryExecutor;
import org.soulwing.jdbc.PreparedStatementCreator;
import org.soulwing.jdbc.ResultSetHandler;
import org.soulwing.jdbc.RowMapper;
import org.soulwing.jdbc.RowMappingResultSetHandler;
import org.soulwing.jdbc.SQLRuntimeException;
import org.soulwing.jdbc.SingleRowHandler;
import org.soulwing.jdbc.SourceUtils;
import org.soulwing.jdbc.StatementPreparer;
import org.soulwing.jdbc.source.SQLSource;

class QueryBuilder<T>
implements JdbcQuery<T> {
    private final Class<T> type;
    private final DataSource dataSource;
    private PreparedStatementCreator psc;
    private ResultSetHandler<T> handler;
    private ResultSetHandler<T> innerHandler;
    private boolean repeatable;
    private boolean executed;

    public QueryBuilder(Class<T> type, DataSource dataSource) {
        this.type = type;
        this.dataSource = dataSource;
    }

    @Override
    public JdbcQuery<T> using(String sql) {
        this.assertNotExecuted();
        this.psc = StatementPreparer.with(sql);
        return this;
    }

    @Override
    public JdbcQuery<T> using(SQLSource source) {
        this.assertNotExecuted();
        return this.using(SourceUtils.getSingleStatement(source));
    }

    @Override
    public JdbcQuery<T> handlingResultWith(ResultSetHandler<T> handler) {
        this.assertNotExecuted();
        this.handler = handler;
        this.innerHandler = null;
        return this;
    }

    @Override
    public JdbcQuery<T> extractingColumn() {
        return this.extractingColumn(1);
    }

    @Override
    public JdbcQuery<T> extractingColumn(int index) {
        this.assertNotExecuted();
        this.handler = null;
        this.innerHandler = new ColumnExtractingResultSetHandler<T>(ColumnExtractor.with(index, this.type));
        return this;
    }

    @Override
    public JdbcQuery<T> extractingColumn(String label) {
        this.assertNotExecuted();
        this.handler = null;
        this.innerHandler = new ColumnExtractingResultSetHandler<T>(ColumnExtractor.with(label, this.type));
        return this;
    }

    @Override
    public JdbcQuery<T> mappingRowsWith(RowMapper<T> rowMapper) {
        this.assertNotExecuted();
        this.handler = null;
        this.innerHandler = new RowMappingResultSetHandler<T>(rowMapper);
        return this;
    }

    @Override
    public JdbcQuery<T> repeatedly() {
        this.assertNotExecuted();
        this.repeatable = true;
        return this;
    }

    @Override
    public List<T> retrieveList(Parameter ... parameters) {
        return (List)this.retrieve(this.handler != null ? this.handler : new MultipleRowHandler<T>(this.innerHandler), parameters);
    }

    @Override
    public T retrieveValue(Parameter ... parameters) {
        return (T)this.retrieve(this.handler != null ? this.handler : new SingleRowHandler<T>(this.innerHandler), parameters);
    }

    @Override
    public void execute(Parameter ... parameters) {
        this.retrieve(this.handler, parameters);
    }

    public Object retrieve(ResultSetHandler<?> handler, Parameter ... params) {
        this.assertReady();
        PreparedQueryExecutor executor = new PreparedQueryExecutor(this.psc, Arrays.asList(params));
        ResultSet rs = null;
        try {
            rs = (ResultSet)executor.execute(this.dataSource);
            Object obj = handler.handleResult(rs);
            return obj;
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
        finally {
            this.executed = true;
            JdbcUtils.closeQuietly(rs);
            if (!this.repeatable) {
                this.close();
            }
        }
    }

    @Override
    public void close() {
        JdbcUtils.closeQuietly(this.psc);
    }

    private void assertReady() {
        if (this.executed && !this.repeatable) {
            throw new IllegalStateException("query has been executed and was not configured as repeatable");
        }
        if (this.psc == null) {
            throw new IllegalArgumentException("no SQL statement or source has been configured");
        }
        if (this.handler == null && this.innerHandler == null) {
            throw new IllegalArgumentException("no result handler, column extractor, or row mapper has been configured");
        }
    }

    private void assertNotExecuted() {
        if (this.executed) {
            throw new IllegalStateException("query cannot be reconfigured after is has been executed");
        }
    }
}

