/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class Parameter {
    private final int type;
    private final Object value;
    private final boolean in;
    private final boolean out;

    private Parameter(int type, Object value) {
        this(type, value, true, false);
    }

    private Parameter(int type, Object value, boolean in, boolean out) {
        this.type = type;
        this.value = value;
        this.in = in;
        this.out = out;
    }

    public static Parameter with(Object value) {
        return new Parameter(0, value);
    }

    public static Parameter with(int type, Object value) {
        return new Parameter(type, value);
    }

    public static Parameter in(Object value) {
        return Parameter.in(0, value);
    }

    public static Parameter in(int type, Object value) {
        return new Parameter(type, value, true, false);
    }

    public static Parameter out(int type) {
        return new Parameter(type, null, false, true);
    }

    public static Parameter inout(int type, Object value) {
        return new Parameter(type, value, true, true);
    }

    public void inject(int parameterIndex, PreparedStatement statement) throws SQLException {
        if (!this.in) {
            return;
        }
        if (this.value == null) {
            statement.setNull(parameterIndex, 0);
        } else if (this.type == 0) {
            statement.setObject(parameterIndex, this.value);
        } else {
            statement.setObject(parameterIndex, this.value, this.type);
        }
    }

    public void inject(int parameterIndex, CallableStatement statement) throws SQLException {
        this.inject(parameterIndex, (PreparedStatement)statement);
        if (this.out) {
            statement.registerOutParameter(parameterIndex, this.type);
        }
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    boolean isIn() {
        return this.in;
    }

    boolean isOut() {
        return this.out;
    }
}

