/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.soulwing.jdbc.CallBuilder;
import org.soulwing.jdbc.CallPreparer;
import org.soulwing.jdbc.JdbcCall;
import org.soulwing.jdbc.JdbcOperations;
import org.soulwing.jdbc.JdbcQuery;
import org.soulwing.jdbc.JdbcUpdate;
import org.soulwing.jdbc.JdbcUtils;
import org.soulwing.jdbc.QueryBuilder;
import org.soulwing.jdbc.SQLRuntimeException;
import org.soulwing.jdbc.SingleConnectionDataSource;
import org.soulwing.jdbc.SourceUtils;
import org.soulwing.jdbc.StatementExecutor;
import org.soulwing.jdbc.StatementPreparer;
import org.soulwing.jdbc.UpdateBuilder;
import org.soulwing.jdbc.source.SQLSource;

public class FluentJdbc
implements JdbcOperations {
    private final DataSource dataSource;

    public FluentJdbc(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public FluentJdbc(Connection connection) {
        this(new SingleConnectionDataSource(connection));
    }

    @Override
    public void execute(String sql) {
        StatementPreparer psc = StatementPreparer.with(sql);
        StatementExecutor executor = new StatementExecutor(psc);
        try {
            executor.execute(this.dataSource);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
        finally {
            JdbcUtils.closeQuietly(psc);
        }
    }

    @Override
    public void execute(SQLSource source) {
        this.execute(SourceUtils.getSingleStatement(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeScript(SQLSource source) {
        try {
            String sql = source.next();
            while (sql != null) {
                this.execute(sql);
                sql = source.next();
            }
        }
        finally {
            JdbcUtils.closeQuietly(source);
        }
    }

    @Override
    public JdbcQuery<Void> query() {
        return this.queryForType(Void.class);
    }

    @Override
    public <T> JdbcQuery<T> queryForType(Class<T> type) {
        return new QueryBuilder<T>(type, this.dataSource);
    }

    @Override
    public JdbcUpdate update() {
        return new UpdateBuilder(this.dataSource);
    }

    @Override
    public JdbcCall call(String sql) {
        return new CallBuilder(this.dataSource, CallPreparer.with(sql));
    }

    @Override
    public JdbcCall call(SQLSource source) {
        return new CallBuilder(this.dataSource, CallPreparer.with(source));
    }
}

