/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.soulwing.jdbc.ResultSetAccessor;

class ColumnExtractor<T> {
    private final Object columnId;
    private final Class<T> type;

    private ColumnExtractor(Object columnId, Class<T> type) {
        this.columnId = columnId;
        this.type = type;
    }

    public static <T> ColumnExtractor<T> with(Class<T> type) {
        return new ColumnExtractor<T>(1, type);
    }

    public static <T> ColumnExtractor<T> with(int columnIndex, Class<T> type) {
        return new ColumnExtractor<T>(columnIndex, type);
    }

    public static <T> ColumnExtractor<T> with(String columnLabel, Class<T> type) {
        return new ColumnExtractor<T>(columnLabel, type);
    }

    public T extract(ResultSet rs) throws SQLException {
        if (this.columnId instanceof String) {
            return ResultSetAccessor.with(rs).get((String)this.columnId, this.type);
        }
        return ResultSetAccessor.with(rs).get((Integer)this.columnId, this.type);
    }
}

