/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.jdbc;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.soulwing.jdbc.CallableStatementAccessor;
import org.soulwing.jdbc.CallableStatementExecutor;
import org.soulwing.jdbc.ColumnExtractingResultSetHandler;
import org.soulwing.jdbc.ColumnExtractor;
import org.soulwing.jdbc.JdbcCall;
import org.soulwing.jdbc.JdbcUtils;
import org.soulwing.jdbc.MultipleRowHandler;
import org.soulwing.jdbc.Parameter;
import org.soulwing.jdbc.PreparedStatementCreator;
import org.soulwing.jdbc.ResultSetHandler;
import org.soulwing.jdbc.RowMapper;
import org.soulwing.jdbc.RowMappingResultSetHandler;
import org.soulwing.jdbc.SQLRuntimeException;
import org.soulwing.jdbc.SingleRowHandler;

class CallBuilder
implements JdbcCall {
    private final DataSource dataSource;
    private final PreparedStatementCreator<CallableStatement> psc;
    private CallableStatementExecutor executor;

    public CallBuilder(DataSource dataSource, PreparedStatementCreator<CallableStatement> psc) {
        this.dataSource = dataSource;
        this.psc = psc;
    }

    @Override
    public boolean execute(Parameter ... parameters) {
        this.executor = new CallableStatementExecutor(this.psc, Arrays.asList(parameters));
        try {
            return (Boolean)this.executor.execute(this.dataSource);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    @Override
    public void close() {
        JdbcUtils.closeQuietly(this.psc);
    }

    @Override
    public int getUpdateCount() {
        try {
            return ((CallableStatement)this.getExecutor().getStatement()).getUpdateCount();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    @Override
    public boolean getMoreResults() {
        try {
            return ((CallableStatement)this.getExecutor().getStatement()).getMoreResults();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    @Override
    public ResultSet getResultSet() {
        try {
            return ((CallableStatement)this.getExecutor().getStatement()).getResultSet();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    @Override
    public <T> List<T> retrieveList(String columnLabel, Class<T> type) {
        return (List)this.handleResult(new MultipleRowHandler<T>(new ColumnExtractingResultSetHandler<T>(ColumnExtractor.with(columnLabel, type))));
    }

    @Override
    public <T> List<T> retrieveList(int columnIndex, Class<T> type) {
        return (List)this.handleResult(new MultipleRowHandler<T>(new ColumnExtractingResultSetHandler<T>(ColumnExtractor.with(columnIndex, type))));
    }

    @Override
    public <T> List<T> retrieveList(RowMapper<T> rowMapper) {
        return (List)this.handleResult(new MultipleRowHandler<T>(new RowMappingResultSetHandler<T>(rowMapper)));
    }

    @Override
    public <T> T retrieveValue(String columnLabel, Class<T> type) {
        return this.handleResult(new SingleRowHandler<T>(new ColumnExtractingResultSetHandler<T>(ColumnExtractor.with(columnLabel, type))));
    }

    @Override
    public <T> T retrieveValue(int columnIndex, Class<T> type) {
        return this.handleResult(new SingleRowHandler<T>(new ColumnExtractingResultSetHandler<T>(ColumnExtractor.with(columnIndex, type))));
    }

    @Override
    public <T> T retrieveValue(RowMapper<T> rowMapper) {
        return this.handleResult(new SingleRowHandler<T>(new RowMappingResultSetHandler<T>(rowMapper)));
    }

    @Override
    public <T> T handleResult(ResultSetHandler<T> handler) {
        T t;
        ResultSet rs = null;
        try {
            rs = ((CallableStatement)this.getExecutor().getStatement()).getResultSet();
            if (rs == null) {
                throw new IllegalStateException("no result set is available");
            }
            t = handler.handleResult(rs);
        }
        catch (SQLException ex) {
            try {
                throw new SQLRuntimeException(ex);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(rs);
        return t;
    }

    @Override
    public <T> T getOutParameter(int parameterIndex, Class<T> type) {
        try {
            return CallableStatementAccessor.with((CallableStatement)this.getExecutor().getStatement()).get(parameterIndex, type);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    @Override
    public <T> T getOutParameter(String parameterName, Class<T> type) {
        try {
            return CallableStatementAccessor.with((CallableStatement)this.getExecutor().getStatement()).get(parameterName, type);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    private CallableStatementExecutor getExecutor() {
        if (this.executor == null) {
            throw new IllegalStateException("call has not been executed");
        }
        return this.executor;
    }
}

