/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.soulwing.jdbc.JdbcExecutor;
import org.soulwing.jdbc.Parameter;
import org.soulwing.jdbc.PreparedStatementCreator;

abstract class AbstractPreparedStatementExecutor<T, E extends PreparedStatement>
implements JdbcExecutor<T> {
    private final PreparedStatementCreator<E> psc;
    private final List<Parameter> parameters;
    private E statement;

    public AbstractPreparedStatementExecutor(PreparedStatementCreator<E> psc, List<Parameter> parameters) {
        this.psc = psc;
        this.parameters = parameters;
    }

    @Override
    public T execute(DataSource dataSource) throws SQLException {
        this.statement = this.psc.prepareStatement(dataSource);
        int index = 1;
        for (Parameter parameter : this.parameters) {
            parameter.inject(index++, (PreparedStatement)this.statement);
        }
        return this.doExecute(this.statement);
    }

    public E getStatement() {
        if (this.statement == null) {
            throw new IllegalStateException("no statement has been executed");
        }
        return this.statement;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    protected abstract T doExecute(E var1) throws SQLException;
}

