/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.soulwing.jdbc.JdbcUtils;
import org.soulwing.jdbc.PreparedStatementCreator;

abstract class AbstractPreparedStatementCreator<T extends PreparedStatement>
implements PreparedStatementCreator<T> {
    private final Lock lock = new ReentrantLock();
    private final String sql;
    private Connection connection;
    private volatile T statement;

    AbstractPreparedStatementCreator(String sql) {
        this.sql = sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T prepareStatement(DataSource dataSource) throws SQLException {
        if (this.statement == null) {
            this.lock.lock();
            try {
                if (this.statement == null) {
                    this.connection = dataSource.getConnection();
                    this.statement = this.prepareStatement(this.connection, this.sql);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.statement;
    }

    protected abstract T prepareStatement(Connection var1, String var2) throws SQLException;

    @Override
    public void close() {
        JdbcUtils.closeQuietly(this.statement);
        JdbcUtils.closeQuietly(this.connection);
    }
}

