/*
 * File created on Aug 6, 2015
 *
 * Copyright (c) 2015 Carl Harris, Jr
 * and others as noted
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.soulwing.jdbc.source;

import org.soulwing.jdbc.SQLRuntimeException;

/**
 * An exception thrown by an {@link SQLSource} when an error occurs in reading
 * an {@link SQLSource}.
 *
 * @author Carl Harris
 */
public class SQLInputException extends SQLRuntimeException {

  public SQLInputException(String message, Throwable cause) {
    super(message, cause);
  }

}
