/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.ASTVector;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Model;
import com.microsoft.z3.Native;
import com.microsoft.z3.ParamDescrs;
import com.microsoft.z3.Params;
import com.microsoft.z3.Statistics;
import com.microsoft.z3.Status;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_lbool;
import java.util.List;

public class Solver
extends Z3Object {
    public String getHelp() {
        return Native.solverGetHelp(this.getContext().nCtx(), this.getNativeObject());
    }

    public void setParameters(Params params) {
        this.getContext().checkContextMatch(params);
        Native.solverSetParams(this.getContext().nCtx(), this.getNativeObject(), params.getNativeObject());
    }

    public ParamDescrs getParameterDescriptions() {
        return new ParamDescrs(this.getContext(), Native.solverGetParamDescrs(this.getContext().nCtx(), this.getNativeObject()));
    }

    public int getNumScopes() {
        return Native.solverGetNumScopes(this.getContext().nCtx(), this.getNativeObject());
    }

    public void push() {
        Native.solverPush(this.getContext().nCtx(), this.getNativeObject());
    }

    public void pop() {
        this.pop(1);
    }

    public void pop(int n) {
        Native.solverPop(this.getContext().nCtx(), this.getNativeObject(), n);
    }

    public void reset() {
        Native.solverReset(this.getContext().nCtx(), this.getNativeObject());
    }

    public void interrupt() {
        Native.solverInterrupt(this.getContext().nCtx(), this.getNativeObject());
    }

    public void add(BoolExpr ... boolExprArray) {
        this.getContext().checkContextMatch(boolExprArray);
        for (BoolExpr boolExpr : boolExprArray) {
            Native.solverAssert(this.getContext().nCtx(), this.getNativeObject(), boolExpr.getNativeObject());
        }
    }

    public void assertAndTrack(BoolExpr[] boolExprArray, BoolExpr[] boolExprArray2) {
        this.getContext().checkContextMatch(boolExprArray);
        this.getContext().checkContextMatch(boolExprArray2);
        if (boolExprArray.length != boolExprArray2.length) {
            throw new Z3Exception("Argument size mismatch");
        }
        for (int i = 0; i < boolExprArray.length; ++i) {
            Native.solverAssertAndTrack(this.getContext().nCtx(), this.getNativeObject(), boolExprArray[i].getNativeObject(), boolExprArray2[i].getNativeObject());
        }
    }

    public void assertAndTrack(BoolExpr boolExpr, BoolExpr boolExpr2) {
        this.getContext().checkContextMatch(boolExpr);
        this.getContext().checkContextMatch(boolExpr2);
        Native.solverAssertAndTrack(this.getContext().nCtx(), this.getNativeObject(), boolExpr.getNativeObject(), boolExpr2.getNativeObject());
    }

    public void fromFile(String string) {
        Native.solverFromFile(this.getContext().nCtx(), this.getNativeObject(), string);
    }

    public void fromString(String string) {
        Native.solverFromString(this.getContext().nCtx(), this.getNativeObject(), string);
    }

    public int getNumAssertions() {
        ASTVector aSTVector = new ASTVector(this.getContext(), Native.solverGetAssertions(this.getContext().nCtx(), this.getNativeObject()));
        return aSTVector.size();
    }

    public BoolExpr[] getAssertions() {
        ASTVector aSTVector = new ASTVector(this.getContext(), Native.solverGetAssertions(this.getContext().nCtx(), this.getNativeObject()));
        return aSTVector.ToBoolExprArray();
    }

    public Status check(Expr ... exprArray) {
        Z3_lbool z3_lbool = exprArray == null ? Z3_lbool.fromInt(Native.solverCheck(this.getContext().nCtx(), this.getNativeObject())) : Z3_lbool.fromInt(Native.solverCheckAssumptions(this.getContext().nCtx(), this.getNativeObject(), exprArray.length, AST.arrayToNative(exprArray)));
        return this.lboolToStatus(z3_lbool);
    }

    public Status check() {
        return this.check(null);
    }

    public Status getConsequences(BoolExpr[] boolExprArray, Expr[] exprArray, List<BoolExpr> list) {
        ASTVector aSTVector = new ASTVector(this.getContext());
        ASTVector aSTVector2 = new ASTVector(this.getContext());
        ASTVector aSTVector3 = new ASTVector(this.getContext());
        for (Expr expr : boolExprArray) {
            aSTVector2.push(expr);
        }
        Expr[] exprArray2 = exprArray;
        int n = exprArray2.length;
        for (int i = 0; i < n; ++i) {
            Expr expr;
            expr = exprArray2[i];
            aSTVector3.push(expr);
        }
        int n2 = Native.solverGetConsequences(this.getContext().nCtx(), this.getNativeObject(), aSTVector2.getNativeObject(), aSTVector3.getNativeObject(), aSTVector.getNativeObject());
        for (n = 0; n < aSTVector.size(); ++n) {
            list.add((BoolExpr)Expr.create(this.getContext(), aSTVector.get(n).getNativeObject()));
        }
        return this.lboolToStatus(Z3_lbool.fromInt(n2));
    }

    public Model getModel() {
        long l = Native.solverGetModel(this.getContext().nCtx(), this.getNativeObject());
        if (l == 0L) {
            return null;
        }
        return new Model(this.getContext(), l);
    }

    public Expr getProof() {
        long l = Native.solverGetProof(this.getContext().nCtx(), this.getNativeObject());
        if (l == 0L) {
            return null;
        }
        return Expr.create(this.getContext(), l);
    }

    public BoolExpr[] getUnsatCore() {
        ASTVector aSTVector = new ASTVector(this.getContext(), Native.solverGetUnsatCore(this.getContext().nCtx(), this.getNativeObject()));
        return aSTVector.ToBoolExprArray();
    }

    public String getReasonUnknown() {
        return Native.solverGetReasonUnknown(this.getContext().nCtx(), this.getNativeObject());
    }

    public Solver translate(Context context) {
        return new Solver(context, Native.solverTranslate(this.getContext().nCtx(), this.getNativeObject(), context.nCtx()));
    }

    public Statistics getStatistics() {
        return new Statistics(this.getContext(), Native.solverGetStatistics(this.getContext().nCtx(), this.getNativeObject()));
    }

    public String toString() {
        return Native.solverToString(this.getContext().nCtx(), this.getNativeObject());
    }

    private Status lboolToStatus(Z3_lbool z3_lbool) {
        switch (z3_lbool) {
            case Z3_L_TRUE: {
                return Status.SATISFIABLE;
            }
            case Z3_L_FALSE: {
                return Status.UNSATISFIABLE;
            }
        }
        return Status.UNKNOWN;
    }

    Solver(Context context, long l) {
        super(context, l);
    }

    @Override
    void incRef() {
        Native.solverIncRef(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    void addToReferenceQueue() {
        this.getContext().getSolverDRQ().storeReference(this.getContext(), this);
    }
}

