/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.ASTDecRefQueue;
import com.microsoft.z3.ASTMap;
import com.microsoft.z3.ASTMapDecRefQueue;
import com.microsoft.z3.ASTVector;
import com.microsoft.z3.ASTVectorDecRefQueue;
import com.microsoft.z3.ApplyResult;
import com.microsoft.z3.ApplyResultDecRefQueue;
import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.ArithSort;
import com.microsoft.z3.ArrayExpr;
import com.microsoft.z3.ArraySort;
import com.microsoft.z3.BitVecExpr;
import com.microsoft.z3.BitVecNum;
import com.microsoft.z3.BitVecSort;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.BoolSort;
import com.microsoft.z3.CharSort;
import com.microsoft.z3.Constructor;
import com.microsoft.z3.ConstructorDecRefQueue;
import com.microsoft.z3.ConstructorList;
import com.microsoft.z3.ConstructorListDecRefQueue;
import com.microsoft.z3.DatatypeSort;
import com.microsoft.z3.EnumSort;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FPExpr;
import com.microsoft.z3.FPNum;
import com.microsoft.z3.FPRMExpr;
import com.microsoft.z3.FPRMNum;
import com.microsoft.z3.FPRMSort;
import com.microsoft.z3.FPSort;
import com.microsoft.z3.FiniteDomainSort;
import com.microsoft.z3.Fixedpoint;
import com.microsoft.z3.FixedpointDecRefQueue;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.FuncInterp;
import com.microsoft.z3.FuncInterpDecRefQueue;
import com.microsoft.z3.FuncInterpEntryDecRefQueue;
import com.microsoft.z3.Goal;
import com.microsoft.z3.GoalDecRefQueue;
import com.microsoft.z3.IDecRefQueue;
import com.microsoft.z3.IntExpr;
import com.microsoft.z3.IntNum;
import com.microsoft.z3.IntSort;
import com.microsoft.z3.IntSymbol;
import com.microsoft.z3.Lambda;
import com.microsoft.z3.ListSort;
import com.microsoft.z3.Model;
import com.microsoft.z3.ModelDecRefQueue;
import com.microsoft.z3.Native;
import com.microsoft.z3.Optimize;
import com.microsoft.z3.OptimizeDecRefQueue;
import com.microsoft.z3.ParamDescrs;
import com.microsoft.z3.ParamDescrsDecRefQueue;
import com.microsoft.z3.Params;
import com.microsoft.z3.ParamsDecRefQueue;
import com.microsoft.z3.Pattern;
import com.microsoft.z3.Probe;
import com.microsoft.z3.ProbeDecRefQueue;
import com.microsoft.z3.Quantifier;
import com.microsoft.z3.RatNum;
import com.microsoft.z3.ReExpr;
import com.microsoft.z3.ReSort;
import com.microsoft.z3.RealExpr;
import com.microsoft.z3.RealSort;
import com.microsoft.z3.SeqExpr;
import com.microsoft.z3.SeqSort;
import com.microsoft.z3.SetSort;
import com.microsoft.z3.Simplifier;
import com.microsoft.z3.SimplifierDecRefQueue;
import com.microsoft.z3.Solver;
import com.microsoft.z3.SolverDecRefQueue;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Statistics;
import com.microsoft.z3.StatisticsDecRefQueue;
import com.microsoft.z3.StringSymbol;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Tactic;
import com.microsoft.z3.TacticDecRefQueue;
import com.microsoft.z3.TupleSort;
import com.microsoft.z3.UninterpretedSort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_ast_print_mode;
import java.util.Map;

public class Context
implements AutoCloseable {
    private long m_ctx;
    static final Object creation_lock = new Object();
    private BoolSort m_boolSort = null;
    private IntSort m_intSort = null;
    private RealSort m_realSort = null;
    private SeqSort<CharSort> m_stringSort = null;
    private ASTDecRefQueue m_AST_DRQ = new ASTDecRefQueue();
    private ASTMapDecRefQueue m_ASTMap_DRQ = new ASTMapDecRefQueue();
    private ASTVectorDecRefQueue m_ASTVector_DRQ = new ASTVectorDecRefQueue();
    private ApplyResultDecRefQueue m_ApplyResult_DRQ = new ApplyResultDecRefQueue();
    private FuncInterpEntryDecRefQueue m_FuncEntry_DRQ = new FuncInterpEntryDecRefQueue();
    private FuncInterpDecRefQueue m_FuncInterp_DRQ = new FuncInterpDecRefQueue();
    private GoalDecRefQueue m_Goal_DRQ = new GoalDecRefQueue();
    private ModelDecRefQueue m_Model_DRQ = new ModelDecRefQueue();
    private ParamsDecRefQueue m_Params_DRQ = new ParamsDecRefQueue();
    private ParamDescrsDecRefQueue m_ParamDescrs_DRQ = new ParamDescrsDecRefQueue();
    private ProbeDecRefQueue m_Probe_DRQ = new ProbeDecRefQueue();
    private SolverDecRefQueue m_Solver_DRQ = new SolverDecRefQueue();
    private StatisticsDecRefQueue m_Statistics_DRQ = new StatisticsDecRefQueue();
    private TacticDecRefQueue m_Tactic_DRQ = new TacticDecRefQueue();
    private SimplifierDecRefQueue m_Simplifier_DRQ = new SimplifierDecRefQueue();
    private FixedpointDecRefQueue m_Fixedpoint_DRQ = new FixedpointDecRefQueue();
    private OptimizeDecRefQueue m_Optimize_DRQ = new OptimizeDecRefQueue();
    private ConstructorDecRefQueue m_Constructor_DRQ = new ConstructorDecRefQueue();
    private ConstructorListDecRefQueue m_ConstructorList_DRQ = new ConstructorListDecRefQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context() {
        Object object = creation_lock;
        synchronized (object) {
            this.m_ctx = Native.mkContextRc(0L);
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Context(long l) {
        Object object = creation_lock;
        synchronized (object) {
            this.m_ctx = l;
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context(Map<String, String> map) {
        Object object = creation_lock;
        synchronized (object) {
            long l = Native.mkConfig();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                Native.setParamValue(l, entry.getKey(), entry.getValue());
            }
            this.m_ctx = Native.mkContextRc(l);
            Native.delConfig(l);
            this.init();
        }
    }

    private void init() {
        this.setPrintMode(Z3_ast_print_mode.Z3_PRINT_SMTLIB2_COMPLIANT);
        Native.setInternalErrorHandler(this.m_ctx);
    }

    public IntSymbol mkSymbol(int n) {
        return new IntSymbol(this, n);
    }

    public StringSymbol mkSymbol(String string) {
        return new StringSymbol(this, string);
    }

    Symbol[] mkSymbols(String[] stringArray) {
        if (stringArray == null) {
            return new Symbol[0];
        }
        Symbol[] symbolArray = new Symbol[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            symbolArray[i] = this.mkSymbol(stringArray[i]);
        }
        return symbolArray;
    }

    public BoolSort getBoolSort() {
        if (this.m_boolSort == null) {
            this.m_boolSort = new BoolSort(this);
        }
        return this.m_boolSort;
    }

    public IntSort getIntSort() {
        if (this.m_intSort == null) {
            this.m_intSort = new IntSort(this);
        }
        return this.m_intSort;
    }

    public RealSort getRealSort() {
        if (this.m_realSort == null) {
            this.m_realSort = new RealSort(this);
        }
        return this.m_realSort;
    }

    public BoolSort mkBoolSort() {
        return new BoolSort(this);
    }

    public CharSort mkCharSort() {
        return new CharSort(this);
    }

    public SeqSort<CharSort> getStringSort() {
        if (this.m_stringSort == null) {
            this.m_stringSort = this.mkStringSort();
        }
        return this.m_stringSort;
    }

    public UninterpretedSort mkUninterpretedSort(Symbol symbol) {
        this.checkContextMatch(symbol);
        return new UninterpretedSort(this, symbol);
    }

    public UninterpretedSort mkUninterpretedSort(String string) {
        return this.mkUninterpretedSort(this.mkSymbol(string));
    }

    public IntSort mkIntSort() {
        return new IntSort(this);
    }

    public RealSort mkRealSort() {
        return new RealSort(this);
    }

    public BitVecSort mkBitVecSort(int n) {
        return new BitVecSort(this, Native.mkBvSort(this.nCtx(), n));
    }

    public final <D extends Sort, R extends Sort> ArraySort<D, R> mkArraySort(D d, R r) {
        this.checkContextMatch(d);
        this.checkContextMatch(r);
        return new ArraySort<D, R>(this, d, r);
    }

    public final <R extends Sort> ArraySort<Sort, R> mkArraySort(Sort[] sortArray, R r) {
        this.checkContextMatch(sortArray);
        this.checkContextMatch(r);
        return new ArraySort(this, sortArray, r);
    }

    public SeqSort<CharSort> mkStringSort() {
        return new SeqSort<CharSort>(this, Native.mkStringSort(this.nCtx()));
    }

    public final <R extends Sort> SeqSort<R> mkSeqSort(R r) {
        return new SeqSort(this, Native.mkSeqSort(this.nCtx(), r.getNativeObject()));
    }

    public final <R extends Sort> ReSort<R> mkReSort(R r) {
        return new ReSort(this, Native.mkReSort(this.nCtx(), r.getNativeObject()));
    }

    public TupleSort mkTupleSort(Symbol symbol, Symbol[] symbolArray, Sort[] sortArray) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(symbolArray);
        this.checkContextMatch(sortArray);
        return new TupleSort(this, symbol, symbolArray.length, symbolArray, sortArray);
    }

    public final <R> EnumSort<R> mkEnumSort(Symbol symbol, Symbol ... symbolArray) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(symbolArray);
        return new EnumSort(this, symbol, symbolArray);
    }

    public final <R> EnumSort<R> mkEnumSort(String string, String ... stringArray) {
        return new EnumSort(this, this.mkSymbol(string), this.mkSymbols(stringArray));
    }

    public final <R extends Sort> ListSort<R> mkListSort(Symbol symbol, R r) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(r);
        return new ListSort(this, symbol, r);
    }

    public final <R extends Sort> ListSort<R> mkListSort(String string, R r) {
        this.checkContextMatch(r);
        return new ListSort(this, this.mkSymbol(string), r);
    }

    public final <R> FiniteDomainSort<R> mkFiniteDomainSort(Symbol symbol, long l) {
        this.checkContextMatch(symbol);
        return new FiniteDomainSort(this, symbol, l);
    }

    public final <R> FiniteDomainSort<R> mkFiniteDomainSort(String string, long l) {
        return new FiniteDomainSort(this, this.mkSymbol(string), l);
    }

    public final <R> Constructor<R> mkConstructor(Symbol symbol, Symbol symbol2, Symbol[] symbolArray, Sort[] sortArray, int[] nArray) {
        return Constructor.of(this, symbol, symbol2, symbolArray, sortArray, nArray);
    }

    public final <R> Constructor<R> mkConstructor(String string, String string2, String[] stringArray, Sort[] sortArray, int[] nArray) {
        return Constructor.of(this, this.mkSymbol(string), this.mkSymbol(string2), this.mkSymbols(stringArray), sortArray, nArray);
    }

    public final <R> DatatypeSort<R> mkDatatypeSort(Symbol symbol, Constructor<R>[] constructorArray) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(constructorArray);
        return new DatatypeSort<R>(this, symbol, constructorArray);
    }

    public final <R> DatatypeSort<R> mkDatatypeSort(String string, Constructor<R>[] constructorArray) {
        this.checkContextMatch(constructorArray);
        return new DatatypeSort<R>(this, this.mkSymbol(string), constructorArray);
    }

    public DatatypeSort<Object>[] mkDatatypeSorts(Symbol[] symbolArray, Constructor<Object>[][] constructorArray) {
        Z3Object[] z3ObjectArray;
        this.checkContextMatch(symbolArray);
        int n = symbolArray.length;
        ConstructorList[] constructorListArray = new ConstructorList[n];
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            z3ObjectArray = constructorArray[i];
            this.checkContextMatch(z3ObjectArray);
            constructorListArray[i] = new ConstructorList(this, (Constructor<R>[])z3ObjectArray);
            lArray[i] = constructorListArray[i].getNativeObject();
        }
        long[] lArray2 = new long[n];
        Native.mkDatatypes(this.nCtx(), n, Symbol.arrayToNative(symbolArray), lArray2, lArray);
        z3ObjectArray = new DatatypeSort[n];
        for (int i = 0; i < n; ++i) {
            z3ObjectArray[i] = new DatatypeSort(this, lArray2[i]);
        }
        return z3ObjectArray;
    }

    public DatatypeSort<Object>[] mkDatatypeSorts(String[] stringArray, Constructor<Object>[][] constructorArray) {
        return this.mkDatatypeSorts(this.mkSymbols(stringArray), constructorArray);
    }

    public final <F extends Sort, R extends Sort> Expr<R> mkUpdateField(FuncDecl<F> funcDecl, Expr<R> expr, Expr<F> expr2) throws Z3Exception {
        return Expr.create(this, Native.datatypeUpdateField(this.nCtx(), funcDecl.getNativeObject(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public final <R extends Sort> FuncDecl<R> mkFuncDecl(Symbol symbol, Sort[] sortArray, R r) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(sortArray);
        this.checkContextMatch(r);
        return new FuncDecl<R>(this, symbol, sortArray, r);
    }

    public final <R extends Sort> FuncDecl<R> mkFuncDecl(Symbol symbol, Sort sort, R r) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(sort);
        this.checkContextMatch(r);
        Sort[] sortArray = new Sort[]{sort};
        return new FuncDecl<R>(this, symbol, sortArray, r);
    }

    public final <R extends Sort> FuncDecl<R> mkFuncDecl(String string, Sort[] sortArray, R r) {
        this.checkContextMatch(sortArray);
        this.checkContextMatch(r);
        return new FuncDecl<R>(this, this.mkSymbol(string), sortArray, r);
    }

    public final <R extends Sort> FuncDecl<R> mkFuncDecl(String string, Sort sort, R r) {
        this.checkContextMatch(sort);
        this.checkContextMatch(r);
        Sort[] sortArray = new Sort[]{sort};
        return new FuncDecl<R>(this, this.mkSymbol(string), sortArray, r);
    }

    public final <R extends Sort> FuncDecl<R> mkRecFuncDecl(Symbol symbol, Sort[] sortArray, R r) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(sortArray);
        this.checkContextMatch(r);
        return new FuncDecl<R>(this, symbol, sortArray, r, true);
    }

    public final <R extends Sort> void AddRecDef(FuncDecl<R> funcDecl, Expr<?>[] exprArray, Expr<R> expr) {
        this.checkContextMatch(funcDecl);
        this.checkContextMatch(exprArray);
        this.checkContextMatch(expr);
        long[] lArray = AST.arrayToNative(exprArray);
        Native.addRecDef(this.nCtx(), funcDecl.getNativeObject(), exprArray.length, lArray, expr.getNativeObject());
    }

    public final <R extends Sort> FuncDecl<R> mkFreshFuncDecl(String string, Sort[] sortArray, R r) {
        this.checkContextMatch(sortArray);
        this.checkContextMatch(r);
        return new FuncDecl<R>(this, string, sortArray, r);
    }

    public final <R extends Sort> FuncDecl<R> mkConstDecl(Symbol symbol, R r) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(r);
        return new FuncDecl<R>(this, symbol, null, r);
    }

    public final <R extends Sort> FuncDecl<R> mkConstDecl(String string, R r) {
        this.checkContextMatch(r);
        return new FuncDecl<R>(this, this.mkSymbol(string), null, r);
    }

    public final <R extends Sort> FuncDecl<R> mkFreshConstDecl(String string, R r) {
        this.checkContextMatch(r);
        return new FuncDecl<R>(this, string, null, r);
    }

    public final <R extends Sort> Expr<R> mkBound(int n, R r) {
        return Expr.create(this, Native.mkBound(this.nCtx(), n, r.getNativeObject()));
    }

    @SafeVarargs
    public final Pattern mkPattern(Expr<?> ... exprArray) {
        if (exprArray.length == 0) {
            throw new Z3Exception("Cannot create a pattern from zero terms");
        }
        long[] lArray = AST.arrayToNative(exprArray);
        return new Pattern(this, Native.mkPattern(this.nCtx(), exprArray.length, lArray));
    }

    public final <R extends Sort> Expr<R> mkConst(Symbol symbol, R r) {
        this.checkContextMatch(symbol);
        this.checkContextMatch(r);
        return Expr.create(this, Native.mkConst(this.nCtx(), symbol.getNativeObject(), r.getNativeObject()));
    }

    public final <R extends Sort> Expr<R> mkConst(String string, R r) {
        return this.mkConst(this.mkSymbol(string), r);
    }

    public final <R extends Sort> Expr<R> mkFreshConst(String string, R r) {
        this.checkContextMatch(r);
        return Expr.create(this, Native.mkFreshConst(this.nCtx(), string, r.getNativeObject()));
    }

    public final <R extends Sort> Expr<R> mkConst(FuncDecl<R> funcDecl) {
        return this.mkApp(funcDecl, null);
    }

    public BoolExpr mkBoolConst(Symbol symbol) {
        return (BoolExpr)this.mkConst(symbol, this.getBoolSort());
    }

    public BoolExpr mkBoolConst(String string) {
        return (BoolExpr)this.mkConst(this.mkSymbol(string), this.getBoolSort());
    }

    public IntExpr mkIntConst(Symbol symbol) {
        return (IntExpr)this.mkConst(symbol, this.getIntSort());
    }

    public IntExpr mkIntConst(String string) {
        return (IntExpr)this.mkConst(string, this.getIntSort());
    }

    public RealExpr mkRealConst(Symbol symbol) {
        return (RealExpr)this.mkConst(symbol, this.getRealSort());
    }

    public RealExpr mkRealConst(String string) {
        return (RealExpr)this.mkConst(string, this.getRealSort());
    }

    public BitVecExpr mkBVConst(Symbol symbol, int n) {
        return (BitVecExpr)this.mkConst(symbol, this.mkBitVecSort(n));
    }

    public BitVecExpr mkBVConst(String string, int n) {
        return (BitVecExpr)this.mkConst(string, this.mkBitVecSort(n));
    }

    @SafeVarargs
    public final <R extends Sort> Expr<R> mkApp(FuncDecl<R> funcDecl, Expr<?> ... exprArray) {
        this.checkContextMatch(funcDecl);
        this.checkContextMatch(exprArray);
        return Expr.create(this, funcDecl, exprArray);
    }

    public BoolExpr mkTrue() {
        return new BoolExpr(this, Native.mkTrue(this.nCtx()));
    }

    public BoolExpr mkFalse() {
        return new BoolExpr(this, Native.mkFalse(this.nCtx()));
    }

    public BoolExpr mkBool(boolean bl) {
        return bl ? this.mkTrue() : this.mkFalse();
    }

    public BoolExpr mkEq(Expr<?> expr, Expr<?> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkEq(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    @SafeVarargs
    public final BoolExpr mkDistinct(Expr<?> ... exprArray) {
        this.checkContextMatch(exprArray);
        return new BoolExpr(this, Native.mkDistinct(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray)));
    }

    public final BoolExpr mkNot(Expr<BoolSort> expr) {
        this.checkContextMatch(expr);
        return new BoolExpr(this, Native.mkNot(this.nCtx(), expr.getNativeObject()));
    }

    public final <R extends Sort> Expr<R> mkITE(Expr<BoolSort> expr, Expr<? extends R> expr2, Expr<? extends R> expr3) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        this.checkContextMatch(expr3);
        return Expr.create(this, Native.mkIte(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), expr3.getNativeObject()));
    }

    public BoolExpr mkIff(Expr<BoolSort> expr, Expr<BoolSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkIff(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkImplies(Expr<BoolSort> expr, Expr<BoolSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkImplies(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkXor(Expr<BoolSort> expr, Expr<BoolSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkXor(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    @SafeVarargs
    public final BoolExpr mkAnd(Expr<BoolSort> ... exprArray) {
        this.checkContextMatch(exprArray);
        return new BoolExpr(this, Native.mkAnd(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray)));
    }

    @SafeVarargs
    public final BoolExpr mkOr(Expr<BoolSort> ... exprArray) {
        this.checkContextMatch(exprArray);
        return new BoolExpr(this, Native.mkOr(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray)));
    }

    @SafeVarargs
    public final <R extends ArithSort> ArithExpr<R> mkAdd(Expr<? extends R> ... exprArray) {
        this.checkContextMatch(exprArray);
        return (ArithExpr)Expr.create(this, Native.mkAdd(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray)));
    }

    @SafeVarargs
    public final <R extends ArithSort> ArithExpr<R> mkMul(Expr<? extends R> ... exprArray) {
        this.checkContextMatch(exprArray);
        return (ArithExpr)Expr.create(this, Native.mkMul(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray)));
    }

    @SafeVarargs
    public final <R extends ArithSort> ArithExpr<R> mkSub(Expr<? extends R> ... exprArray) {
        this.checkContextMatch(exprArray);
        return (ArithExpr)Expr.create(this, Native.mkSub(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray)));
    }

    public final <R extends ArithSort> ArithExpr<R> mkUnaryMinus(Expr<R> expr) {
        this.checkContextMatch(expr);
        return (ArithExpr)Expr.create(this, Native.mkUnaryMinus(this.nCtx(), expr.getNativeObject()));
    }

    public final <R extends ArithSort> ArithExpr<R> mkDiv(Expr<? extends R> expr, Expr<? extends R> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return (ArithExpr)Expr.create(this, Native.mkDiv(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public IntExpr mkMod(Expr<IntSort> expr, Expr<IntSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new IntExpr(this, Native.mkMod(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public IntExpr mkRem(Expr<IntSort> expr, Expr<IntSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new IntExpr(this, Native.mkRem(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public final <R extends ArithSort> ArithExpr<R> mkPower(Expr<? extends R> expr, Expr<? extends R> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return (ArithExpr)Expr.create(this, Native.mkPower(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkLt(Expr<? extends ArithSort> expr, Expr<? extends ArithSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkLt(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkLe(Expr<? extends ArithSort> expr, Expr<? extends ArithSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkLe(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkGt(Expr<? extends ArithSort> expr, Expr<? extends ArithSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkGt(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkGe(Expr<? extends ArithSort> expr, Expr<? extends ArithSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkGe(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public RealExpr mkInt2Real(Expr<IntSort> expr) {
        this.checkContextMatch(expr);
        return new RealExpr(this, Native.mkInt2real(this.nCtx(), expr.getNativeObject()));
    }

    public IntExpr mkReal2Int(Expr<RealSort> expr) {
        this.checkContextMatch(expr);
        return new IntExpr(this, Native.mkReal2int(this.nCtx(), expr.getNativeObject()));
    }

    public BoolExpr mkIsInteger(Expr<RealSort> expr) {
        this.checkContextMatch(expr);
        return new BoolExpr(this, Native.mkIsInt(this.nCtx(), expr.getNativeObject()));
    }

    public BitVecExpr mkBVNot(Expr<BitVecSort> expr) {
        this.checkContextMatch(expr);
        return new BitVecExpr(this, Native.mkBvnot(this.nCtx(), expr.getNativeObject()));
    }

    public BitVecExpr mkBVRedAND(Expr<BitVecSort> expr) {
        this.checkContextMatch(expr);
        return new BitVecExpr(this, Native.mkBvredand(this.nCtx(), expr.getNativeObject()));
    }

    public BitVecExpr mkBVRedOR(Expr<BitVecSort> expr) {
        this.checkContextMatch(expr);
        return new BitVecExpr(this, Native.mkBvredor(this.nCtx(), expr.getNativeObject()));
    }

    public BitVecExpr mkBVAND(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvand(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVOR(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvor(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVXOR(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvxor(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVNAND(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvnand(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVNOR(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvnor(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVXNOR(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvxnor(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVNeg(Expr<BitVecSort> expr) {
        this.checkContextMatch(expr);
        return new BitVecExpr(this, Native.mkBvneg(this.nCtx(), expr.getNativeObject()));
    }

    public BitVecExpr mkBVAdd(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvadd(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVSub(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvsub(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVMul(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvmul(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVUDiv(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvudiv(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVSDiv(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvsdiv(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVURem(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvurem(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVSRem(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvsrem(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVSMod(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvsmod(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkBVULT(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkBvult(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkBVSLT(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkBvslt(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkBVULE(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkBvule(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkBVSLE(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkBvsle(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkBVUGE(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkBvuge(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkBVSGE(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkBvsge(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkBVUGT(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkBvugt(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkBVSGT(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkBvsgt(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkConcat(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkConcat(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkExtract(int n, int n2, Expr<BitVecSort> expr) {
        this.checkContextMatch(expr);
        return new BitVecExpr(this, Native.mkExtract(this.nCtx(), n, n2, expr.getNativeObject()));
    }

    public BitVecExpr mkSignExt(int n, Expr<BitVecSort> expr) {
        this.checkContextMatch(expr);
        return new BitVecExpr(this, Native.mkSignExt(this.nCtx(), n, expr.getNativeObject()));
    }

    public BitVecExpr mkZeroExt(int n, Expr<BitVecSort> expr) {
        this.checkContextMatch(expr);
        return new BitVecExpr(this, Native.mkZeroExt(this.nCtx(), n, expr.getNativeObject()));
    }

    public BitVecExpr mkRepeat(int n, Expr<BitVecSort> expr) {
        this.checkContextMatch(expr);
        return new BitVecExpr(this, Native.mkRepeat(this.nCtx(), n, expr.getNativeObject()));
    }

    public BitVecExpr mkBVSHL(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvshl(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVLSHR(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvlshr(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVASHR(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkBvashr(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVRotateLeft(int n, Expr<BitVecSort> expr) {
        this.checkContextMatch(expr);
        return new BitVecExpr(this, Native.mkRotateLeft(this.nCtx(), n, expr.getNativeObject()));
    }

    public BitVecExpr mkBVRotateRight(int n, Expr<BitVecSort> expr) {
        this.checkContextMatch(expr);
        return new BitVecExpr(this, Native.mkRotateRight(this.nCtx(), n, expr.getNativeObject()));
    }

    public BitVecExpr mkBVRotateLeft(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkExtRotateLeft(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkBVRotateRight(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BitVecExpr(this, Native.mkExtRotateRight(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkInt2BV(int n, Expr<IntSort> expr) {
        this.checkContextMatch(expr);
        return new BitVecExpr(this, Native.mkInt2bv(this.nCtx(), n, expr.getNativeObject()));
    }

    public IntExpr mkBV2Int(Expr<BitVecSort> expr, boolean bl) {
        this.checkContextMatch(expr);
        return new IntExpr(this, Native.mkBv2int(this.nCtx(), expr.getNativeObject(), bl));
    }

    public BoolExpr mkBVAddNoOverflow(Expr<BitVecSort> expr, Expr<BitVecSort> expr2, boolean bl) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkBvaddNoOverflow(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), bl));
    }

    public BoolExpr mkBVAddNoUnderflow(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkBvaddNoUnderflow(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkBVSubNoOverflow(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkBvsubNoOverflow(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkBVSubNoUnderflow(Expr<BitVecSort> expr, Expr<BitVecSort> expr2, boolean bl) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkBvsubNoUnderflow(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), bl));
    }

    public BoolExpr mkBVSDivNoOverflow(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkBvsdivNoOverflow(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkBVNegNoOverflow(Expr<BitVecSort> expr) {
        this.checkContextMatch(expr);
        return new BoolExpr(this, Native.mkBvnegNoOverflow(this.nCtx(), expr.getNativeObject()));
    }

    public BoolExpr mkBVMulNoOverflow(Expr<BitVecSort> expr, Expr<BitVecSort> expr2, boolean bl) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkBvmulNoOverflow(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), bl));
    }

    public BoolExpr mkBVMulNoUnderflow(Expr<BitVecSort> expr, Expr<BitVecSort> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return new BoolExpr(this, Native.mkBvmulNoUnderflow(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public final <D extends Sort, R extends Sort> ArrayExpr<D, R> mkArrayConst(Symbol symbol, D d, R r) {
        return (ArrayExpr)this.mkConst(symbol, this.mkArraySort(d, r));
    }

    public final <D extends Sort, R extends Sort> ArrayExpr<D, R> mkArrayConst(String string, D d, R r) {
        return (ArrayExpr)this.mkConst(this.mkSymbol(string), this.mkArraySort(d, r));
    }

    public final <D extends Sort, R extends Sort> Expr<R> mkSelect(Expr<ArraySort<D, R>> expr, Expr<D> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return Expr.create(this, Native.mkSelect(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public final <R extends Sort> Expr<R> mkSelect(Expr<ArraySort<Sort, R>> expr, Expr<?>[] exprArray) {
        this.checkContextMatch(expr);
        this.checkContextMatch(exprArray);
        return Expr.create(this, Native.mkSelectN(this.nCtx(), expr.getNativeObject(), exprArray.length, AST.arrayToNative(exprArray)));
    }

    public final <D extends Sort, R extends Sort> ArrayExpr<D, R> mkStore(Expr<ArraySort<D, R>> expr, Expr<D> expr2, Expr<R> expr3) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        this.checkContextMatch(expr3);
        return new ArrayExpr(this, Native.mkStore(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), expr3.getNativeObject()));
    }

    public final <R extends Sort> ArrayExpr<Sort, R> mkStore(Expr<ArraySort<Sort, R>> expr, Expr<?>[] exprArray, Expr<R> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(exprArray);
        this.checkContextMatch(expr2);
        return new ArrayExpr(this, Native.mkStoreN(this.nCtx(), expr.getNativeObject(), exprArray.length, AST.arrayToNative(exprArray), expr2.getNativeObject()));
    }

    public final <D extends Sort, R extends Sort> ArrayExpr<D, R> mkConstArray(D d, Expr<R> expr) {
        this.checkContextMatch(d);
        this.checkContextMatch(expr);
        return new ArrayExpr(this, Native.mkConstArray(this.nCtx(), d.getNativeObject(), expr.getNativeObject()));
    }

    @SafeVarargs
    public final <D extends Sort, R1 extends Sort, R2 extends Sort> ArrayExpr<D, R2> mkMap(FuncDecl<R2> funcDecl, Expr<ArraySort<D, R1>> ... exprArray) {
        this.checkContextMatch(funcDecl);
        this.checkContextMatch(exprArray);
        return (ArrayExpr)Expr.create(this, Native.mkMap(this.nCtx(), funcDecl.getNativeObject(), AST.arrayLength(exprArray), AST.arrayToNative(exprArray)));
    }

    public final <D extends Sort, R extends Sort> Expr<R> mkTermArray(Expr<ArraySort<D, R>> expr) {
        this.checkContextMatch(expr);
        return Expr.create(this, Native.mkArrayDefault(this.nCtx(), expr.getNativeObject()));
    }

    public final <D extends Sort, R extends Sort> Expr<D> mkArrayExt(Expr<ArraySort<D, R>> expr, Expr<ArraySort<D, R>> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return Expr.create(this, Native.mkArrayExt(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public final <D extends Sort> SetSort<D> mkSetSort(D d) {
        this.checkContextMatch(d);
        return new SetSort<D>(this, d);
    }

    public final <D extends Sort> ArrayExpr<D, BoolSort> mkEmptySet(D d) {
        this.checkContextMatch(d);
        return (ArrayExpr)Expr.create(this, Native.mkEmptySet(this.nCtx(), d.getNativeObject()));
    }

    public final <D extends Sort> ArrayExpr<D, BoolSort> mkFullSet(D d) {
        this.checkContextMatch(d);
        return (ArrayExpr)Expr.create(this, Native.mkFullSet(this.nCtx(), d.getNativeObject()));
    }

    public final <D extends Sort> ArrayExpr<D, BoolSort> mkSetAdd(Expr<ArraySort<D, BoolSort>> expr, Expr<D> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return (ArrayExpr)Expr.create(this, Native.mkSetAdd(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public final <D extends Sort> ArrayExpr<D, BoolSort> mkSetDel(Expr<ArraySort<D, BoolSort>> expr, Expr<D> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return (ArrayExpr)Expr.create(this, Native.mkSetDel(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    @SafeVarargs
    public final <D extends Sort> ArrayExpr<D, BoolSort> mkSetUnion(Expr<ArraySort<D, BoolSort>> ... exprArray) {
        this.checkContextMatch(exprArray);
        return (ArrayExpr)Expr.create(this, Native.mkSetUnion(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray)));
    }

    @SafeVarargs
    public final <D extends Sort> ArrayExpr<D, BoolSort> mkSetIntersection(Expr<ArraySort<D, BoolSort>> ... exprArray) {
        this.checkContextMatch(exprArray);
        return (ArrayExpr)Expr.create(this, Native.mkSetIntersect(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray)));
    }

    public final <D extends Sort> ArrayExpr<D, BoolSort> mkSetDifference(Expr<ArraySort<D, BoolSort>> expr, Expr<ArraySort<D, BoolSort>> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return (ArrayExpr)Expr.create(this, Native.mkSetDifference(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public final <D extends Sort> ArrayExpr<D, BoolSort> mkSetComplement(Expr<ArraySort<D, BoolSort>> expr) {
        this.checkContextMatch(expr);
        return (ArrayExpr)Expr.create(this, Native.mkSetComplement(this.nCtx(), expr.getNativeObject()));
    }

    public final <D extends Sort> BoolExpr mkSetMembership(Expr<D> expr, Expr<ArraySort<D, BoolSort>> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return (BoolExpr)Expr.create(this, Native.mkSetMember(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public final <D extends Sort> BoolExpr mkSetSubset(Expr<ArraySort<D, BoolSort>> expr, Expr<ArraySort<D, BoolSort>> expr2) {
        this.checkContextMatch(expr);
        this.checkContextMatch(expr2);
        return (BoolExpr)Expr.create(this, Native.mkSetSubset(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public final <R extends Sort> SeqExpr<R> mkEmptySeq(R r) {
        this.checkContextMatch(r);
        return (SeqExpr)Expr.create(this, Native.mkSeqEmpty(this.nCtx(), r.getNativeObject()));
    }

    public final <R extends Sort> SeqExpr<R> mkUnit(Expr<R> expr) {
        this.checkContextMatch(expr);
        return (SeqExpr)Expr.create(this, Native.mkSeqUnit(this.nCtx(), expr.getNativeObject()));
    }

    public SeqExpr<CharSort> mkString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            int n = string.codePointAt(i);
            if (n <= 32 || 127 < n) {
                stringBuilder.append(String.format("\\u{%x}", n));
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return (SeqExpr)Expr.create(this, Native.mkString(this.nCtx(), stringBuilder.toString()));
    }

    public SeqExpr<CharSort> intToString(Expr<IntSort> expr) {
        return (SeqExpr)Expr.create(this, Native.mkIntToStr(this.nCtx(), expr.getNativeObject()));
    }

    public SeqExpr<CharSort> ubvToString(Expr<BitVecSort> expr) {
        return (SeqExpr)Expr.create(this, Native.mkUbvToStr(this.nCtx(), expr.getNativeObject()));
    }

    public SeqExpr<CharSort> sbvToString(Expr<BitVecSort> expr) {
        return (SeqExpr)Expr.create(this, Native.mkSbvToStr(this.nCtx(), expr.getNativeObject()));
    }

    public IntExpr stringToInt(Expr<SeqSort<CharSort>> expr) {
        return (IntExpr)Expr.create(this, Native.mkStrToInt(this.nCtx(), expr.getNativeObject()));
    }

    @SafeVarargs
    public final <R extends Sort> SeqExpr<R> mkConcat(Expr<SeqSort<R>> ... exprArray) {
        this.checkContextMatch(exprArray);
        return (SeqExpr)Expr.create(this, Native.mkSeqConcat(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray)));
    }

    public final <R extends Sort> IntExpr mkLength(Expr<SeqSort<R>> expr) {
        this.checkContextMatch(expr);
        return (IntExpr)Expr.create(this, Native.mkSeqLength(this.nCtx(), expr.getNativeObject()));
    }

    public final <R extends Sort> BoolExpr mkPrefixOf(Expr<SeqSort<R>> expr, Expr<SeqSort<R>> expr2) {
        this.checkContextMatch(expr, expr2);
        return (BoolExpr)Expr.create(this, Native.mkSeqPrefix(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public final <R extends Sort> BoolExpr mkSuffixOf(Expr<SeqSort<R>> expr, Expr<SeqSort<R>> expr2) {
        this.checkContextMatch(expr, expr2);
        return (BoolExpr)Expr.create(this, Native.mkSeqSuffix(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public final <R extends Sort> BoolExpr mkContains(Expr<SeqSort<R>> expr, Expr<SeqSort<R>> expr2) {
        this.checkContextMatch(expr, expr2);
        return (BoolExpr)Expr.create(this, Native.mkSeqContains(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr MkStringLt(Expr<SeqSort<CharSort>> expr, Expr<SeqSort<CharSort>> expr2) {
        this.checkContextMatch(expr, expr2);
        return new BoolExpr(this, Native.mkStrLt(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr MkStringLe(Expr<SeqSort<CharSort>> expr, Expr<SeqSort<CharSort>> expr2) {
        this.checkContextMatch(expr, expr2);
        return new BoolExpr(this, Native.mkStrLe(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public final <R extends Sort> SeqExpr<R> mkAt(Expr<SeqSort<R>> expr, Expr<IntSort> expr2) {
        this.checkContextMatch(expr, expr2);
        return (SeqExpr)Expr.create(this, Native.mkSeqAt(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public final <R extends Sort> Expr<R> mkNth(Expr<SeqSort<R>> expr, Expr<IntSort> expr2) {
        this.checkContextMatch(expr, expr2);
        return Expr.create(this, Native.mkSeqNth(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public final <R extends Sort> SeqExpr<R> mkExtract(Expr<SeqSort<R>> expr, Expr<IntSort> expr2, Expr<IntSort> expr3) {
        this.checkContextMatch(expr, expr2, expr3);
        return (SeqExpr)Expr.create(this, Native.mkSeqExtract(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), expr3.getNativeObject()));
    }

    public final <R extends Sort> IntExpr mkIndexOf(Expr<SeqSort<R>> expr, Expr<SeqSort<R>> expr2, Expr<IntSort> expr3) {
        this.checkContextMatch(expr, expr2, expr3);
        return (IntExpr)Expr.create(this, Native.mkSeqIndex(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), expr3.getNativeObject()));
    }

    public final <R extends Sort> SeqExpr<R> mkReplace(Expr<SeqSort<R>> expr, Expr<SeqSort<R>> expr2, Expr<SeqSort<R>> expr3) {
        this.checkContextMatch(expr, expr2, expr3);
        return (SeqExpr)Expr.create(this, Native.mkSeqReplace(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), expr3.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<SeqSort<R>> mkToRe(Expr<SeqSort<R>> expr) {
        this.checkContextMatch(expr);
        return (ReExpr)Expr.create(this, Native.mkSeqToRe(this.nCtx(), expr.getNativeObject()));
    }

    public final <R extends Sort> BoolExpr mkInRe(Expr<SeqSort<R>> expr, ReExpr<SeqSort<R>> reExpr) {
        this.checkContextMatch(expr, reExpr);
        return (BoolExpr)Expr.create(this, Native.mkSeqInRe(this.nCtx(), expr.getNativeObject(), reExpr.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<R> mkStar(Expr<ReSort<R>> expr) {
        this.checkContextMatch(expr);
        return (ReExpr)Expr.create(this, Native.mkReStar(this.nCtx(), expr.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<R> mkPower(Expr<ReSort<R>> expr, int n) {
        return (ReExpr)Expr.create(this, Native.mkRePower(this.nCtx(), expr.getNativeObject(), n));
    }

    public final <R extends Sort> ReExpr<R> mkLoop(Expr<ReSort<R>> expr, int n, int n2) {
        return (ReExpr)Expr.create(this, Native.mkReLoop(this.nCtx(), expr.getNativeObject(), n, n2));
    }

    public final <R extends Sort> ReExpr<R> mkLoop(Expr<ReSort<R>> expr, int n) {
        return (ReExpr)Expr.create(this, Native.mkReLoop(this.nCtx(), expr.getNativeObject(), n, 0));
    }

    public final <R extends Sort> ReExpr<R> mkPlus(Expr<ReSort<R>> expr) {
        this.checkContextMatch(expr);
        return (ReExpr)Expr.create(this, Native.mkRePlus(this.nCtx(), expr.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<R> mkOption(Expr<ReSort<R>> expr) {
        this.checkContextMatch(expr);
        return (ReExpr)Expr.create(this, Native.mkReOption(this.nCtx(), expr.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<R> mkComplement(Expr<ReSort<R>> expr) {
        this.checkContextMatch(expr);
        return (ReExpr)Expr.create(this, Native.mkReComplement(this.nCtx(), expr.getNativeObject()));
    }

    @SafeVarargs
    public final <R extends Sort> ReExpr<R> mkConcat(ReExpr<R> ... reExprArray) {
        this.checkContextMatch(reExprArray);
        return (ReExpr)Expr.create(this, Native.mkReConcat(this.nCtx(), reExprArray.length, AST.arrayToNative(reExprArray)));
    }

    @SafeVarargs
    public final <R extends Sort> ReExpr<R> mkUnion(Expr<ReSort<R>> ... exprArray) {
        this.checkContextMatch(exprArray);
        return (ReExpr)Expr.create(this, Native.mkReUnion(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray)));
    }

    @SafeVarargs
    public final <R extends Sort> ReExpr<R> mkIntersect(Expr<ReSort<R>> ... exprArray) {
        this.checkContextMatch(exprArray);
        return (ReExpr)Expr.create(this, Native.mkReIntersect(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray)));
    }

    public final <R extends Sort> ReExpr<R> mkDiff(Expr<ReSort<R>> expr, Expr<ReSort<R>> expr2) {
        this.checkContextMatch(expr, expr2);
        return (ReExpr)Expr.create(this, Native.mkReDiff(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<R> mkEmptyRe(ReSort<R> reSort) {
        return (ReExpr)Expr.create(this, Native.mkReEmpty(this.nCtx(), reSort.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<R> mkFullRe(ReSort<R> reSort) {
        return (ReExpr)Expr.create(this, Native.mkReFull(this.nCtx(), reSort.getNativeObject()));
    }

    public final <R extends Sort> ReExpr<R> mkAllcharRe(ReSort<R> reSort) {
        return (ReExpr)Expr.create(this, Native.mkReAllchar(this.nCtx(), reSort.getNativeObject()));
    }

    public final ReExpr<SeqSort<CharSort>> mkRange(Expr<SeqSort<CharSort>> expr, Expr<SeqSort<CharSort>> expr2) {
        this.checkContextMatch(expr, expr2);
        return (ReExpr)Expr.create(this, Native.mkReRange(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkCharLe(Expr<CharSort> expr, Expr<CharSort> expr2) {
        this.checkContextMatch(expr, expr2);
        return (BoolExpr)Expr.create(this, Native.mkCharLe(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public IntExpr charToInt(Expr<CharSort> expr) {
        this.checkContextMatch(expr);
        return (IntExpr)Expr.create(this, Native.mkCharToInt(this.nCtx(), expr.getNativeObject()));
    }

    public BitVecExpr charToBv(Expr<CharSort> expr) {
        this.checkContextMatch(expr);
        return (BitVecExpr)Expr.create(this, Native.mkCharToBv(this.nCtx(), expr.getNativeObject()));
    }

    public Expr<CharSort> charFromBv(BitVecExpr bitVecExpr) {
        this.checkContextMatch(bitVecExpr);
        return Expr.create(this, Native.mkCharFromBv(this.nCtx(), bitVecExpr.getNativeObject()));
    }

    public BoolExpr mkIsDigit(Expr<CharSort> expr) {
        this.checkContextMatch(expr);
        return (BoolExpr)Expr.create(this, Native.mkCharIsDigit(this.nCtx(), expr.getNativeObject()));
    }

    public BoolExpr mkAtMost(Expr<BoolSort>[] exprArray, int n) {
        this.checkContextMatch(exprArray);
        return (BoolExpr)Expr.create(this, Native.mkAtmost(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray), n));
    }

    public BoolExpr mkAtLeast(Expr<BoolSort>[] exprArray, int n) {
        this.checkContextMatch(exprArray);
        return (BoolExpr)Expr.create(this, Native.mkAtleast(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray), n));
    }

    public BoolExpr mkPBLe(int[] nArray, Expr<BoolSort>[] exprArray, int n) {
        this.checkContextMatch(exprArray);
        return (BoolExpr)Expr.create(this, Native.mkPble(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray), nArray, n));
    }

    public BoolExpr mkPBGe(int[] nArray, Expr<BoolSort>[] exprArray, int n) {
        this.checkContextMatch(exprArray);
        return (BoolExpr)Expr.create(this, Native.mkPbge(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray), nArray, n));
    }

    public BoolExpr mkPBEq(int[] nArray, Expr<BoolSort>[] exprArray, int n) {
        this.checkContextMatch(exprArray);
        return (BoolExpr)Expr.create(this, Native.mkPbeq(this.nCtx(), exprArray.length, AST.arrayToNative(exprArray), nArray, n));
    }

    public final <R extends Sort> Expr<R> mkNumeral(String string, R r) {
        this.checkContextMatch(r);
        return Expr.create(this, Native.mkNumeral(this.nCtx(), string, r.getNativeObject()));
    }

    public final <R extends Sort> Expr<R> mkNumeral(int n, R r) {
        this.checkContextMatch(r);
        return Expr.create(this, Native.mkInt(this.nCtx(), n, r.getNativeObject()));
    }

    public final <R extends Sort> Expr<R> mkNumeral(long l, R r) {
        this.checkContextMatch(r);
        return Expr.create(this, Native.mkInt64(this.nCtx(), l, r.getNativeObject()));
    }

    public RatNum mkReal(int n, int n2) {
        if (n2 == 0) {
            throw new Z3Exception("Denominator is zero");
        }
        return new RatNum(this, Native.mkReal(this.nCtx(), n, n2));
    }

    public RatNum mkReal(String string) {
        return new RatNum(this, Native.mkNumeral(this.nCtx(), string, this.getRealSort().getNativeObject()));
    }

    public RatNum mkReal(int n) {
        return new RatNum(this, Native.mkInt(this.nCtx(), n, this.getRealSort().getNativeObject()));
    }

    public RatNum mkReal(long l) {
        return new RatNum(this, Native.mkInt64(this.nCtx(), l, this.getRealSort().getNativeObject()));
    }

    public IntNum mkInt(String string) {
        return new IntNum(this, Native.mkNumeral(this.nCtx(), string, this.getIntSort().getNativeObject()));
    }

    public IntNum mkInt(int n) {
        return new IntNum(this, Native.mkInt(this.nCtx(), n, this.getIntSort().getNativeObject()));
    }

    public IntNum mkInt(long l) {
        return new IntNum(this, Native.mkInt64(this.nCtx(), l, this.getIntSort().getNativeObject()));
    }

    public BitVecNum mkBV(String string, int n) {
        return (BitVecNum)this.mkNumeral(string, this.mkBitVecSort(n));
    }

    public BitVecNum mkBV(int n, int n2) {
        return (BitVecNum)this.mkNumeral(n, (Sort)this.mkBitVecSort(n2));
    }

    public BitVecNum mkBV(long l, int n) {
        return (BitVecNum)this.mkNumeral(l, this.mkBitVecSort(n));
    }

    public Quantifier mkForall(Sort[] sortArray, Symbol[] symbolArray, Expr<BoolSort> expr, int n, Pattern[] patternArray, Expr<?>[] exprArray, Symbol symbol, Symbol symbol2) {
        return Quantifier.of(this, true, sortArray, symbolArray, expr, n, patternArray, exprArray, symbol, symbol2);
    }

    public Quantifier mkForall(Expr<?>[] exprArray, Expr<BoolSort> expr, int n, Pattern[] patternArray, Expr<?>[] exprArray2, Symbol symbol, Symbol symbol2) {
        return Quantifier.of(this, true, exprArray, expr, n, patternArray, exprArray2, symbol, symbol2);
    }

    public Quantifier mkExists(Sort[] sortArray, Symbol[] symbolArray, Expr<BoolSort> expr, int n, Pattern[] patternArray, Expr<?>[] exprArray, Symbol symbol, Symbol symbol2) {
        return Quantifier.of(this, false, sortArray, symbolArray, expr, n, patternArray, exprArray, symbol, symbol2);
    }

    public Quantifier mkExists(Expr<?>[] exprArray, Expr<BoolSort> expr, int n, Pattern[] patternArray, Expr<?>[] exprArray2, Symbol symbol, Symbol symbol2) {
        return Quantifier.of(this, false, exprArray, expr, n, patternArray, exprArray2, symbol, symbol2);
    }

    public Quantifier mkQuantifier(boolean bl, Sort[] sortArray, Symbol[] symbolArray, Expr<BoolSort> expr, int n, Pattern[] patternArray, Expr<?>[] exprArray, Symbol symbol, Symbol symbol2) {
        if (bl) {
            return this.mkForall(sortArray, symbolArray, expr, n, patternArray, exprArray, symbol, symbol2);
        }
        return this.mkExists(sortArray, symbolArray, expr, n, patternArray, exprArray, symbol, symbol2);
    }

    public Quantifier mkQuantifier(boolean bl, Expr<?>[] exprArray, Expr<BoolSort> expr, int n, Pattern[] patternArray, Expr<?>[] exprArray2, Symbol symbol, Symbol symbol2) {
        if (bl) {
            return this.mkForall(exprArray, expr, n, patternArray, exprArray2, symbol, symbol2);
        }
        return this.mkExists(exprArray, expr, n, patternArray, exprArray2, symbol, symbol2);
    }

    public final <R extends Sort> Lambda<R> mkLambda(Sort[] sortArray, Symbol[] symbolArray, Expr<R> expr) {
        return Lambda.of(this, sortArray, symbolArray, expr);
    }

    public final <R extends Sort> Lambda<R> mkLambda(Expr<?>[] exprArray, Expr<R> expr) {
        return Lambda.of(this, exprArray, expr);
    }

    public void setPrintMode(Z3_ast_print_mode z3_ast_print_mode) {
        Native.setAstPrintMode(this.nCtx(), z3_ast_print_mode.toInt());
    }

    public String benchmarkToSMTString(String string, String string2, String string3, String string4, Expr<BoolSort>[] exprArray, Expr<BoolSort> expr) {
        return Native.benchmarkToSmtlibString(this.nCtx(), string, string2, string3, string4, exprArray.length, AST.arrayToNative(exprArray), expr.getNativeObject());
    }

    public BoolExpr[] parseSMTLIB2String(String string, Symbol[] symbolArray, Sort[] sortArray, Symbol[] symbolArray2, FuncDecl<?>[] funcDeclArray) {
        int n = Symbol.arrayLength(symbolArray);
        int n2 = Sort.arrayLength(sortArray);
        int n3 = Symbol.arrayLength(symbolArray2);
        int n4 = AST.arrayLength(funcDeclArray);
        if (n != n2 || n3 != n4) {
            throw new Z3Exception("Argument size mismatch");
        }
        ASTVector aSTVector = new ASTVector(this, Native.parseSmtlib2String(this.nCtx(), string, AST.arrayLength(sortArray), Symbol.arrayToNative(symbolArray), AST.arrayToNative(sortArray), AST.arrayLength(funcDeclArray), Symbol.arrayToNative(symbolArray2), AST.arrayToNative(funcDeclArray)));
        return aSTVector.ToBoolExprArray();
    }

    public BoolExpr[] parseSMTLIB2File(String string, Symbol[] symbolArray, Sort[] sortArray, Symbol[] symbolArray2, FuncDecl<?>[] funcDeclArray) {
        int n = Symbol.arrayLength(symbolArray);
        int n2 = Sort.arrayLength(sortArray);
        int n3 = Symbol.arrayLength(symbolArray2);
        int n4 = AST.arrayLength(funcDeclArray);
        if (n != n2 || n3 != n4) {
            throw new Z3Exception("Argument size mismatch");
        }
        ASTVector aSTVector = new ASTVector(this, Native.parseSmtlib2File(this.nCtx(), string, AST.arrayLength(sortArray), Symbol.arrayToNative(symbolArray), AST.arrayToNative(sortArray), AST.arrayLength(funcDeclArray), Symbol.arrayToNative(symbolArray2), AST.arrayToNative(funcDeclArray)));
        return aSTVector.ToBoolExprArray();
    }

    public Goal mkGoal(boolean bl, boolean bl2, boolean bl3) {
        return new Goal(this, bl, bl2, bl3);
    }

    public Params mkParams() {
        return new Params(this);
    }

    public int getNumTactics() {
        return Native.getNumTactics(this.nCtx());
    }

    public String[] getTacticNames() {
        int n = this.getNumTactics();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Native.getTacticName(this.nCtx(), i);
        }
        return stringArray;
    }

    public String getTacticDescription(String string) {
        return Native.tacticGetDescr(this.nCtx(), string);
    }

    public Tactic mkTactic(String string) {
        return new Tactic(this, string);
    }

    public Tactic andThen(Tactic tactic, Tactic tactic2, Tactic ... tacticArray) {
        this.checkContextMatch(tactic);
        this.checkContextMatch(tactic2);
        this.checkContextMatch(tacticArray);
        long l = 0L;
        if (tacticArray != null && tacticArray.length > 0) {
            l = tacticArray[tacticArray.length - 1].getNativeObject();
            for (int i = tacticArray.length - 2; i >= 0; --i) {
                l = Native.tacticAndThen(this.nCtx(), tacticArray[i].getNativeObject(), l);
            }
        }
        if (l != 0L) {
            l = Native.tacticAndThen(this.nCtx(), tactic2.getNativeObject(), l);
            return new Tactic(this, Native.tacticAndThen(this.nCtx(), tactic.getNativeObject(), l));
        }
        return new Tactic(this, Native.tacticAndThen(this.nCtx(), tactic.getNativeObject(), tactic2.getNativeObject()));
    }

    public Tactic then(Tactic tactic, Tactic tactic2, Tactic ... tacticArray) {
        return this.andThen(tactic, tactic2, tacticArray);
    }

    public Tactic orElse(Tactic tactic, Tactic tactic2) {
        this.checkContextMatch(tactic);
        this.checkContextMatch(tactic2);
        return new Tactic(this, Native.tacticOrElse(this.nCtx(), tactic.getNativeObject(), tactic2.getNativeObject()));
    }

    public Tactic tryFor(Tactic tactic, int n) {
        this.checkContextMatch(tactic);
        return new Tactic(this, Native.tacticTryFor(this.nCtx(), tactic.getNativeObject(), n));
    }

    public Tactic when(Probe probe, Tactic tactic) {
        this.checkContextMatch(tactic);
        this.checkContextMatch(probe);
        return new Tactic(this, Native.tacticWhen(this.nCtx(), probe.getNativeObject(), tactic.getNativeObject()));
    }

    public Tactic cond(Probe probe, Tactic tactic, Tactic tactic2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(tactic);
        this.checkContextMatch(tactic2);
        return new Tactic(this, Native.tacticCond(this.nCtx(), probe.getNativeObject(), tactic.getNativeObject(), tactic2.getNativeObject()));
    }

    public Tactic repeat(Tactic tactic, int n) {
        this.checkContextMatch(tactic);
        return new Tactic(this, Native.tacticRepeat(this.nCtx(), tactic.getNativeObject(), n));
    }

    public Tactic skip() {
        return new Tactic(this, Native.tacticSkip(this.nCtx()));
    }

    public Tactic fail() {
        return new Tactic(this, Native.tacticFail(this.nCtx()));
    }

    public Tactic failIf(Probe probe) {
        this.checkContextMatch(probe);
        return new Tactic(this, Native.tacticFailIf(this.nCtx(), probe.getNativeObject()));
    }

    public Tactic failIfNotDecided() {
        return new Tactic(this, Native.tacticFailIfNotDecided(this.nCtx()));
    }

    public Tactic usingParams(Tactic tactic, Params params) {
        this.checkContextMatch(tactic);
        this.checkContextMatch(params);
        return new Tactic(this, Native.tacticUsingParams(this.nCtx(), tactic.getNativeObject(), params.getNativeObject()));
    }

    public Tactic with(Tactic tactic, Params params) {
        return this.usingParams(tactic, params);
    }

    public Tactic parOr(Tactic ... tacticArray) {
        this.checkContextMatch(tacticArray);
        return new Tactic(this, Native.tacticParOr(this.nCtx(), Tactic.arrayLength(tacticArray), Tactic.arrayToNative(tacticArray)));
    }

    public Tactic parAndThen(Tactic tactic, Tactic tactic2) {
        this.checkContextMatch(tactic);
        this.checkContextMatch(tactic2);
        return new Tactic(this, Native.tacticParAndThen(this.nCtx(), tactic.getNativeObject(), tactic2.getNativeObject()));
    }

    public void interrupt() {
        Native.interrupt(this.nCtx());
    }

    public int getNumSimplifiers() {
        return Native.getNumSimplifiers(this.nCtx());
    }

    public String[] getSimplifierNames() {
        int n = this.getNumSimplifiers();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Native.getSimplifierName(this.nCtx(), i);
        }
        return stringArray;
    }

    public String getSimplifierDescription(String string) {
        return Native.simplifierGetDescr(this.nCtx(), string);
    }

    public Simplifier mkSimplifier(String string) {
        return new Simplifier(this, string);
    }

    public Simplifier andThen(Simplifier simplifier, Simplifier simplifier2, Simplifier ... simplifierArray) {
        this.checkContextMatch(simplifier);
        this.checkContextMatch(simplifier2);
        this.checkContextMatch(simplifierArray);
        long l = 0L;
        if (simplifierArray != null && simplifierArray.length > 0) {
            l = simplifierArray[simplifierArray.length - 1].getNativeObject();
            for (int i = simplifierArray.length - 2; i >= 0; --i) {
                l = Native.simplifierAndThen(this.nCtx(), simplifierArray[i].getNativeObject(), l);
            }
        }
        if (l != 0L) {
            l = Native.simplifierAndThen(this.nCtx(), simplifier2.getNativeObject(), l);
            return new Simplifier(this, Native.simplifierAndThen(this.nCtx(), simplifier.getNativeObject(), l));
        }
        return new Simplifier(this, Native.simplifierAndThen(this.nCtx(), simplifier.getNativeObject(), simplifier2.getNativeObject()));
    }

    public Simplifier then(Simplifier simplifier, Simplifier simplifier2, Simplifier ... simplifierArray) {
        return this.andThen(simplifier, simplifier2, simplifierArray);
    }

    public Simplifier usingParams(Simplifier simplifier, Params params) {
        this.checkContextMatch(simplifier);
        this.checkContextMatch(params);
        return new Simplifier(this, Native.simplifierUsingParams(this.nCtx(), simplifier.getNativeObject(), params.getNativeObject()));
    }

    public Simplifier with(Simplifier simplifier, Params params) {
        return this.usingParams(simplifier, params);
    }

    public int getNumProbes() {
        return Native.getNumProbes(this.nCtx());
    }

    public String[] getProbeNames() {
        int n = this.getNumProbes();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Native.getProbeName(this.nCtx(), i);
        }
        return stringArray;
    }

    public String getProbeDescription(String string) {
        return Native.probeGetDescr(this.nCtx(), string);
    }

    public Probe mkProbe(String string) {
        return new Probe(this, string);
    }

    public Probe constProbe(double d) {
        return new Probe(this, Native.probeConst(this.nCtx(), d));
    }

    public Probe lt(Probe probe, Probe probe2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(probe2);
        return new Probe(this, Native.probeLt(this.nCtx(), probe.getNativeObject(), probe2.getNativeObject()));
    }

    public Probe gt(Probe probe, Probe probe2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(probe2);
        return new Probe(this, Native.probeGt(this.nCtx(), probe.getNativeObject(), probe2.getNativeObject()));
    }

    public Probe le(Probe probe, Probe probe2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(probe2);
        return new Probe(this, Native.probeLe(this.nCtx(), probe.getNativeObject(), probe2.getNativeObject()));
    }

    public Probe ge(Probe probe, Probe probe2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(probe2);
        return new Probe(this, Native.probeGe(this.nCtx(), probe.getNativeObject(), probe2.getNativeObject()));
    }

    public Probe eq(Probe probe, Probe probe2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(probe2);
        return new Probe(this, Native.probeEq(this.nCtx(), probe.getNativeObject(), probe2.getNativeObject()));
    }

    public Probe and(Probe probe, Probe probe2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(probe2);
        return new Probe(this, Native.probeAnd(this.nCtx(), probe.getNativeObject(), probe2.getNativeObject()));
    }

    public Probe or(Probe probe, Probe probe2) {
        this.checkContextMatch(probe);
        this.checkContextMatch(probe2);
        return new Probe(this, Native.probeOr(this.nCtx(), probe.getNativeObject(), probe2.getNativeObject()));
    }

    public Probe not(Probe probe) {
        this.checkContextMatch(probe);
        return new Probe(this, Native.probeNot(this.nCtx(), probe.getNativeObject()));
    }

    public Solver mkSolver() {
        return this.mkSolver((Symbol)null);
    }

    public Solver mkSolver(Symbol symbol) {
        if (symbol == null) {
            return new Solver(this, Native.mkSolver(this.nCtx()));
        }
        return new Solver(this, Native.mkSolverForLogic(this.nCtx(), symbol.getNativeObject()));
    }

    public Solver mkSolver(String string) {
        return this.mkSolver(this.mkSymbol(string));
    }

    public Solver mkSimpleSolver() {
        return new Solver(this, Native.mkSimpleSolver(this.nCtx()));
    }

    public Solver mkSolver(Tactic tactic) {
        return new Solver(this, Native.mkSolverFromTactic(this.nCtx(), tactic.getNativeObject()));
    }

    public Solver mkSolver(Solver solver, Simplifier simplifier) {
        return new Solver(this, Native.solverAddSimplifier(this.nCtx(), solver.getNativeObject(), simplifier.getNativeObject()));
    }

    public Fixedpoint mkFixedpoint() {
        return new Fixedpoint(this);
    }

    public Optimize mkOptimize() {
        return new Optimize(this);
    }

    public FPRMSort mkFPRoundingModeSort() {
        return new FPRMSort(this);
    }

    public FPRMExpr mkFPRoundNearestTiesToEven() {
        return new FPRMExpr(this, Native.mkFpaRoundNearestTiesToEven(this.nCtx()));
    }

    public FPRMNum mkFPRNE() {
        return new FPRMNum(this, Native.mkFpaRne(this.nCtx()));
    }

    public FPRMNum mkFPRoundNearestTiesToAway() {
        return new FPRMNum(this, Native.mkFpaRoundNearestTiesToAway(this.nCtx()));
    }

    public FPRMNum mkFPRNA() {
        return new FPRMNum(this, Native.mkFpaRna(this.nCtx()));
    }

    public FPRMNum mkFPRoundTowardPositive() {
        return new FPRMNum(this, Native.mkFpaRoundTowardPositive(this.nCtx()));
    }

    public FPRMNum mkFPRTP() {
        return new FPRMNum(this, Native.mkFpaRtp(this.nCtx()));
    }

    public FPRMNum mkFPRoundTowardNegative() {
        return new FPRMNum(this, Native.mkFpaRoundTowardNegative(this.nCtx()));
    }

    public FPRMNum mkFPRTN() {
        return new FPRMNum(this, Native.mkFpaRtn(this.nCtx()));
    }

    public FPRMNum mkFPRoundTowardZero() {
        return new FPRMNum(this, Native.mkFpaRoundTowardZero(this.nCtx()));
    }

    public FPRMNum mkFPRTZ() {
        return new FPRMNum(this, Native.mkFpaRtz(this.nCtx()));
    }

    public FPSort mkFPSort(int n, int n2) {
        return new FPSort(this, n, n2);
    }

    public FPSort mkFPSortHalf() {
        return new FPSort(this, Native.mkFpaSortHalf(this.nCtx()));
    }

    public FPSort mkFPSort16() {
        return new FPSort(this, Native.mkFpaSort16(this.nCtx()));
    }

    public FPSort mkFPSortSingle() {
        return new FPSort(this, Native.mkFpaSortSingle(this.nCtx()));
    }

    public FPSort mkFPSort32() {
        return new FPSort(this, Native.mkFpaSort32(this.nCtx()));
    }

    public FPSort mkFPSortDouble() {
        return new FPSort(this, Native.mkFpaSortDouble(this.nCtx()));
    }

    public FPSort mkFPSort64() {
        return new FPSort(this, Native.mkFpaSort64(this.nCtx()));
    }

    public FPSort mkFPSortQuadruple() {
        return new FPSort(this, Native.mkFpaSortQuadruple(this.nCtx()));
    }

    public FPSort mkFPSort128() {
        return new FPSort(this, Native.mkFpaSort128(this.nCtx()));
    }

    public FPNum mkFPNaN(FPSort fPSort) {
        return new FPNum(this, Native.mkFpaNan(this.nCtx(), fPSort.getNativeObject()));
    }

    public FPNum mkFPInf(FPSort fPSort, boolean bl) {
        return new FPNum(this, Native.mkFpaInf(this.nCtx(), fPSort.getNativeObject(), bl));
    }

    public FPNum mkFPZero(FPSort fPSort, boolean bl) {
        return new FPNum(this, Native.mkFpaZero(this.nCtx(), fPSort.getNativeObject(), bl));
    }

    public FPNum mkFPNumeral(float f, FPSort fPSort) {
        return new FPNum(this, Native.mkFpaNumeralFloat(this.nCtx(), f, fPSort.getNativeObject()));
    }

    public FPNum mkFPNumeral(double d, FPSort fPSort) {
        return new FPNum(this, Native.mkFpaNumeralDouble(this.nCtx(), d, fPSort.getNativeObject()));
    }

    public FPNum mkFPNumeral(int n, FPSort fPSort) {
        return new FPNum(this, Native.mkFpaNumeralInt(this.nCtx(), n, fPSort.getNativeObject()));
    }

    public FPNum mkFPNumeral(boolean bl, int n, int n2, FPSort fPSort) {
        return new FPNum(this, Native.mkFpaNumeralIntUint(this.nCtx(), bl, n, n2, fPSort.getNativeObject()));
    }

    public FPNum mkFPNumeral(boolean bl, long l, long l2, FPSort fPSort) {
        return new FPNum(this, Native.mkFpaNumeralInt64Uint64(this.nCtx(), bl, l, l2, fPSort.getNativeObject()));
    }

    public FPNum mkFP(float f, FPSort fPSort) {
        return this.mkFPNumeral(f, fPSort);
    }

    public FPNum mkFP(double d, FPSort fPSort) {
        return this.mkFPNumeral(d, fPSort);
    }

    public FPNum mkFP(int n, FPSort fPSort) {
        return this.mkFPNumeral(n, fPSort);
    }

    public FPNum mkFP(boolean bl, int n, int n2, FPSort fPSort) {
        return this.mkFPNumeral(bl, n, n2, fPSort);
    }

    public FPNum mkFP(boolean bl, long l, long l2, FPSort fPSort) {
        return this.mkFPNumeral(bl, l, l2, fPSort);
    }

    public FPExpr mkFPAbs(Expr<FPSort> expr) {
        return new FPExpr(this, Native.mkFpaAbs(this.nCtx(), expr.getNativeObject()));
    }

    public FPExpr mkFPNeg(Expr<FPSort> expr) {
        return new FPExpr(this, Native.mkFpaNeg(this.nCtx(), expr.getNativeObject()));
    }

    public FPExpr mkFPAdd(Expr<FPRMSort> expr, Expr<FPSort> expr2, Expr<FPSort> expr3) {
        return new FPExpr(this, Native.mkFpaAdd(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), expr3.getNativeObject()));
    }

    public FPExpr mkFPSub(Expr<FPRMSort> expr, Expr<FPSort> expr2, Expr<FPSort> expr3) {
        return new FPExpr(this, Native.mkFpaSub(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), expr3.getNativeObject()));
    }

    public FPExpr mkFPMul(Expr<FPRMSort> expr, Expr<FPSort> expr2, Expr<FPSort> expr3) {
        return new FPExpr(this, Native.mkFpaMul(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), expr3.getNativeObject()));
    }

    public FPExpr mkFPDiv(Expr<FPRMSort> expr, Expr<FPSort> expr2, Expr<FPSort> expr3) {
        return new FPExpr(this, Native.mkFpaDiv(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), expr3.getNativeObject()));
    }

    public FPExpr mkFPFMA(Expr<FPRMSort> expr, Expr<FPSort> expr2, Expr<FPSort> expr3, Expr<FPSort> expr4) {
        return new FPExpr(this, Native.mkFpaFma(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), expr3.getNativeObject(), expr4.getNativeObject()));
    }

    public FPExpr mkFPSqrt(Expr<FPRMSort> expr, Expr<FPSort> expr2) {
        return new FPExpr(this, Native.mkFpaSqrt(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public FPExpr mkFPRem(Expr<FPSort> expr, Expr<FPSort> expr2) {
        return new FPExpr(this, Native.mkFpaRem(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public FPExpr mkFPRoundToIntegral(Expr<FPRMSort> expr, Expr<FPSort> expr2) {
        return new FPExpr(this, Native.mkFpaRoundToIntegral(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public FPExpr mkFPMin(Expr<FPSort> expr, Expr<FPSort> expr2) {
        return new FPExpr(this, Native.mkFpaMin(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public FPExpr mkFPMax(Expr<FPSort> expr, Expr<FPSort> expr2) {
        return new FPExpr(this, Native.mkFpaMax(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkFPLEq(Expr<FPSort> expr, Expr<FPSort> expr2) {
        return new BoolExpr(this, Native.mkFpaLeq(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkFPLt(Expr<FPSort> expr, Expr<FPSort> expr2) {
        return new BoolExpr(this, Native.mkFpaLt(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkFPGEq(Expr<FPSort> expr, Expr<FPSort> expr2) {
        return new BoolExpr(this, Native.mkFpaGeq(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkFPGt(Expr<FPSort> expr, Expr<FPSort> expr2) {
        return new BoolExpr(this, Native.mkFpaGt(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkFPEq(Expr<FPSort> expr, Expr<FPSort> expr2) {
        return new BoolExpr(this, Native.mkFpaEq(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BoolExpr mkFPIsNormal(Expr<FPSort> expr) {
        return new BoolExpr(this, Native.mkFpaIsNormal(this.nCtx(), expr.getNativeObject()));
    }

    public BoolExpr mkFPIsSubnormal(Expr<FPSort> expr) {
        return new BoolExpr(this, Native.mkFpaIsSubnormal(this.nCtx(), expr.getNativeObject()));
    }

    public BoolExpr mkFPIsZero(Expr<FPSort> expr) {
        return new BoolExpr(this, Native.mkFpaIsZero(this.nCtx(), expr.getNativeObject()));
    }

    public BoolExpr mkFPIsInfinite(Expr<FPSort> expr) {
        return new BoolExpr(this, Native.mkFpaIsInfinite(this.nCtx(), expr.getNativeObject()));
    }

    public BoolExpr mkFPIsNaN(Expr<FPSort> expr) {
        return new BoolExpr(this, Native.mkFpaIsNan(this.nCtx(), expr.getNativeObject()));
    }

    public BoolExpr mkFPIsNegative(Expr<FPSort> expr) {
        return new BoolExpr(this, Native.mkFpaIsNegative(this.nCtx(), expr.getNativeObject()));
    }

    public BoolExpr mkFPIsPositive(Expr<FPSort> expr) {
        return new BoolExpr(this, Native.mkFpaIsPositive(this.nCtx(), expr.getNativeObject()));
    }

    public FPExpr mkFP(Expr<BitVecSort> expr, Expr<BitVecSort> expr2, Expr<BitVecSort> expr3) {
        return new FPExpr(this, Native.mkFpaFp(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), expr3.getNativeObject()));
    }

    public FPExpr mkFPToFP(Expr<BitVecSort> expr, FPSort fPSort) {
        return new FPExpr(this, Native.mkFpaToFpBv(this.nCtx(), expr.getNativeObject(), fPSort.getNativeObject()));
    }

    public FPExpr mkFPToFP(Expr<FPRMSort> expr, FPExpr fPExpr, FPSort fPSort) {
        return new FPExpr(this, Native.mkFpaToFpFloat(this.nCtx(), expr.getNativeObject(), fPExpr.getNativeObject(), fPSort.getNativeObject()));
    }

    public FPExpr mkFPToFP(Expr<FPRMSort> expr, RealExpr realExpr, FPSort fPSort) {
        return new FPExpr(this, Native.mkFpaToFpReal(this.nCtx(), expr.getNativeObject(), realExpr.getNativeObject(), fPSort.getNativeObject()));
    }

    public FPExpr mkFPToFP(Expr<FPRMSort> expr, Expr<BitVecSort> expr2, FPSort fPSort, boolean bl) {
        if (bl) {
            return new FPExpr(this, Native.mkFpaToFpSigned(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), fPSort.getNativeObject()));
        }
        return new FPExpr(this, Native.mkFpaToFpUnsigned(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), fPSort.getNativeObject()));
    }

    public FPExpr mkFPToFP(FPSort fPSort, Expr<FPRMSort> expr, Expr<FPSort> expr2) {
        return new FPExpr(this, Native.mkFpaToFpFloat(this.nCtx(), fPSort.getNativeObject(), expr.getNativeObject(), expr2.getNativeObject()));
    }

    public BitVecExpr mkFPToBV(Expr<FPRMSort> expr, Expr<FPSort> expr2, int n, boolean bl) {
        if (bl) {
            return new BitVecExpr(this, Native.mkFpaToSbv(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), n));
        }
        return new BitVecExpr(this, Native.mkFpaToUbv(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), n));
    }

    public RealExpr mkFPToReal(Expr<FPSort> expr) {
        return new RealExpr(this, Native.mkFpaToReal(this.nCtx(), expr.getNativeObject()));
    }

    public BitVecExpr mkFPToIEEEBV(Expr<FPSort> expr) {
        return new BitVecExpr(this, Native.mkFpaToIeeeBv(this.nCtx(), expr.getNativeObject()));
    }

    public BitVecExpr mkFPToFP(Expr<FPRMSort> expr, Expr<IntSort> expr2, Expr<RealSort> expr3, FPSort fPSort) {
        return new BitVecExpr(this, Native.mkFpaToFpIntReal(this.nCtx(), expr.getNativeObject(), expr2.getNativeObject(), expr3.getNativeObject(), fPSort.getNativeObject()));
    }

    public final <R extends Sort> FuncDecl<BoolSort> mkLinearOrder(R r, int n) {
        return (FuncDecl)FuncDecl.create(this, Native.mkLinearOrder(this.nCtx(), r.getNativeObject(), n));
    }

    public final <R extends Sort> FuncDecl<BoolSort> mkPartialOrder(R r, int n) {
        return (FuncDecl)FuncDecl.create(this, Native.mkPartialOrder(this.nCtx(), r.getNativeObject(), n));
    }

    public AST wrapAST(long l) {
        return AST.create(this, l);
    }

    public long unwrapAST(AST aST) {
        return aST.getNativeObject();
    }

    public String SimplifyHelp() {
        return Native.simplifyGetHelp(this.nCtx());
    }

    public ParamDescrs getSimplifyParameterDescriptions() {
        return new ParamDescrs(this, Native.simplifyGetParamDescrs(this.nCtx()));
    }

    public void updateParamValue(String string, String string2) {
        Native.updateParamValue(this.nCtx(), string, string2);
    }

    public long nCtx() {
        if (this.m_ctx == 0L) {
            throw new Z3Exception("Context closed");
        }
        return this.m_ctx;
    }

    void checkContextMatch(Z3Object z3Object) {
        if (this != z3Object.getContext()) {
            throw new Z3Exception("Context mismatch");
        }
    }

    void checkContextMatch(Z3Object z3Object, Z3Object z3Object2) {
        this.checkContextMatch(z3Object);
        this.checkContextMatch(z3Object2);
    }

    void checkContextMatch(Z3Object z3Object, Z3Object z3Object2, Z3Object z3Object3) {
        this.checkContextMatch(z3Object);
        this.checkContextMatch(z3Object2);
        this.checkContextMatch(z3Object3);
    }

    void checkContextMatch(Z3Object[] z3ObjectArray) {
        if (z3ObjectArray != null) {
            for (Z3Object z3Object : z3ObjectArray) {
                this.checkContextMatch(z3Object);
            }
        }
    }

    public IDecRefQueue<Constructor<?>> getConstructorDRQ() {
        return this.m_Constructor_DRQ;
    }

    public IDecRefQueue<ConstructorList<?>> getConstructorListDRQ() {
        return this.m_ConstructorList_DRQ;
    }

    public IDecRefQueue<AST> getASTDRQ() {
        return this.m_AST_DRQ;
    }

    public IDecRefQueue<ASTMap> getASTMapDRQ() {
        return this.m_ASTMap_DRQ;
    }

    public IDecRefQueue<ASTVector> getASTVectorDRQ() {
        return this.m_ASTVector_DRQ;
    }

    public IDecRefQueue<ApplyResult> getApplyResultDRQ() {
        return this.m_ApplyResult_DRQ;
    }

    public IDecRefQueue<FuncInterp.Entry<?>> getFuncEntryDRQ() {
        return this.m_FuncEntry_DRQ;
    }

    public IDecRefQueue<FuncInterp<?>> getFuncInterpDRQ() {
        return this.m_FuncInterp_DRQ;
    }

    public IDecRefQueue<Goal> getGoalDRQ() {
        return this.m_Goal_DRQ;
    }

    public IDecRefQueue<Model> getModelDRQ() {
        return this.m_Model_DRQ;
    }

    public IDecRefQueue<Params> getParamsDRQ() {
        return this.m_Params_DRQ;
    }

    public IDecRefQueue<ParamDescrs> getParamDescrsDRQ() {
        return this.m_ParamDescrs_DRQ;
    }

    public IDecRefQueue<Probe> getProbeDRQ() {
        return this.m_Probe_DRQ;
    }

    public IDecRefQueue<Solver> getSolverDRQ() {
        return this.m_Solver_DRQ;
    }

    public IDecRefQueue<Statistics> getStatisticsDRQ() {
        return this.m_Statistics_DRQ;
    }

    public IDecRefQueue<Tactic> getTacticDRQ() {
        return this.m_Tactic_DRQ;
    }

    public IDecRefQueue<Simplifier> getSimplifierDRQ() {
        return this.m_Simplifier_DRQ;
    }

    public IDecRefQueue<Fixedpoint> getFixedpointDRQ() {
        return this.m_Fixedpoint_DRQ;
    }

    public IDecRefQueue<Optimize> getOptimizeDRQ() {
        return this.m_Optimize_DRQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.m_AST_DRQ.forceClear(this);
        this.m_ASTMap_DRQ.forceClear(this);
        this.m_ASTVector_DRQ.forceClear(this);
        this.m_ApplyResult_DRQ.forceClear(this);
        this.m_FuncEntry_DRQ.forceClear(this);
        this.m_FuncInterp_DRQ.forceClear(this);
        this.m_Goal_DRQ.forceClear(this);
        this.m_Model_DRQ.forceClear(this);
        this.m_Params_DRQ.forceClear(this);
        this.m_Probe_DRQ.forceClear(this);
        this.m_Solver_DRQ.forceClear(this);
        this.m_Optimize_DRQ.forceClear(this);
        this.m_Statistics_DRQ.forceClear(this);
        this.m_Tactic_DRQ.forceClear(this);
        this.m_Simplifier_DRQ.forceClear(this);
        this.m_Fixedpoint_DRQ.forceClear(this);
        this.m_boolSort = null;
        this.m_intSort = null;
        this.m_realSort = null;
        this.m_stringSort = null;
        Object object = creation_lock;
        synchronized (object) {
            Native.delContext(this.m_ctx);
        }
        this.m_ctx = 0L;
    }
}

