/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt.api;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.sosy_lab.java_smt.solvers.opensmt.api.OsmtNativeJNI;
import org.sosy_lab.java_smt.solvers.opensmt.api.SymRef;

public class VectorSymRef
extends AbstractList<SymRef>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorSymRef(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorSymRef vectorSymRef) {
        return vectorSymRef == null ? 0L : vectorSymRef.swigCPtr;
    }

    protected static long swigRelease(VectorSymRef vectorSymRef) {
        long l = 0L;
        if (vectorSymRef != null) {
            if (!vectorSymRef.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = vectorSymRef.swigCPtr;
            vectorSymRef.swigCMemOwn = false;
            vectorSymRef.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmtNativeJNI.delete_VectorSymRef(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorSymRef(SymRef[] symRefArray) {
        this();
        this.reserve(symRefArray.length);
        for (SymRef symRef : symRefArray) {
            this.add(symRef);
        }
    }

    public VectorSymRef(Iterable<SymRef> iterable) {
        this();
        for (SymRef symRef : iterable) {
            this.add(symRef);
        }
    }

    @Override
    public SymRef get(int n) {
        return this.doGet(n);
    }

    @Override
    public SymRef set(int n, SymRef symRef) {
        return this.doSet(n, symRef);
    }

    @Override
    public boolean add(SymRef symRef) {
        ++this.modCount;
        this.doAdd(symRef);
        return true;
    }

    @Override
    public void add(int n, SymRef symRef) {
        ++this.modCount;
        this.doAdd(n, symRef);
    }

    @Override
    public SymRef remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public VectorSymRef() {
        this(OsmtNativeJNI.new_VectorSymRef__SWIG_0(), true);
    }

    public VectorSymRef(VectorSymRef vectorSymRef) {
        this(OsmtNativeJNI.new_VectorSymRef__SWIG_1(VectorSymRef.getCPtr(vectorSymRef), vectorSymRef), true);
    }

    public long capacity() {
        return OsmtNativeJNI.VectorSymRef_capacity(this.swigCPtr, this);
    }

    public void reserve(long l) {
        OsmtNativeJNI.VectorSymRef_reserve(this.swigCPtr, this, l);
    }

    @Override
    public boolean isEmpty() {
        return OsmtNativeJNI.VectorSymRef_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        OsmtNativeJNI.VectorSymRef_clear(this.swigCPtr, this);
    }

    public VectorSymRef(int n, SymRef symRef) {
        this(OsmtNativeJNI.new_VectorSymRef__SWIG_2(n, SymRef.getCPtr(symRef), symRef), true);
    }

    private int doSize() {
        return OsmtNativeJNI.VectorSymRef_doSize(this.swigCPtr, this);
    }

    private void doAdd(SymRef symRef) {
        OsmtNativeJNI.VectorSymRef_doAdd__SWIG_0(this.swigCPtr, this, SymRef.getCPtr(symRef), symRef);
    }

    private void doAdd(int n, SymRef symRef) {
        OsmtNativeJNI.VectorSymRef_doAdd__SWIG_1(this.swigCPtr, this, n, SymRef.getCPtr(symRef), symRef);
    }

    private SymRef doRemove(int n) {
        return new SymRef(OsmtNativeJNI.VectorSymRef_doRemove(this.swigCPtr, this, n), true);
    }

    private SymRef doGet(int n) {
        return new SymRef(OsmtNativeJNI.VectorSymRef_doGet(this.swigCPtr, this, n), false);
    }

    private SymRef doSet(int n, SymRef symRef) {
        return new SymRef(OsmtNativeJNI.VectorSymRef_doSet(this.swigCPtr, this, n, SymRef.getCPtr(symRef), symRef), true);
    }

    private void doRemoveRange(int n, int n2) {
        OsmtNativeJNI.VectorSymRef_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

