/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt.api;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.sosy_lab.java_smt.solvers.opensmt.api.OsmtNativeJNI;
import org.sosy_lab.java_smt.solvers.opensmt.api.PTRef;

public class VectorPTRef
extends AbstractList<PTRef>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorPTRef(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorPTRef vectorPTRef) {
        return vectorPTRef == null ? 0L : vectorPTRef.swigCPtr;
    }

    protected static long swigRelease(VectorPTRef vectorPTRef) {
        long l = 0L;
        if (vectorPTRef != null) {
            if (!vectorPTRef.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = vectorPTRef.swigCPtr;
            vectorPTRef.swigCMemOwn = false;
            vectorPTRef.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmtNativeJNI.delete_VectorPTRef(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorPTRef(PTRef[] pTRefArray) {
        this();
        this.reserve(pTRefArray.length);
        for (PTRef pTRef : pTRefArray) {
            this.add(pTRef);
        }
    }

    public VectorPTRef(Iterable<PTRef> iterable) {
        this();
        for (PTRef pTRef : iterable) {
            this.add(pTRef);
        }
    }

    @Override
    public PTRef get(int n) {
        return this.doGet(n);
    }

    @Override
    public PTRef set(int n, PTRef pTRef) {
        return this.doSet(n, pTRef);
    }

    @Override
    public boolean add(PTRef pTRef) {
        ++this.modCount;
        this.doAdd(pTRef);
        return true;
    }

    @Override
    public void add(int n, PTRef pTRef) {
        ++this.modCount;
        this.doAdd(n, pTRef);
    }

    @Override
    public PTRef remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public VectorPTRef() {
        this(OsmtNativeJNI.new_VectorPTRef__SWIG_0(), true);
    }

    public VectorPTRef(VectorPTRef vectorPTRef) {
        this(OsmtNativeJNI.new_VectorPTRef__SWIG_1(VectorPTRef.getCPtr(vectorPTRef), vectorPTRef), true);
    }

    public long capacity() {
        return OsmtNativeJNI.VectorPTRef_capacity(this.swigCPtr, this);
    }

    public void reserve(long l) {
        OsmtNativeJNI.VectorPTRef_reserve(this.swigCPtr, this, l);
    }

    @Override
    public boolean isEmpty() {
        return OsmtNativeJNI.VectorPTRef_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        OsmtNativeJNI.VectorPTRef_clear(this.swigCPtr, this);
    }

    public VectorPTRef(int n, PTRef pTRef) {
        this(OsmtNativeJNI.new_VectorPTRef__SWIG_2(n, PTRef.getCPtr(pTRef), pTRef), true);
    }

    private int doSize() {
        return OsmtNativeJNI.VectorPTRef_doSize(this.swigCPtr, this);
    }

    private void doAdd(PTRef pTRef) {
        OsmtNativeJNI.VectorPTRef_doAdd__SWIG_0(this.swigCPtr, this, PTRef.getCPtr(pTRef), pTRef);
    }

    private void doAdd(int n, PTRef pTRef) {
        OsmtNativeJNI.VectorPTRef_doAdd__SWIG_1(this.swigCPtr, this, n, PTRef.getCPtr(pTRef), pTRef);
    }

    private PTRef doRemove(int n) {
        return new PTRef(OsmtNativeJNI.VectorPTRef_doRemove(this.swigCPtr, this, n), true);
    }

    private PTRef doGet(int n) {
        return new PTRef(OsmtNativeJNI.VectorPTRef_doGet(this.swigCPtr, this, n), false);
    }

    private PTRef doSet(int n, PTRef pTRef) {
        return new PTRef(OsmtNativeJNI.VectorPTRef_doSet(this.swigCPtr, this, n, PTRef.getCPtr(pTRef), pTRef), true);
    }

    private void doRemoveRange(int n, int n2) {
        OsmtNativeJNI.VectorPTRef_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

