/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt.api;

import org.sosy_lab.java_smt.solvers.opensmt.api.OsmtNativeJNI;
import org.sosy_lab.java_smt.solvers.opensmt.api.SRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.VectorSRef;

public class Symbol {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Symbol(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Symbol symbol) {
        return symbol == null ? 0L : symbol.swigCPtr;
    }

    protected static long swigRelease(Symbol symbol) {
        long l = 0L;
        if (symbol != null) {
            if (!symbol.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = symbol.swigCPtr;
            symbol.swigCMemOwn = false;
            symbol.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmtNativeJNI.delete_Symbol(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public int size() {
        return OsmtNativeJNI.Symbol_size(this.swigCPtr, this);
    }

    public SRef rsort() {
        return new SRef(OsmtNativeJNI.Symbol_rsort(this.swigCPtr, this), true);
    }

    public boolean isInterpreted() {
        return OsmtNativeJNI.Symbol_isInterpreted(this.swigCPtr, this);
    }

    public VectorSRef getArgTypes() {
        return new VectorSRef(OsmtNativeJNI.Symbol_getArgTypes(this.swigCPtr, this), true);
    }
}

