/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt.api;

import org.sosy_lab.java_smt.solvers.opensmt.api.OsmtNativeJNI;
import org.sosy_lab.java_smt.solvers.opensmt.api.PTRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SymRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.TemplateFunction;

public class Model {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Model(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Model model) {
        return model == null ? 0L : model.swigCPtr;
    }

    protected static long swigRelease(Model model) {
        long l = 0L;
        if (model != null) {
            if (!model.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = model.swigCPtr;
            model.swigCMemOwn = false;
            model.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmtNativeJNI.delete_Model(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public PTRef evaluate(PTRef pTRef) {
        return new PTRef(OsmtNativeJNI.Model_evaluate(this.swigCPtr, this, PTRef.getCPtr(pTRef), pTRef), true);
    }

    public TemplateFunction getDefinition(SymRef symRef) {
        return new TemplateFunction(OsmtNativeJNI.Model_getDefinition(this.swigCPtr, this, SymRef.getCPtr(symRef), symRef), true);
    }
}

