/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt.api;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.sosy_lab.java_smt.solvers.opensmt.api.OsmtNativeJNI;
import org.sosy_lab.java_smt.solvers.opensmt.api.SRef;

public class VectorSRef
extends AbstractList<SRef>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorSRef(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorSRef vectorSRef) {
        return vectorSRef == null ? 0L : vectorSRef.swigCPtr;
    }

    protected static long swigRelease(VectorSRef vectorSRef) {
        long l = 0L;
        if (vectorSRef != null) {
            if (!vectorSRef.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = vectorSRef.swigCPtr;
            vectorSRef.swigCMemOwn = false;
            vectorSRef.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmtNativeJNI.delete_VectorSRef(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorSRef(SRef[] sRefArray) {
        this();
        this.reserve(sRefArray.length);
        for (SRef sRef : sRefArray) {
            this.add(sRef);
        }
    }

    public VectorSRef(Iterable<SRef> iterable) {
        this();
        for (SRef sRef : iterable) {
            this.add(sRef);
        }
    }

    @Override
    public SRef get(int n) {
        return this.doGet(n);
    }

    @Override
    public SRef set(int n, SRef sRef) {
        return this.doSet(n, sRef);
    }

    @Override
    public boolean add(SRef sRef) {
        ++this.modCount;
        this.doAdd(sRef);
        return true;
    }

    @Override
    public void add(int n, SRef sRef) {
        ++this.modCount;
        this.doAdd(n, sRef);
    }

    @Override
    public SRef remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public VectorSRef() {
        this(OsmtNativeJNI.new_VectorSRef__SWIG_0(), true);
    }

    public VectorSRef(VectorSRef vectorSRef) {
        this(OsmtNativeJNI.new_VectorSRef__SWIG_1(VectorSRef.getCPtr(vectorSRef), vectorSRef), true);
    }

    public long capacity() {
        return OsmtNativeJNI.VectorSRef_capacity(this.swigCPtr, this);
    }

    public void reserve(long l) {
        OsmtNativeJNI.VectorSRef_reserve(this.swigCPtr, this, l);
    }

    @Override
    public boolean isEmpty() {
        return OsmtNativeJNI.VectorSRef_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        OsmtNativeJNI.VectorSRef_clear(this.swigCPtr, this);
    }

    public VectorSRef(int n, SRef sRef) {
        this(OsmtNativeJNI.new_VectorSRef__SWIG_2(n, SRef.getCPtr(sRef), sRef), true);
    }

    private int doSize() {
        return OsmtNativeJNI.VectorSRef_doSize(this.swigCPtr, this);
    }

    private void doAdd(SRef sRef) {
        OsmtNativeJNI.VectorSRef_doAdd__SWIG_0(this.swigCPtr, this, SRef.getCPtr(sRef), sRef);
    }

    private void doAdd(int n, SRef sRef) {
        OsmtNativeJNI.VectorSRef_doAdd__SWIG_1(this.swigCPtr, this, n, SRef.getCPtr(sRef), sRef);
    }

    private SRef doRemove(int n) {
        return new SRef(OsmtNativeJNI.VectorSRef_doRemove(this.swigCPtr, this, n), true);
    }

    private SRef doGet(int n) {
        return new SRef(OsmtNativeJNI.VectorSRef_doGet(this.swigCPtr, this, n), false);
    }

    private SRef doSet(int n, SRef sRef) {
        return new SRef(OsmtNativeJNI.VectorSRef_doSet(this.swigCPtr, this, n, SRef.getCPtr(sRef), sRef), true);
    }

    private void doRemoveRange(int n, int n2) {
        OsmtNativeJNI.VectorSRef_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

