/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt.api;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.sosy_lab.java_smt.solvers.opensmt.api.OsmtNativeJNI;

public class VectorInt
extends AbstractList<Integer>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorInt(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorInt vectorInt) {
        return vectorInt == null ? 0L : vectorInt.swigCPtr;
    }

    protected static long swigRelease(VectorInt vectorInt) {
        long l = 0L;
        if (vectorInt != null) {
            if (!vectorInt.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = vectorInt.swigCPtr;
            vectorInt.swigCMemOwn = false;
            vectorInt.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmtNativeJNI.delete_VectorInt(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorInt(int[] nArray) {
        this();
        this.reserve(nArray.length);
        for (int n : nArray) {
            this.add(n);
        }
    }

    public VectorInt(Iterable<Integer> iterable) {
        this();
        for (int n : iterable) {
            this.add(n);
        }
    }

    @Override
    public Integer get(int n) {
        return this.doGet(n);
    }

    @Override
    public Integer set(int n, Integer n2) {
        return this.doSet(n, n2);
    }

    @Override
    public boolean add(Integer n) {
        ++this.modCount;
        this.doAdd(n);
        return true;
    }

    @Override
    public void add(int n, Integer n2) {
        ++this.modCount;
        this.doAdd(n, n2);
    }

    @Override
    public Integer remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public VectorInt() {
        this(OsmtNativeJNI.new_VectorInt__SWIG_0(), true);
    }

    public VectorInt(VectorInt vectorInt) {
        this(OsmtNativeJNI.new_VectorInt__SWIG_1(VectorInt.getCPtr(vectorInt), vectorInt), true);
    }

    public long capacity() {
        return OsmtNativeJNI.VectorInt_capacity(this.swigCPtr, this);
    }

    public void reserve(long l) {
        OsmtNativeJNI.VectorInt_reserve(this.swigCPtr, this, l);
    }

    @Override
    public boolean isEmpty() {
        return OsmtNativeJNI.VectorInt_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        OsmtNativeJNI.VectorInt_clear(this.swigCPtr, this);
    }

    public VectorInt(int n, int n2) {
        this(OsmtNativeJNI.new_VectorInt__SWIG_2(n, n2), true);
    }

    private int doSize() {
        return OsmtNativeJNI.VectorInt_doSize(this.swigCPtr, this);
    }

    private void doAdd(int n) {
        OsmtNativeJNI.VectorInt_doAdd__SWIG_0(this.swigCPtr, this, n);
    }

    private void doAdd(int n, int n2) {
        OsmtNativeJNI.VectorInt_doAdd__SWIG_1(this.swigCPtr, this, n, n2);
    }

    private int doRemove(int n) {
        return OsmtNativeJNI.VectorInt_doRemove(this.swigCPtr, this, n);
    }

    private int doGet(int n) {
        return OsmtNativeJNI.VectorInt_doGet(this.swigCPtr, this, n);
    }

    private int doSet(int n, int n2) {
        return OsmtNativeJNI.VectorInt_doSet(this.swigCPtr, this, n, n2);
    }

    private void doRemoveRange(int n, int n2) {
        OsmtNativeJNI.VectorInt_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

