/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt.api;

import org.sosy_lab.java_smt.solvers.opensmt.api.InterpolationContext;
import org.sosy_lab.java_smt.solvers.opensmt.api.Logic;
import org.sosy_lab.java_smt.solvers.opensmt.api.Model;
import org.sosy_lab.java_smt.solvers.opensmt.api.OsmtNativeJNI;
import org.sosy_lab.java_smt.solvers.opensmt.api.PTRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SMTConfig;
import org.sosy_lab.java_smt.solvers.opensmt.api.VectorPTRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.sstat;

public class MainSolver {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected MainSolver(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(MainSolver mainSolver) {
        return mainSolver == null ? 0L : mainSolver.swigCPtr;
    }

    protected static long swigRelease(MainSolver mainSolver) {
        long l = 0L;
        if (mainSolver != null) {
            if (!mainSolver.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = mainSolver.swigCPtr;
            mainSolver.swigCMemOwn = false;
            mainSolver.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmtNativeJNI.delete_MainSolver(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public MainSolver(Logic logic, SMTConfig sMTConfig, String string) {
        this(OsmtNativeJNI.new_MainSolver__SWIG_0(Logic.getCPtr(logic), logic, SMTConfig.getCPtr(sMTConfig), sMTConfig, string), true);
    }

    public MainSolver(MainSolver mainSolver) {
        this(OsmtNativeJNI.new_MainSolver__SWIG_1(MainSolver.swigRelease(mainSolver), mainSolver), true);
    }

    public SMTConfig getConfig() {
        return new SMTConfig(OsmtNativeJNI.MainSolver_getConfig(this.swigCPtr, this), false);
    }

    public Logic getLogic() {
        return new Logic(OsmtNativeJNI.MainSolver_getLogic(this.swigCPtr, this), false);
    }

    public void push() {
        OsmtNativeJNI.MainSolver_push(this.swigCPtr, this);
    }

    public boolean pop() {
        return OsmtNativeJNI.MainSolver_pop(this.swigCPtr, this);
    }

    public void insertFormula(PTRef pTRef) {
        OsmtNativeJNI.MainSolver_insertFormula(this.swigCPtr, this, PTRef.getCPtr(pTRef), pTRef);
    }

    public sstat check() {
        return new sstat(OsmtNativeJNI.MainSolver_check(this.swigCPtr, this), true);
    }

    public sstat solve() {
        return new sstat(OsmtNativeJNI.MainSolver_solve(this.swigCPtr, this), true);
    }

    public sstat getStatus() {
        return new sstat(OsmtNativeJNI.MainSolver_getStatus(this.swigCPtr, this), true);
    }

    public Model getModel() {
        long l = OsmtNativeJNI.MainSolver_getModel(this.swigCPtr, this);
        return l == 0L ? null : new Model(l, true);
    }

    public void printResolutionProofSMT2() {
        OsmtNativeJNI.MainSolver_printResolutionProofSMT2(this.swigCPtr, this);
    }

    public InterpolationContext getInterpolationContext() {
        long l = OsmtNativeJNI.MainSolver_getInterpolationContext(this.swigCPtr, this);
        return l == 0L ? null : new InterpolationContext(l, true);
    }

    public void stop() {
        OsmtNativeJNI.MainSolver_stop(this.swigCPtr, this);
    }

    public VectorPTRef getUnsatCore() {
        return new VectorPTRef(OsmtNativeJNI.MainSolver_getUnsatCore(this.swigCPtr, this), true);
    }
}

