/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt.api;

import org.sosy_lab.java_smt.solvers.opensmt.api.ArithLogic;
import org.sosy_lab.java_smt.solvers.opensmt.api.Logic;
import org.sosy_lab.java_smt.solvers.opensmt.api.Logic_t;
import org.sosy_lab.java_smt.solvers.opensmt.api.OsmtNativeJNI;

public class LogicFactory {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected LogicFactory(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(LogicFactory logicFactory) {
        return logicFactory == null ? 0L : logicFactory.swigCPtr;
    }

    protected static long swigRelease(LogicFactory logicFactory) {
        long l = 0L;
        if (logicFactory != null) {
            if (!logicFactory.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = logicFactory.swigCPtr;
            logicFactory.swigCMemOwn = false;
            logicFactory.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmtNativeJNI.delete_LogicFactory(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static Logic getInstance(Logic_t logic_t) {
        long l = OsmtNativeJNI.LogicFactory_getInstance(logic_t.swigValue());
        return l == 0L ? null : new Logic(l, true);
    }

    public static ArithLogic getLAInstance(Logic_t logic_t) {
        long l = OsmtNativeJNI.LogicFactory_getLAInstance(logic_t.swigValue());
        return l == 0L ? null : new ArithLogic(l, true);
    }

    public static ArithLogic getLRAInstance() {
        long l = OsmtNativeJNI.LogicFactory_getLRAInstance();
        return l == 0L ? null : new ArithLogic(l, true);
    }

    public static ArithLogic getLIAInstance() {
        long l = OsmtNativeJNI.LogicFactory_getLIAInstance();
        return l == 0L ? null : new ArithLogic(l, true);
    }

    public static String getVersion() {
        return OsmtNativeJNI.LogicFactory_getVersion();
    }
}

