/*
 * Decompiled with CFR 0.152.
 */
package io.github.cvc5;

import io.github.cvc5.CVC5ApiException;
import java.util.HashMap;
import java.util.Map;

public enum SortKind {
    INTERNAL_SORT_KIND(-2),
    UNDEFINED_SORT_KIND(-1),
    NULL_SORT(0),
    ABSTRACT_SORT(1),
    ARRAY_SORT(2),
    BAG_SORT(3),
    BOOLEAN_SORT(4),
    BITVECTOR_SORT(5),
    DATATYPE_SORT(6),
    FINITE_FIELD_SORT(7),
    FLOATINGPOINT_SORT(8),
    FUNCTION_SORT(9),
    INTEGER_SORT(10),
    REAL_SORT(11),
    REGLAN_SORT(12),
    ROUNDINGMODE_SORT(13),
    SEQUENCE_SORT(14),
    SET_SORT(15),
    STRING_SORT(16),
    TUPLE_SORT(17),
    UNINTERPRETED_SORT(18),
    LAST_SORT_KIND(19);

    private int value;
    private static int minValue;
    private static int maxValue;
    private static Map<Integer, SortKind> enumMap;

    private SortKind(int n2) {
        this.value = n2;
    }

    public static SortKind fromInt(int n) throws CVC5ApiException {
        if (n < minValue || n > maxValue) {
            throw new CVC5ApiException("SortKind value " + n + " is outside the valid range [" + minValue + "," + maxValue + "]");
        }
        return enumMap.get(n);
    }

    public int getValue() {
        return this.value;
    }

    static {
        minValue = 0;
        maxValue = 0;
        enumMap = new HashMap<Integer, SortKind>();
        boolean bl = true;
        for (SortKind sortKind : SortKind.values()) {
            int n = sortKind.getValue();
            if (bl) {
                minValue = n;
                maxValue = n;
                bl = false;
            }
            minValue = Math.min(minValue, n);
            maxValue = Math.max(maxValue, n);
            enumMap.put(n, sortKind);
        }
    }
}

