/*
 * Decompiled with CFR 0.152.
 */
package io.github.cvc5;

import io.github.cvc5.CVC5ApiException;
import io.github.cvc5.DatatypeConstructorDecl;
import io.github.cvc5.DatatypeDecl;
import io.github.cvc5.Grammar;
import io.github.cvc5.IOracle;
import io.github.cvc5.IPointer;
import io.github.cvc5.Kind;
import io.github.cvc5.Op;
import io.github.cvc5.OptionInfo;
import io.github.cvc5.Pair;
import io.github.cvc5.Result;
import io.github.cvc5.RoundingMode;
import io.github.cvc5.Sort;
import io.github.cvc5.SortKind;
import io.github.cvc5.Statistics;
import io.github.cvc5.SynthResult;
import io.github.cvc5.Term;
import io.github.cvc5.Utils;
import io.github.cvc5.modes.BlockModelsMode;
import io.github.cvc5.modes.LearnedLitType;
import io.github.cvc5.modes.ProofComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Solver
implements IPointer {
    private long pointer;
    List<IOracle> oracles = new ArrayList<IOracle>();

    @Override
    public long getPointer() {
        return this.pointer;
    }

    private native long newSolver();

    public void deletePointer() {
        if (this.pointer != 0L) {
            Solver.deletePointer(this.pointer);
        }
        this.pointer = 0L;
    }

    private static native void deletePointer(long var0);

    public Solver() {
        this.pointer = this.newSolver();
    }

    public Sort getBooleanSort() {
        long l = this.getBooleanSort(this.pointer);
        return new Sort(l);
    }

    private native long getBooleanSort(long var1);

    public Sort getIntegerSort() {
        long l = this.getIntegerSort(this.pointer);
        return new Sort(l);
    }

    public native long getIntegerSort(long var1);

    public Sort getRealSort() {
        long l = this.getRealSort(this.pointer);
        return new Sort(l);
    }

    private native long getRealSort(long var1);

    public Sort getRegExpSort() {
        long l = this.getRegExpSort(this.pointer);
        return new Sort(l);
    }

    private native long getRegExpSort(long var1);

    public Sort getRoundingModeSort() throws CVC5ApiException {
        long l = this.getRoundingModeSort(this.pointer);
        return new Sort(l);
    }

    private native long getRoundingModeSort(long var1) throws CVC5ApiException;

    public Sort getStringSort() {
        long l = this.getStringSort(this.pointer);
        return new Sort(l);
    }

    private native long getStringSort(long var1);

    public Sort mkArraySort(Sort sort, Sort sort2) {
        long l = this.mkArraySort(this.pointer, sort.getPointer(), sort2.getPointer());
        return new Sort(l);
    }

    private native long mkArraySort(long var1, long var3, long var5);

    public Sort mkBitVectorSort(int n) throws CVC5ApiException {
        Utils.validateUnsigned(n, "size");
        long l = this.mkBitVectorSort(this.pointer, n);
        return new Sort(l);
    }

    private native long mkBitVectorSort(long var1, int var3);

    public Sort mkFiniteFieldSort(String string) throws CVC5ApiException {
        long l = this.mkFiniteFieldSort(this.pointer, string);
        return new Sort(l);
    }

    private native long mkFiniteFieldSort(long var1, String var3);

    public Sort mkFloatingPointSort(int n, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "exp");
        Utils.validateUnsigned(n2, "sig");
        long l = this.mkFloatingPointSort(this.pointer, n, n2);
        return new Sort(l);
    }

    private native long mkFloatingPointSort(long var1, int var3, int var4);

    public Sort mkDatatypeSort(DatatypeDecl datatypeDecl) throws CVC5ApiException {
        long l = this.mkDatatypeSort(this.pointer, datatypeDecl.getPointer());
        return new Sort(l);
    }

    private native long mkDatatypeSort(long var1, long var3) throws CVC5ApiException;

    public Sort[] mkDatatypeSorts(DatatypeDecl[] datatypeDeclArray) throws CVC5ApiException {
        long[] lArray = Utils.getPointers(datatypeDeclArray);
        long[] lArray2 = this.mkDatatypeSorts(this.pointer, lArray);
        Sort[] sortArray = Utils.getSorts(lArray2);
        return sortArray;
    }

    private native long[] mkDatatypeSorts(long var1, long[] var3) throws CVC5ApiException;

    public Sort mkFunctionSort(Sort sort, Sort sort2) {
        return this.mkFunctionSort(new Sort[]{sort}, sort2);
    }

    public Sort mkFunctionSort(Sort[] sortArray, Sort sort) {
        long l = this.mkFunctionSort(this.pointer, Utils.getPointers(sortArray), sort.getPointer());
        return new Sort(l);
    }

    private native long mkFunctionSort(long var1, long[] var3, long var4);

    public Sort mkParamSort(String string) {
        long l = this.mkParamSort(this.pointer, string);
        return new Sort(l);
    }

    private native long mkParamSort(long var1, String var3);

    public Sort mkParamSort() {
        long l = this.mkParamSort(this.pointer);
        return new Sort(l);
    }

    private native long mkParamSort(long var1);

    public Sort mkPredicateSort(Sort[] sortArray) {
        long l = this.mkPredicateSort(this.pointer, Utils.getPointers(sortArray));
        return new Sort(l);
    }

    private native long mkPredicateSort(long var1, long[] var3);

    public Sort mkRecordSort(Pair<String, Sort>[] pairArray) {
        long l = this.mkRecordSort(this.pointer, Utils.getPairs(pairArray));
        return new Sort(l);
    }

    private native long mkRecordSort(long var1, Pair<String, Long>[] var3);

    public Sort mkSetSort(Sort sort) {
        long l = this.mkSetSort(this.pointer, sort.getPointer());
        return new Sort(l);
    }

    private native long mkSetSort(long var1, long var3);

    public Sort mkBagSort(Sort sort) {
        long l = this.mkBagSort(this.pointer, sort.getPointer());
        return new Sort(l);
    }

    private native long mkBagSort(long var1, long var3);

    public Sort mkSequenceSort(Sort sort) {
        long l = this.mkSequenceSort(this.pointer, sort.getPointer());
        return new Sort(l);
    }

    private native long mkSequenceSort(long var1, long var3);

    public Sort mkAbstractSort(SortKind sortKind) {
        long l = this.mkAbstractSort(this.pointer, sortKind.getValue());
        return new Sort(l);
    }

    private native long mkAbstractSort(long var1, int var3);

    public Sort mkUninterpretedSort(String string) {
        long l = this.mkUninterpretedSort(this.pointer, string);
        return new Sort(l);
    }

    private native long mkUninterpretedSort(long var1, String var3);

    public Sort mkUninterpretedSort() {
        long l = this.mkUninterpretedSort(this.pointer);
        return new Sort(l);
    }

    private native long mkUninterpretedSort(long var1);

    public Sort mkUnresolvedDatatypeSort(String string, int n) throws CVC5ApiException {
        Utils.validateUnsigned(n, "arity");
        long l = this.mkUnresolvedDatatypeSort(this.pointer, string, n);
        return new Sort(l);
    }

    private native long mkUnresolvedDatatypeSort(long var1, String var3, int var4);

    public Sort mkUnresolvedDatatypeSort(String string) throws CVC5ApiException {
        return this.mkUnresolvedDatatypeSort(string, 0);
    }

    public Sort mkUninterpretedSortConstructorSort(int n, String string) throws CVC5ApiException {
        Utils.validateUnsigned(n, "arity");
        long l = this.mkUninterpretedSortConstructorSort(this.pointer, n, string);
        return new Sort(l);
    }

    private native long mkUninterpretedSortConstructorSort(long var1, int var3, String var4);

    public Sort mkUninterpretedSortConstructorSort(int n) throws CVC5ApiException {
        Utils.validateUnsigned(n, "arity");
        long l = this.mkUninterpretedSortConstructorSort(this.pointer, n);
        return new Sort(l);
    }

    private native long mkUninterpretedSortConstructorSort(long var1, int var3);

    public Sort mkTupleSort(Sort[] sortArray) {
        long[] lArray = Utils.getPointers(sortArray);
        long l = this.mkTupleSort(this.pointer, lArray);
        return new Sort(l);
    }

    private native long mkTupleSort(long var1, long[] var3);

    public Term mkTerm(Kind kind) {
        long l = this.mkTerm(this.pointer, kind.getValue());
        return new Term(l);
    }

    private native long mkTerm(long var1, int var3);

    public Term mkTerm(Kind kind, Term term) {
        long l = this.mkTerm(this.pointer, kind.getValue(), term.getPointer());
        return new Term(l);
    }

    private native long mkTerm(long var1, int var3, long var4);

    public Term mkTerm(Kind kind, Term term, Term term2) {
        long l = this.mkTerm(this.pointer, kind.getValue(), term.getPointer(), term2.getPointer());
        return new Term(l);
    }

    private native long mkTerm(long var1, int var3, long var4, long var6);

    public Term mkTerm(Kind kind, Term term, Term term2, Term term3) {
        long l = this.mkTerm(this.pointer, kind.getValue(), term.getPointer(), term2.getPointer(), term3.getPointer());
        return new Term(l);
    }

    private native long mkTerm(long var1, int var3, long var4, long var6, long var8);

    public Term mkTerm(Kind kind, Term[] termArray) {
        long[] lArray = Utils.getPointers(termArray);
        long l = this.mkTerm(this.pointer, kind.getValue(), lArray);
        return new Term(l);
    }

    private native long mkTerm(long var1, int var3, long[] var4);

    public Term mkTerm(Op op) {
        long l = this.mkTerm(this.pointer, op.getPointer());
        return new Term(l);
    }

    private native long mkTerm(long var1, long var3);

    public Term mkTerm(Op op, Term term) {
        long l = this.mkTerm(this.pointer, op.getPointer(), term.getPointer());
        return new Term(l);
    }

    private native long mkTerm(long var1, long var3, long var5);

    public Term mkTerm(Op op, Term term, Term term2) {
        long l = this.mkTerm(this.pointer, op.getPointer(), term.getPointer(), term2.getPointer());
        return new Term(l);
    }

    private native long mkTerm(long var1, long var3, long var5, long var7);

    public Term mkTerm(Op op, Term term, Term term2, Term term3) {
        long l = this.mkTerm(op.getPointer(), term.getPointer(), term2.getPointer(), term3.getPointer());
        return new Term(l);
    }

    private native long mkTerm(long var1, long var3, long var5, long var7, long var9);

    public Term mkTerm(Op op, Term[] termArray) {
        long[] lArray = Utils.getPointers(termArray);
        long l = this.mkTerm(this.pointer, op.getPointer(), lArray);
        return new Term(l);
    }

    private native long mkTerm(long var1, long var3, long[] var5);

    public Term mkTuple(Sort[] sortArray, Term[] termArray) {
        long[] lArray = Utils.getPointers(sortArray);
        long[] lArray2 = Utils.getPointers(termArray);
        long l = this.mkTuple(this.pointer, lArray, lArray2);
        return new Term(l);
    }

    private native long mkTuple(long var1, long[] var3, long[] var4);

    public Op mkOp(Kind kind) {
        long l = this.mkOp(this.pointer, kind.getValue());
        return new Op(l);
    }

    private native long mkOp(long var1, int var3);

    public Op mkOp(Kind kind, String string) {
        long l = this.mkOp(this.pointer, kind.getValue(), string);
        return new Op(l);
    }

    private native long mkOp(long var1, int var3, String var4);

    public Op mkOp(Kind kind, int n) throws CVC5ApiException {
        Utils.validateUnsigned(n, "arg");
        long l = this.mkOp(this.pointer, kind.getValue(), n);
        return new Op(l);
    }

    private native long mkOp(long var1, int var3, int var4);

    public Op mkOp(Kind kind, int n, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "arg1");
        Utils.validateUnsigned(n2, "arg2");
        long l = this.mkOp(this.pointer, kind.getValue(), n, n2);
        return new Op(l);
    }

    private native long mkOp(long var1, int var3, int var4, int var5);

    public Op mkOp(Kind kind, int[] nArray) throws CVC5ApiException {
        Utils.validateUnsigned(nArray, "args");
        long l = this.mkOp(this.pointer, kind.getValue(), nArray);
        return new Op(l);
    }

    private native long mkOp(long var1, int var3, int[] var4);

    public Term mkTrue() {
        long l = this.mkTrue(this.pointer);
        return new Term(l);
    }

    private native long mkTrue(long var1);

    public Term mkFalse() {
        long l = this.mkFalse(this.pointer);
        return new Term(l);
    }

    private native long mkFalse(long var1);

    public Term mkBoolean(boolean bl) {
        long l = this.mkBoolean(this.pointer, bl);
        return new Term(l);
    }

    private native long mkBoolean(long var1, boolean var3);

    public Term mkPi() {
        long l = this.mkPi(this.pointer);
        return new Term(l);
    }

    private native long mkPi(long var1);

    public Term mkInteger(String string) throws CVC5ApiException {
        long l = this.mkInteger(this.pointer, string);
        return new Term(l);
    }

    private native long mkInteger(long var1, String var3) throws CVC5ApiException;

    public Term mkInteger(long l) {
        long l2 = this.mkInteger(this.pointer, l);
        return new Term(l2);
    }

    private native long mkInteger(long var1, long var3);

    public Term mkReal(String string) throws CVC5ApiException {
        long l = this.mkReal(this.pointer, string);
        return new Term(l);
    }

    private native long mkReal(long var1, String var3) throws CVC5ApiException;

    public Term mkReal(long l) {
        long l2 = this.mkRealValue(this.pointer, l);
        return new Term(l2);
    }

    private native long mkRealValue(long var1, long var3);

    public Term mkReal(long l, long l2) {
        long l3 = this.mkReal(this.pointer, l, l2);
        return new Term(l3);
    }

    private native long mkReal(long var1, long var3, long var5);

    public Term mkRegexpNone() {
        long l = this.mkRegexpNone(this.pointer);
        return new Term(l);
    }

    private native long mkRegexpNone(long var1);

    public Term mkRegexpAll() {
        long l = this.mkRegexpAll(this.pointer);
        return new Term(l);
    }

    private native long mkRegexpAll(long var1);

    public Term mkRegexpAllchar() {
        long l = this.mkRegexpAllchar(this.pointer);
        return new Term(l);
    }

    private native long mkRegexpAllchar(long var1);

    public Term mkEmptySet(Sort sort) {
        long l = this.mkEmptySet(this.pointer, sort.getPointer());
        return new Term(l);
    }

    private native long mkEmptySet(long var1, long var3);

    public Term mkEmptyBag(Sort sort) {
        long l = this.mkEmptyBag(this.pointer, sort.getPointer());
        return new Term(l);
    }

    private native long mkEmptyBag(long var1, long var3);

    public Term mkSepEmp() {
        long l = this.mkSepEmp(this.pointer);
        return new Term(l);
    }

    private native long mkSepEmp(long var1);

    public Term mkSepNil(Sort sort) {
        long l = this.mkSepNil(this.pointer, sort.getPointer());
        return new Term(l);
    }

    private native long mkSepNil(long var1, long var3);

    public Term mkString(String string) {
        return this.mkString(string, false);
    }

    public Term mkString(String string, boolean bl) {
        long l = this.mkString(this.pointer, string, bl);
        return new Term(l);
    }

    private native long mkString(long var1, String var3, boolean var4);

    public Term mkString(int[] nArray) throws CVC5ApiException {
        Utils.validateUnsigned(nArray, "s");
        long l = this.mkString(this.pointer, nArray);
        return new Term(l);
    }

    private native long mkString(long var1, int[] var3);

    public Term mkEmptySequence(Sort sort) {
        long l = this.mkEmptySequence(this.pointer, sort.getPointer());
        return new Term(l);
    }

    private native long mkEmptySequence(long var1, long var3);

    public Term mkUniverseSet(Sort sort) {
        long l = this.mkUniverseSet(this.pointer, sort.getPointer());
        return new Term(l);
    }

    private native long mkUniverseSet(long var1, long var3);

    public Term mkBitVector(int n) throws CVC5ApiException {
        return this.mkBitVector(n, 0L);
    }

    public Term mkBitVector(int n, long l) throws CVC5ApiException {
        Utils.validateUnsigned(n, "size");
        Utils.validateUnsigned(l, "val");
        long l2 = this.mkBitVector(this.pointer, n, l);
        return new Term(l2);
    }

    private native long mkBitVector(long var1, int var3, long var4);

    public Term mkBitVector(int n, String string, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "size");
        Utils.validateUnsigned(n2, "base");
        long l = this.mkBitVector(this.pointer, n, string, n2);
        return new Term(l);
    }

    private native long mkBitVector(long var1, int var3, String var4, int var5);

    public Term mkFiniteFieldElem(String string, Sort sort) throws CVC5ApiException {
        long l = this.mkFiniteFieldElem(this.pointer, string, sort.getPointer());
        return new Term(l);
    }

    private native long mkFiniteFieldElem(long var1, String var3, long var4);

    public Term mkConstArray(Sort sort, Term term) {
        long l = this.mkConstArray(this.pointer, sort.getPointer(), term.getPointer());
        return new Term(l);
    }

    private native long mkConstArray(long var1, long var3, long var5);

    public Term mkFloatingPointPosInf(int n, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "exp");
        Utils.validateUnsigned(n2, "sig");
        long l = this.mkFloatingPointPosInf(this.pointer, n, n2);
        return new Term(l);
    }

    private native long mkFloatingPointPosInf(long var1, int var3, int var4);

    public Term mkFloatingPointNegInf(int n, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "exp");
        Utils.validateUnsigned(n2, "sig");
        long l = this.mkFloatingPointNegInf(this.pointer, n, n2);
        return new Term(l);
    }

    private native long mkFloatingPointNegInf(long var1, int var3, int var4);

    public Term mkFloatingPointNaN(int n, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "exp");
        Utils.validateUnsigned(n2, "sig");
        long l = this.mkFloatingPointNaN(this.pointer, n, n2);
        return new Term(l);
    }

    private native long mkFloatingPointNaN(long var1, int var3, int var4);

    public Term mkFloatingPointPosZero(int n, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "exp");
        Utils.validateUnsigned(n2, "sig");
        long l = this.mkFloatingPointPosZero(this.pointer, n, n2);
        return new Term(l);
    }

    private native long mkFloatingPointPosZero(long var1, int var3, int var4);

    public Term mkFloatingPointNegZero(int n, int n2) throws CVC5ApiException {
        Utils.validateUnsigned(n, "exp");
        Utils.validateUnsigned(n2, "sig");
        long l = this.mkFloatingPointNegZero(this.pointer, n, n2);
        return new Term(l);
    }

    private native long mkFloatingPointNegZero(long var1, int var3, int var4);

    public Term mkRoundingMode(RoundingMode roundingMode) {
        long l = this.mkRoundingMode(this.pointer, roundingMode.getValue());
        return new Term(l);
    }

    private native long mkRoundingMode(long var1, int var3);

    public Term mkFloatingPoint(int n, int n2, Term term) throws CVC5ApiException {
        Utils.validateUnsigned(n, "exp");
        Utils.validateUnsigned(n2, "sig");
        long l = this.mkFloatingPoint(this.pointer, n, n2, term.getPointer());
        return new Term(l);
    }

    private native long mkFloatingPoint(long var1, int var3, int var4, long var5);

    public Term mkCardinalityConstraint(Sort sort, int n) throws CVC5ApiException {
        Utils.validateUnsigned(n, "upperBound");
        long l = this.mkCardinalityConstraint(this.pointer, sort.getPointer(), n);
        return new Term(l);
    }

    private native long mkCardinalityConstraint(long var1, long var3, int var5);

    public Term mkConst(Sort sort, String string) {
        long l = this.mkConst(this.pointer, sort.getPointer(), string);
        return new Term(l);
    }

    private native long mkConst(long var1, long var3, String var5);

    public Term mkConst(Sort sort) {
        long l = this.mkConst(this.pointer, sort.getPointer());
        return new Term(l);
    }

    private native long mkConst(long var1, long var3);

    public Term mkVar(Sort sort) {
        return this.mkVar(sort, "");
    }

    public Term mkVar(Sort sort, String string) {
        long l = this.mkVar(this.pointer, sort.getPointer(), string);
        return new Term(l);
    }

    private native long mkVar(long var1, long var3, String var5);

    public DatatypeConstructorDecl mkDatatypeConstructorDecl(String string) {
        long l = this.mkDatatypeConstructorDecl(this.pointer, string);
        return new DatatypeConstructorDecl(l);
    }

    private native long mkDatatypeConstructorDecl(long var1, String var3);

    public DatatypeDecl mkDatatypeDecl(String string) {
        return this.mkDatatypeDecl(string, false);
    }

    public DatatypeDecl mkDatatypeDecl(String string, boolean bl) {
        long l = this.mkDatatypeDecl(this.pointer, string, bl);
        return new DatatypeDecl(l);
    }

    private native long mkDatatypeDecl(long var1, String var3, boolean var4);

    public DatatypeDecl mkDatatypeDecl(String string, Sort[] sortArray) {
        return this.mkDatatypeDecl(string, sortArray, false);
    }

    public DatatypeDecl mkDatatypeDecl(String string, Sort[] sortArray, boolean bl) {
        long[] lArray = Utils.getPointers(sortArray);
        long l = this.mkDatatypeDecl(this.pointer, string, lArray, bl);
        return new DatatypeDecl(l);
    }

    private native long mkDatatypeDecl(long var1, String var3, long[] var4, boolean var5);

    public Term simplify(Term term) {
        long l = this.simplify(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long simplify(long var1, long var3);

    public void assertFormula(Term term) {
        this.assertFormula(this.pointer, term.getPointer());
    }

    private native void assertFormula(long var1, long var3);

    public Result checkSat() {
        long l = this.checkSat(this.pointer);
        return new Result(l);
    }

    private native long checkSat(long var1);

    public Result checkSatAssuming(Term term) {
        long l = this.checkSatAssuming(this.pointer, term.getPointer());
        return new Result(l);
    }

    private native long checkSatAssuming(long var1, long var3);

    public Result checkSatAssuming(Term[] termArray) {
        long[] lArray = Utils.getPointers(termArray);
        long l = this.checkSatAssuming(this.pointer, lArray);
        return new Result(l);
    }

    private native long checkSatAssuming(long var1, long[] var3);

    public Sort declareDatatype(String string, DatatypeConstructorDecl[] datatypeConstructorDeclArray) {
        long[] lArray = Utils.getPointers(datatypeConstructorDeclArray);
        long l = this.declareDatatype(this.pointer, string, lArray);
        return new Sort(l);
    }

    private native long declareDatatype(long var1, String var3, long[] var4);

    public Term declareFun(String string, Sort[] sortArray, Sort sort) {
        long[] lArray = Utils.getPointers(sortArray);
        long l = this.declareFun(this.pointer, string, lArray, sort.getPointer());
        return new Term(l);
    }

    private native long declareFun(long var1, String var3, long[] var4, long var5);

    public Sort declareSort(String string, int n) throws CVC5ApiException {
        Utils.validateUnsigned(n, "arity");
        long l = this.declareSort(this.pointer, string, n);
        return new Sort(l);
    }

    private native long declareSort(long var1, String var3, int var4);

    public Term defineFun(String string, Term[] termArray, Sort sort, Term term) {
        return this.defineFun(string, termArray, sort, term, false);
    }

    public Term defineFun(String string, Term[] termArray, Sort sort, Term term, boolean bl) {
        long[] lArray = Utils.getPointers(termArray);
        long l = this.defineFun(this.pointer, string, lArray, sort.getPointer(), term.getPointer(), bl);
        return new Term(l);
    }

    private native long defineFun(long var1, String var3, long[] var4, long var5, long var7, boolean var9);

    public Term defineFunRec(String string, Term[] termArray, Sort sort, Term term) {
        return this.defineFunRec(string, termArray, sort, term, false);
    }

    public Term defineFunRec(String string, Term[] termArray, Sort sort, Term term, boolean bl) {
        long[] lArray = Utils.getPointers(termArray);
        long l = this.defineFunRec(this.pointer, string, lArray, sort.getPointer(), term.getPointer(), bl);
        return new Term(l);
    }

    private native long defineFunRec(long var1, String var3, long[] var4, long var5, long var7, boolean var9);

    public Term defineFunRec(Term term, Term[] termArray, Term term2) {
        return this.defineFunRec(term, termArray, term2, false);
    }

    public Term defineFunRec(Term term, Term[] termArray, Term term2, boolean bl) {
        long[] lArray = Utils.getPointers(termArray);
        long l = this.defineFunRec(this.pointer, term.getPointer(), lArray, term2.getPointer(), bl);
        return new Term(l);
    }

    private native long defineFunRec(long var1, long var3, long[] var5, long var6, boolean var8);

    public void defineFunsRec(Term[] termArray, Term[][] termArray2, Term[] termArray3) {
        this.defineFunsRec(termArray, termArray2, termArray3, false);
    }

    public void defineFunsRec(Term[] termArray, Term[][] termArray2, Term[] termArray3, boolean bl) {
        long[] lArray = Utils.getPointers(termArray);
        long[][] lArray2 = Utils.getPointers(termArray2);
        long[] lArray3 = Utils.getPointers(termArray3);
        this.defineFunsRec(this.pointer, lArray, lArray2, lArray3, bl);
    }

    private native void defineFunsRec(long var1, long[] var3, long[][] var4, long[] var5, boolean var6);

    public Term[] getLearnedLiterals() {
        long[] lArray = this.getLearnedLiterals(this.pointer);
        return Utils.getTerms(lArray);
    }

    private native long[] getLearnedLiterals(long var1);

    public Term[] getLearnedLiterals(LearnedLitType learnedLitType) {
        long[] lArray = this.getLearnedLiterals(this.pointer, learnedLitType.getValue());
        return Utils.getTerms(lArray);
    }

    private native long[] getLearnedLiterals(long var1, int var3);

    public Term[] getAssertions() {
        long[] lArray = this.getAssertions(this.pointer);
        return Utils.getTerms(lArray);
    }

    private native long[] getAssertions(long var1);

    public String getInfo(String string) {
        return this.getInfo(this.pointer, string);
    }

    private native String getInfo(long var1, String var3);

    public String getOption(String string) {
        return this.getOption(this.pointer, string);
    }

    private native String getOption(long var1, String var3);

    public String[] getOptionNames() {
        return this.getOptionNames(this.pointer);
    }

    private native String[] getOptionNames(long var1);

    public OptionInfo getOptionInfo(String string) {
        long l = this.getOptionInfo(this.pointer, string);
        return new OptionInfo(l);
    }

    private native long getOptionInfo(long var1, String var3);

    public Term[] getUnsatAssumptions() {
        long[] lArray = this.getUnsatAssumptions(this.pointer);
        return Utils.getTerms(lArray);
    }

    private native long[] getUnsatAssumptions(long var1);

    public Term[] getUnsatCore() {
        long[] lArray = this.getUnsatCore(this.pointer);
        return Utils.getTerms(lArray);
    }

    private native long[] getUnsatCore(long var1);

    public Map<Term, Term> getDifficulty() {
        Map<Long, Long> map = this.getDifficulty(this.pointer);
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (Map.Entry<Long, Long> entry : map.entrySet()) {
            Term term = new Term(entry.getKey());
            Term term2 = new Term(entry.getValue());
            hashMap.put(term, term2);
        }
        return hashMap;
    }

    private native Map<Long, Long> getDifficulty(long var1);

    public String getProof() {
        return this.getProof(this.pointer);
    }

    private native String getProof(long var1);

    public String getProof(ProofComponent proofComponent) {
        return this.getProof(this.pointer, proofComponent.getValue());
    }

    private native String getProof(long var1, int var3);

    public Term getValue(Term term) {
        long l = this.getValue(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long getValue(long var1, long var3);

    public Term[] getValue(Term[] termArray) {
        long[] lArray = Utils.getPointers(termArray);
        long[] lArray2 = this.getValue(this.pointer, lArray);
        return Utils.getTerms(lArray2);
    }

    private native long[] getValue(long var1, long[] var3);

    public Term[] getModelDomainElements(Sort sort) {
        long[] lArray = this.getModelDomainElements(this.pointer, sort.getPointer());
        return Utils.getTerms(lArray);
    }

    private native long[] getModelDomainElements(long var1, long var3);

    public boolean isModelCoreSymbol(Term term) {
        return this.isModelCoreSymbol(this.pointer, term.getPointer());
    }

    private native boolean isModelCoreSymbol(long var1, long var3);

    public String getModel(Sort[] sortArray, Term[] termArray) {
        long[] lArray = Utils.getPointers(sortArray);
        long[] lArray2 = Utils.getPointers(termArray);
        return this.getModel(this.pointer, lArray, lArray2);
    }

    private native String getModel(long var1, long[] var3, long[] var4);

    public Term getQuantifierElimination(Term term) {
        long l = this.getQuantifierElimination(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long getQuantifierElimination(long var1, long var3);

    public Term getQuantifierEliminationDisjunct(Term term) {
        long l = this.getQuantifierEliminationDisjunct(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long getQuantifierEliminationDisjunct(long var1, long var3);

    public void declareSepHeap(Sort sort, Sort sort2) {
        this.declareSepHeap(this.pointer, sort.getPointer(), sort2.getPointer());
    }

    private native void declareSepHeap(long var1, long var3, long var5);

    public Term getValueSepHeap() {
        long l = this.getValueSepHeap(this.pointer);
        return new Term(l);
    }

    private native long getValueSepHeap(long var1);

    public Term getValueSepNil() {
        long l = this.getValueSepNil(this.pointer);
        return new Term(l);
    }

    private native long getValueSepNil(long var1);

    public Term declarePool(String string, Sort sort, Term[] termArray) {
        long[] lArray = Utils.getPointers(termArray);
        long l = this.declarePool(this.pointer, string, sort.getPointer(), lArray);
        return new Term(l);
    }

    private native long declarePool(long var1, String var3, long var4, long[] var6);

    public Term declareOracleFun(String string, Sort[] sortArray, Sort sort, IOracle iOracle) {
        this.oracles.add(iOracle);
        long[] lArray = Utils.getPointers(sortArray);
        long l = this.declareOracleFun(this.pointer, string, lArray, sort.getPointer(), iOracle);
        return new Term(l);
    }

    private native long declareOracleFun(long var1, String var3, long[] var4, long var5, IOracle var7);

    public void pop() throws CVC5ApiException {
        this.pop(1);
    }

    public void pop(int n) throws CVC5ApiException {
        Utils.validateUnsigned(n, "nscopes");
        this.pop(this.pointer, n);
    }

    private native void pop(long var1, int var3);

    public Term getInterpolant(Term term) {
        long l = this.getInterpolant(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long getInterpolant(long var1, long var3);

    public Term getInterpolant(Term term, Grammar grammar) {
        long l = this.getInterpolant(this.pointer, term.getPointer(), grammar.getPointer());
        return new Term(l);
    }

    private native long getInterpolant(long var1, long var3, long var5);

    public Term getInterpolantNext() {
        long l = this.getInterpolantNext(this.pointer);
        return new Term(l);
    }

    private native long getInterpolantNext(long var1);

    public Term getAbduct(Term term) {
        long l = this.getAbduct(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long getAbduct(long var1, long var3);

    public Term getAbduct(Term term, Grammar grammar) {
        long l = this.getAbduct(this.pointer, term.getPointer(), grammar.getPointer());
        return new Term(l);
    }

    private native long getAbduct(long var1, long var3, long var5);

    public Term getAbductNext() {
        long l = this.getAbductNext(this.pointer);
        return new Term(l);
    }

    private native long getAbductNext(long var1);

    public void blockModel(BlockModelsMode blockModelsMode) {
        this.blockModel(this.pointer, blockModelsMode.getValue());
    }

    private native void blockModel(long var1, int var3);

    public void blockModelValues(Term[] termArray) {
        long[] lArray = Utils.getPointers(termArray);
        this.blockModelValues(this.pointer, lArray);
    }

    private native void blockModelValues(long var1, long[] var3);

    public String getInstantiations() {
        return this.getInstantiations(this.pointer);
    }

    private native String getInstantiations(long var1);

    public void push() throws CVC5ApiException {
        this.push(1);
    }

    public void push(int n) throws CVC5ApiException {
        Utils.validateUnsigned(n, "nscopes");
        this.push(this.pointer, n);
    }

    private native void push(long var1, int var3);

    public void resetAssertions() {
        this.resetAssertions(this.pointer);
    }

    private native void resetAssertions(long var1);

    public void setInfo(String string, String string2) throws CVC5ApiException {
        this.setInfo(this.pointer, string, string2);
    }

    private native void setInfo(long var1, String var3, String var4) throws CVC5ApiException;

    public void setLogic(String string) throws CVC5ApiException {
        this.setLogic(this.pointer, string);
    }

    private native void setLogic(long var1, String var3) throws CVC5ApiException;

    public void setOption(String string, String string2) {
        this.setOption(this.pointer, string, string2);
    }

    private native void setOption(long var1, String var3, String var4);

    public Term declareSygusVar(String string, Sort sort) {
        long l = this.declareSygusVar(this.pointer, string, sort.getPointer());
        return new Term(l);
    }

    private native long declareSygusVar(long var1, String var3, long var4);

    public Grammar mkGrammar(Term[] termArray, Term[] termArray2) {
        long[] lArray = Utils.getPointers(termArray);
        long[] lArray2 = Utils.getPointers(termArray2);
        long l = this.mkGrammar(this.pointer, lArray, lArray2);
        return new Grammar(l);
    }

    private native long mkGrammar(long var1, long[] var3, long[] var4);

    public Term synthFun(String string, Term[] termArray, Sort sort) {
        long[] lArray = Utils.getPointers(termArray);
        long l = this.synthFun(this.pointer, string, lArray, sort.getPointer());
        return new Term(l);
    }

    private native long synthFun(long var1, String var3, long[] var4, long var5);

    public Term synthFun(String string, Term[] termArray, Sort sort, Grammar grammar) {
        long[] lArray = Utils.getPointers(termArray);
        long l = this.synthFun(this.pointer, string, lArray, sort.getPointer(), grammar.getPointer());
        return new Term(l);
    }

    private native long synthFun(long var1, String var3, long[] var4, long var5, long var7);

    public Term synthInv(String string, Term[] termArray) {
        long[] lArray = Utils.getPointers(termArray);
        long l = this.synthInv(this.pointer, string, lArray);
        return new Term(l);
    }

    private native long synthInv(long var1, String var3, long[] var4);

    public Term synthInv(String string, Term[] termArray, Grammar grammar) {
        long[] lArray = Utils.getPointers(termArray);
        long l = this.synthInv(this.pointer, string, lArray, grammar.getPointer());
        return new Term(l);
    }

    private native long synthInv(long var1, String var3, long[] var4, long var5);

    public void addSygusConstraint(Term term) {
        this.addSygusConstraint(this.pointer, term.getPointer());
    }

    private native void addSygusConstraint(long var1, long var3);

    public Term[] getSygusConstraints() {
        long[] lArray = this.getSygusConstraints(this.pointer);
        return Utils.getTerms(lArray);
    }

    private native long[] getSygusConstraints(long var1);

    public void addSygusAssume(Term term) {
        this.addSygusAssume(this.pointer, term.getPointer());
    }

    private native void addSygusAssume(long var1, long var3);

    public Term[] getSygusAssumptions() {
        long[] lArray = this.getSygusAssumptions(this.pointer);
        return Utils.getTerms(lArray);
    }

    private native long[] getSygusAssumptions(long var1);

    public void addSygusInvConstraint(Term term, Term term2, Term term3, Term term4) {
        this.addSygusInvConstraint(this.pointer, term.getPointer(), term2.getPointer(), term3.getPointer(), term4.getPointer());
    }

    private native void addSygusInvConstraint(long var1, long var3, long var5, long var7, long var9);

    public SynthResult checkSynth() {
        long l = this.checkSynth(this.pointer);
        return new SynthResult(l);
    }

    private native long checkSynth(long var1);

    public SynthResult checkSynthNext() {
        long l = this.checkSynthNext(this.pointer);
        return new SynthResult(l);
    }

    private native long checkSynthNext(long var1);

    public Term getSynthSolution(Term term) {
        long l = this.getSynthSolution(this.pointer, term.getPointer());
        return new Term(l);
    }

    private native long getSynthSolution(long var1, long var3);

    public Term[] getSynthSolutions(Term[] termArray) {
        long[] lArray = Utils.getPointers(termArray);
        long[] lArray2 = this.getSynthSolutions(this.pointer, lArray);
        return Utils.getTerms(lArray2);
    }

    private native long[] getSynthSolutions(long var1, long[] var3);

    public Statistics getStatistics() {
        long l = this.getStatistics(this.pointer);
        return new Statistics(l);
    }

    private native long getStatistics(long var1);

    public String getVersion() {
        return this.getVersion(this.pointer);
    }

    private native String getVersion(long var1);

    static {
        Utils.loadLibraries();
    }
}

