/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.CVC4;

import edu.stanford.CVC4.BitVector;
import edu.stanford.CVC4.BitVectorSize;
import edu.stanford.CVC4.CVC4JNI;
import edu.stanford.CVC4.Exception;
import edu.stanford.CVC4.FloatingPointSize;
import edu.stanford.CVC4.Rational;
import edu.stanford.CVC4.RoundingMode;

public class FloatingPoint {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected FloatingPoint(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(FloatingPoint floatingPoint) {
        return floatingPoint == null ? 0L : floatingPoint.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CVC4JNI.delete_FloatingPoint(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setT(FloatingPointSize floatingPointSize) throws Exception {
        CVC4JNI.FloatingPoint_t_set(this.swigCPtr, this, FloatingPointSize.getCPtr(floatingPointSize), floatingPointSize);
    }

    public FloatingPointSize getT() throws Exception {
        long l = CVC4JNI.FloatingPoint_t_get(this.swigCPtr, this);
        return l == 0L ? null : new FloatingPointSize(l, false);
    }

    public FloatingPoint(long l, long l2, BitVector bitVector) throws Exception {
        this(CVC4JNI.new_FloatingPoint__SWIG_0(l, l2, BitVector.getCPtr(bitVector), bitVector), true);
    }

    public FloatingPoint(FloatingPoint floatingPoint) throws Exception {
        this(CVC4JNI.new_FloatingPoint__SWIG_1(FloatingPoint.getCPtr(floatingPoint), floatingPoint), true);
    }

    public FloatingPoint(FloatingPointSize floatingPointSize, RoundingMode roundingMode, BitVector bitVector, boolean bl) throws Exception {
        this(CVC4JNI.new_FloatingPoint__SWIG_2(FloatingPointSize.getCPtr(floatingPointSize), floatingPointSize, roundingMode.swigValue(), BitVector.getCPtr(bitVector), bitVector, bl), true);
    }

    public FloatingPoint(FloatingPointSize floatingPointSize, RoundingMode roundingMode, Rational rational) throws Exception {
        this(CVC4JNI.new_FloatingPoint__SWIG_3(FloatingPointSize.getCPtr(floatingPointSize), floatingPointSize, roundingMode.swigValue(), Rational.getCPtr(rational), rational), true);
    }

    public static FloatingPoint makeNaN(FloatingPointSize floatingPointSize) throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_makeNaN(FloatingPointSize.getCPtr(floatingPointSize), floatingPointSize), true);
    }

    public static FloatingPoint makeInf(FloatingPointSize floatingPointSize, boolean bl) throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_makeInf(FloatingPointSize.getCPtr(floatingPointSize), floatingPointSize, bl), true);
    }

    public static FloatingPoint makeZero(FloatingPointSize floatingPointSize, boolean bl) throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_makeZero(FloatingPointSize.getCPtr(floatingPointSize), floatingPointSize, bl), true);
    }

    public String toString(boolean bl) throws Exception {
        return CVC4JNI.FloatingPoint_toString__SWIG_0(this.swigCPtr, this, bl);
    }

    public String toString() throws Exception {
        return CVC4JNI.FloatingPoint_toString__SWIG_1(this.swigCPtr, this);
    }

    public BitVector pack() throws Exception {
        return new BitVector(CVC4JNI.FloatingPoint_pack(this.swigCPtr, this), true);
    }

    public FloatingPoint absolute() throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_absolute(this.swigCPtr, this), true);
    }

    public FloatingPoint negate() throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_negate(this.swigCPtr, this), true);
    }

    public FloatingPoint plus(RoundingMode roundingMode, FloatingPoint floatingPoint) throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_plus(this.swigCPtr, this, roundingMode.swigValue(), FloatingPoint.getCPtr(floatingPoint), floatingPoint), true);
    }

    public FloatingPoint sub(RoundingMode roundingMode, FloatingPoint floatingPoint) throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_sub(this.swigCPtr, this, roundingMode.swigValue(), FloatingPoint.getCPtr(floatingPoint), floatingPoint), true);
    }

    public FloatingPoint mult(RoundingMode roundingMode, FloatingPoint floatingPoint) throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_mult(this.swigCPtr, this, roundingMode.swigValue(), FloatingPoint.getCPtr(floatingPoint), floatingPoint), true);
    }

    public FloatingPoint div(RoundingMode roundingMode, FloatingPoint floatingPoint) throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_div(this.swigCPtr, this, roundingMode.swigValue(), FloatingPoint.getCPtr(floatingPoint), floatingPoint), true);
    }

    public FloatingPoint fma(RoundingMode roundingMode, FloatingPoint floatingPoint, FloatingPoint floatingPoint2) throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_fma(this.swigCPtr, this, roundingMode.swigValue(), FloatingPoint.getCPtr(floatingPoint), floatingPoint, FloatingPoint.getCPtr(floatingPoint2), floatingPoint2), true);
    }

    public FloatingPoint sqrt(RoundingMode roundingMode) throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_sqrt(this.swigCPtr, this, roundingMode.swigValue()), true);
    }

    public FloatingPoint rti(RoundingMode roundingMode) throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_rti(this.swigCPtr, this, roundingMode.swigValue()), true);
    }

    public FloatingPoint rem(FloatingPoint floatingPoint) throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_rem(this.swigCPtr, this, FloatingPoint.getCPtr(floatingPoint), floatingPoint), true);
    }

    public FloatingPoint maxTotal(FloatingPoint floatingPoint, boolean bl) throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_maxTotal(this.swigCPtr, this, FloatingPoint.getCPtr(floatingPoint), floatingPoint, bl), true);
    }

    public FloatingPoint minTotal(FloatingPoint floatingPoint, boolean bl) throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_minTotal(this.swigCPtr, this, FloatingPoint.getCPtr(floatingPoint), floatingPoint, bl), true);
    }

    public boolean isNormal() throws Exception {
        return CVC4JNI.FloatingPoint_isNormal(this.swigCPtr, this);
    }

    public boolean isSubnormal() throws Exception {
        return CVC4JNI.FloatingPoint_isSubnormal(this.swigCPtr, this);
    }

    public boolean isZero() throws Exception {
        return CVC4JNI.FloatingPoint_isZero(this.swigCPtr, this);
    }

    public boolean isInfinite() throws Exception {
        return CVC4JNI.FloatingPoint_isInfinite(this.swigCPtr, this);
    }

    public boolean isNaN() throws Exception {
        return CVC4JNI.FloatingPoint_isNaN(this.swigCPtr, this);
    }

    public boolean isNegative() throws Exception {
        return CVC4JNI.FloatingPoint_isNegative(this.swigCPtr, this);
    }

    public boolean isPositive() throws Exception {
        return CVC4JNI.FloatingPoint_isPositive(this.swigCPtr, this);
    }

    public FloatingPoint convert(FloatingPointSize floatingPointSize, RoundingMode roundingMode) throws Exception {
        return new FloatingPoint(CVC4JNI.FloatingPoint_convert(this.swigCPtr, this, FloatingPointSize.getCPtr(floatingPointSize), floatingPointSize, roundingMode.swigValue()), true);
    }

    public BitVector convertToBVTotal(BitVectorSize bitVectorSize, RoundingMode roundingMode, boolean bl, BitVector bitVector) throws Exception {
        return new BitVector(CVC4JNI.FloatingPoint_convertToBVTotal(this.swigCPtr, this, BitVectorSize.getCPtr(bitVectorSize), bitVectorSize, roundingMode.swigValue(), bl, BitVector.getCPtr(bitVector), bitVector), true);
    }

    public Rational convertToRationalTotal(Rational rational) throws Exception {
        return new Rational(CVC4JNI.FloatingPoint_convertToRationalTotal(this.swigCPtr, this, Rational.getCPtr(rational), rational), true);
    }
}

