/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.microsoft.z3.Native;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;

class Z3ArrayFormulaManager
extends AbstractArrayFormulaManager<Long, Long, Long, Long> {
    private final long z3context;

    Z3ArrayFormulaManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Long)creator.getEnv();
    }

    @Override
    protected Long select(Long pArray, Long pIndex) {
        return Native.mkSelect((long)this.z3context, (long)pArray, (long)pIndex);
    }

    @Override
    protected Long store(Long pArray, Long pIndex, Long pValue) {
        return Native.mkStore((long)this.z3context, (long)pArray, (long)pIndex, (long)pValue);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> Long internalMakeArray(String pName, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        Long z3ArrayType = (Long)this.toSolverType(FormulaType.getArrayType(pIndexType, pElementType));
        return (Long)this.getFormulaCreator().makeVariable(z3ArrayType, pName);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> Long internalMakeArray(FormulaType<TI> pIndexType, FormulaType<TE> pElementType, Long defaultElement) {
        return Native.mkConstArray((long)this.z3context, (long)((Long)this.toSolverType(pIndexType)), (long)defaultElement);
    }

    @Override
    protected Long equivalence(Long pArray1, Long pArray2) {
        return Native.mkEq((long)this.z3context, (long)pArray1, (long)pArray2);
    }
}

