/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolAbstractProver;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaManager;

class SmtInterpolInterpolatingProver
extends SmtInterpolAbstractProver<String>
implements InterpolatingProverEnvironment<String> {
    SmtInterpolInterpolatingProver(SmtInterpolFormulaManager pMgr, Script pScript, Set<SolverContext.ProverOptions> options, ShutdownNotifier pShutdownNotifier) {
        super(pMgr, pScript, options, pShutdownNotifier);
    }

    @Override
    protected String addConstraintImpl(BooleanFormula constraint) throws InterruptedException {
        return super.addConstraint0(constraint);
    }

    @Override
    public BooleanFormula getInterpolant(Collection<String> pTermNamesOfA) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.getAssertedConstraintIds().containsAll(pTermNamesOfA), (Object)"interpolation can only be done over previously asserted formulas.");
        if (pTermNamesOfA.isEmpty()) {
            return this.mgr.getBooleanFormulaManager().makeBoolean(true);
        }
        if (pTermNamesOfA.containsAll(((PersistentMap)this.annotatedTerms.peek()).keySet())) {
            return this.mgr.getBooleanFormulaManager().makeBoolean(false);
        }
        ImmutableSet termNamesOfA = ImmutableSet.copyOf(pTermNamesOfA);
        Sets.SetView termNamesOfB = Sets.difference((Set)((PersistentMap)this.annotatedTerms.peek()).keySet(), (Set)termNamesOfA);
        return (BooleanFormula)Iterables.getOnlyElement(this.getSeqInterpolants(ImmutableList.of((Object)termNamesOfA, (Object)termNamesOfB)));
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<? extends Collection<String>> partitionedTermNames, int[] startOfSubTree) throws SolverException, InterruptedException {
        Term[] itps;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ImmutableSet assertedConstraintIds = this.getAssertedConstraintIds();
        Preconditions.checkArgument((boolean)partitionedTermNames.stream().allMatch(arg_0 -> assertedConstraintIds.containsAll(arg_0)), (Object)"interpolation can only be done over previously asserted formulas.");
        assert (InterpolatingProverEnvironment.checkTreeStructure(partitionedTermNames.size(), startOfSubTree));
        Term[] formulas = new Term[partitionedTermNames.size()];
        for (int i = 0; i < formulas.length; ++i) {
            formulas[i] = this.buildConjunctionOfNamedTerms(partitionedTermNames.get(i));
        }
        try {
            itps = this.env.getInterpolants(formulas, startOfSubTree);
        }
        catch (UnsupportedOperationException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Cannot interpolate ")) {
                throw new SolverException(e.getMessage(), e);
            }
            throw e;
        }
        catch (SMTLIBException e) {
            if ("Timeout exceeded".equals(e.getMessage())) {
                this.shutdownNotifier.shutdownIfNecessary();
            }
            throw new AssertionError((Object)e);
        }
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (Term itp : itps) {
            result.add(this.mgr.encapsulateBooleanFormula(itp));
        }
        assert (result.size() == startOfSubTree.length - 1);
        return result;
    }

    private Term buildConjunctionOfNamedTerms(Collection<String> termNames) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((!termNames.isEmpty() ? 1 : 0) != 0);
        if (termNames.size() == 1) {
            return this.env.term((String)Iterables.getOnlyElement(termNames), new Term[0]);
        }
        return this.env.term("and", (Term[])termNames.stream().map(x$0 -> this.env.term(x$0, new Term[0])).toArray(Term[]::new));
    }
}

