/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt;

import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.basicimpl.FunctionDeclarationImpl;
import org.sosy_lab.java_smt.solvers.opensmt.Logics;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtFormula;
import org.sosy_lab.java_smt.solvers.opensmt.api.ArithLogic;
import org.sosy_lab.java_smt.solvers.opensmt.api.Logic;
import org.sosy_lab.java_smt.solvers.opensmt.api.LogicFactory;
import org.sosy_lab.java_smt.solvers.opensmt.api.Logic_t;
import org.sosy_lab.java_smt.solvers.opensmt.api.PTRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.Pterm;
import org.sosy_lab.java_smt.solvers.opensmt.api.SRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SymRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.VectorPTRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.VectorSRef;

public class OpenSmtFormulaCreator
extends FormulaCreator<PTRef, SRef, Logic, SymRef> {
    private final Logics logicToUse;

    private OpenSmtFormulaCreator(Logics logicType, Logic logic) {
        super(logic, logic.getSort_bool(), logic instanceof ArithLogic ? ((ArithLogic)logic).getSort_int() : null, logic instanceof ArithLogic ? ((ArithLogic)logic).getSort_real() : null, null, null);
        this.logicToUse = logicType;
    }

    public static OpenSmtFormulaCreator create(Logics logicType) {
        return new OpenSmtFormulaCreator(logicType, OpenSmtFormulaCreator.createLogic(logicType));
    }

    private static Logic createLogic(Logics logicType) {
        switch (logicType) {
            case CORE: {
                return LogicFactory.getInstance((Logic_t)Logic_t.QF_BOOL);
            }
            case QF_AX: {
                return LogicFactory.getInstance((Logic_t)Logic_t.QF_AX);
            }
            case QF_UF: {
                return LogicFactory.getInstance((Logic_t)Logic_t.QF_UF);
            }
            case QF_IDL: {
                return LogicFactory.getLAInstance((Logic_t)Logic_t.QF_IDL);
            }
            case QF_RDL: {
                return LogicFactory.getLAInstance((Logic_t)Logic_t.QF_RDL);
            }
            case QF_LIA: {
                return LogicFactory.getLAInstance((Logic_t)Logic_t.QF_LIA);
            }
            case QF_LRA: {
                return LogicFactory.getLAInstance((Logic_t)Logic_t.QF_LRA);
            }
            case QF_ALIA: {
                return LogicFactory.getLAInstance((Logic_t)Logic_t.QF_ALIA);
            }
            case QF_ALRA: {
                return LogicFactory.getLAInstance((Logic_t)Logic_t.QF_ALRA);
            }
            case QF_UFLIA: {
                return LogicFactory.getLAInstance((Logic_t)Logic_t.QF_UFLIA);
            }
            case QF_UFLRA: {
                return LogicFactory.getLAInstance((Logic_t)Logic_t.QF_UFLRA);
            }
            case QF_AUFLIA: {
                return LogicFactory.getLAInstance((Logic_t)Logic_t.QF_AUFLIA);
            }
            case QF_AUFLRA: {
                return LogicFactory.getLAInstance((Logic_t)Logic_t.QF_AUFLRA);
            }
            case QF_AUFLIRA: {
                return LogicFactory.getLAInstance((Logic_t)Logic_t.QF_AUFLIRA);
            }
        }
        throw new AssertionError((Object)"no logic available");
    }

    Logics getLogic() {
        return this.logicToUse;
    }

    @Override
    public PTRef extractInfo(Formula pT) {
        OpenSmtFormula formula = (OpenSmtFormula)pT;
        return formula.getOsmtTerm();
    }

    @Override
    public PTRef callFunctionImpl(SymRef declaration, List<PTRef> args) {
        return ((Logic)this.getEnv()).insertTerm(declaration, new VectorPTRef(args));
    }

    @Override
    public SymRef declareUFImpl(String pName, SRef pReturnType, List<SRef> pArgTypes) {
        return ((Logic)this.getEnv()).declareFun(pName, pReturnType, new VectorSRef(pArgTypes));
    }

    @Override
    public SRef getArrayType(SRef indexType, SRef elementType) {
        return ((Logic)this.getEnv()).getArraySort(indexType, elementType);
    }

    @Override
    public SRef getBitvectorType(int bitwidth) {
        throw new UnsupportedOperationException("OpenSMT does not support bitvectors.");
    }

    @Override
    public SymRef getBooleanVarDeclarationImpl(PTRef pPTRef) {
        return ((Logic)this.getEnv()).getSymRef(pPTRef);
    }

    @Override
    public SRef getFloatingPointType(FormulaType.FloatingPointType type) {
        throw new UnsupportedOperationException("OpenSMT does not support floating point operations.");
    }

    @Override
    protected <TD extends Formula, TR extends Formula> FormulaType<TD> getArrayFormulaIndexType(ArrayFormula<TD, TR> pArray) {
        OpenSmtFormula.OpenSmtArrayFormula array = (OpenSmtFormula.OpenSmtArrayFormula)pArray;
        return array.getIndexType();
    }

    @Override
    protected <TD extends Formula, TR extends Formula> FormulaType<TR> getArrayFormulaElementType(ArrayFormula<TD, TR> pArray) {
        OpenSmtFormula.OpenSmtArrayFormula array = (OpenSmtFormula.OpenSmtArrayFormula)pArray;
        return array.getElementType();
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        if (pFormula instanceof ArrayFormula) {
            FormulaType arrayIndexType = this.getArrayFormulaIndexType((ArrayFormula)pFormula);
            FormulaType arrayElementType = this.getArrayFormulaElementType((ArrayFormula)pFormula);
            return FormulaType.getArrayType(arrayIndexType, arrayElementType);
        }
        return super.getFormulaType(pFormula);
    }

    @Override
    public FormulaType<?> getFormulaType(PTRef pFormula) {
        SRef sort = ((Logic)this.getEnv()).getSortRef(pFormula);
        return this.getFormulaTypeFromTermType(sort);
    }

    private FormulaType<?> getFormulaTypeFromTermType(SRef sort) {
        Logic logic = (Logic)this.getEnv();
        if (logic.isSortBool(sort)) {
            return FormulaType.BooleanType;
        }
        if (logic.isArraySort(sort)) {
            VectorSRef args = ((Logic)this.getEnv()).getSortDefinition(sort).getArgs();
            FormulaType<?> indexType = this.getFormulaTypeFromTermType(args.get(0));
            FormulaType<?> elementType = this.getFormulaTypeFromTermType(args.get(1));
            return FormulaType.getArrayType(indexType, elementType);
        }
        ArithLogic alogic = (ArithLogic)this.getEnv();
        if (alogic.isSortInt(sort)) {
            return FormulaType.IntegerType;
        }
        if (alogic.isSortReal(sort)) {
            return FormulaType.RationalType;
        }
        throw new AssertionError((Object)String.format("Encountered unhandled Type '%s'.", sort));
    }

    @Override
    public <T extends Formula> T encapsulate(FormulaType<T> pType, PTRef pTerm) {
        assert (pType.equals(this.getFormulaType(pTerm)) || pType.equals(FormulaType.RationalType) && this.getFormulaType(pTerm).equals(FormulaType.IntegerType)) : String.format("Cannot encapsulate formula %s of Type %s as %s", pTerm, this.getFormulaType(pTerm), pType);
        if (pType.isBooleanType()) {
            return (T)new OpenSmtFormula.OpenSmtBooleanFormula((Logic)this.getEnv(), pTerm);
        }
        if (pType.isIntegerType()) {
            return (T)new OpenSmtFormula.OpenSmtIntegerFormula((Logic)this.getEnv(), pTerm);
        }
        if (pType.isRationalType()) {
            return (T)new OpenSmtFormula.OpenSmtRationalFormula((Logic)this.getEnv(), pTerm);
        }
        if (pType.isArrayType()) {
            FormulaType.ArrayFormulaType arrFt = (FormulaType.ArrayFormulaType)pType;
            return (T)new OpenSmtFormula.OpenSmtArrayFormula((Logic)this.getEnv(), pTerm, arrFt.getIndexType(), arrFt.getElementType());
        }
        throw new IllegalArgumentException("Cannot create formulas of Type " + pType + " in OpenSMT");
    }

    public Formula encapsulate(PTRef pTerm) {
        return this.encapsulate(this.getFormulaType(pTerm), pTerm);
    }

    @Override
    public BooleanFormula encapsulateBoolean(PTRef pTerm) {
        assert (this.getFormulaType(pTerm).isBooleanType()) : String.format("%s is not boolean, but %s (%s)", pTerm, ((Logic)this.getEnv()).getSortRef(pTerm), this.getFormulaType(pTerm));
        return new OpenSmtFormula.OpenSmtBooleanFormula((Logic)this.getEnv(), pTerm);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> encapsulateArray(PTRef pTerm, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        assert (this.getFormulaType(pTerm).equals(FormulaType.getArrayType(pIndexType, pElementType))) : String.format("%s is no array, but %s (%s)", pTerm, ((Logic)this.getEnv()).getSortRef(pTerm), this.getFormulaType(pTerm));
        return new OpenSmtFormula.OpenSmtArrayFormula<TI, TE>((Logic)this.getEnv(), pTerm, pIndexType, pElementType);
    }

    @Override
    public PTRef makeVariable(SRef type, String varName) {
        return ((Logic)this.getEnv()).mkVar(type, varName);
    }

    private FunctionDeclarationKind getDeclarationKind(PTRef f) {
        Logic logic = (Logic)this.getEnv();
        if (logic.isAnd(f)) {
            return FunctionDeclarationKind.AND;
        }
        if (logic.isIff(f)) {
            return FunctionDeclarationKind.IFF;
        }
        if (logic.isImplies(f)) {
            return FunctionDeclarationKind.IMPLIES;
        }
        if (logic.isIte(f)) {
            return FunctionDeclarationKind.ITE;
        }
        if (logic.isNot(f)) {
            return FunctionDeclarationKind.NOT;
        }
        if (logic.isOr(f)) {
            return FunctionDeclarationKind.OR;
        }
        if (logic.isArraySelect(f)) {
            return FunctionDeclarationKind.SELECT;
        }
        if (logic.isArrayStore(f)) {
            return FunctionDeclarationKind.STORE;
        }
        if (logic.isUF(f)) {
            return FunctionDeclarationKind.UF;
        }
        if (logic.isXor(f)) {
            return FunctionDeclarationKind.XOR;
        }
        ArithLogic alogic = (ArithLogic)this.getEnv();
        if (alogic.isPlus(f)) {
            return FunctionDeclarationKind.ADD;
        }
        if (alogic.isDisequality(f)) {
            return FunctionDeclarationKind.DISTINCT;
        }
        if (alogic.isDiv(f)) {
            return FunctionDeclarationKind.DIV;
        }
        if (alogic.isEquality(f)) {
            return FunctionDeclarationKind.EQ;
        }
        if (alogic.isGeq(f)) {
            return FunctionDeclarationKind.GT;
        }
        if (alogic.isGt(f)) {
            return FunctionDeclarationKind.GTE;
        }
        if (alogic.isLt(f)) {
            return FunctionDeclarationKind.LT;
        }
        if (alogic.isLeq(f)) {
            return FunctionDeclarationKind.LTE;
        }
        if (alogic.isMod(f)) {
            return FunctionDeclarationKind.MODULO;
        }
        if (alogic.isTimes(f)) {
            return FunctionDeclarationKind.MUL;
        }
        if (alogic.isMinus(f)) {
            return FunctionDeclarationKind.SUB;
        }
        if (alogic.isNeg(f)) {
            return FunctionDeclarationKind.UMINUS;
        }
        throw new UnsupportedOperationException("Encountered unsupported declaration kind");
    }

    @Override
    public Object convertValue(PTRef value) {
        Logic logic = (Logic)this.getEnv();
        if (logic.isTrue(value)) {
            return Boolean.TRUE;
        }
        if (logic.isFalse(value)) {
            return Boolean.FALSE;
        }
        ArithLogic alogic = (ArithLogic)this.getEnv();
        if (alogic.isIntConst(value)) {
            return new BigInteger(alogic.getNumConst(value));
        }
        if (alogic.isRealConst(value)) {
            Rational ratValue = Rational.ofString((String)alogic.getNumConst(value));
            return ratValue.isIntegral() ? ratValue.getNum() : ratValue;
        }
        throw new UnsupportedOperationException("Term `" + logic.pp(value) + "` is not a value");
    }

    @Override
    public <R> R visit(FormulaVisitor<R> visitor, Formula formula, PTRef f) {
        Logic logic = (Logic)this.getEnv();
        if (logic.isConstant(f)) {
            return visitor.visitConstant(formula, this.convertValue(f));
        }
        if (logic.isVar(f)) {
            String varName = logic.getSymName(logic.getSymRef(f));
            return visitor.visitFreeVariable(formula, OpenSmtFormulaCreator.dequote(varName));
        }
        String varName = logic.getSymName(logic.getSymRef(f));
        ImmutableList.Builder argTerms = ImmutableList.builder();
        ImmutableList.Builder argTypes = ImmutableList.builder();
        Pterm pterm = logic.getPterm(f);
        for (int i = 0; i < pterm.size(); ++i) {
            PTRef sub = pterm.at(i);
            argTerms.add((Object)this.encapsulate(sub));
            argTypes.add(this.getFormulaType(sub));
        }
        return visitor.visitFunction(formula, (List<Formula>)argTerms.build(), FunctionDeclarationImpl.of(varName, this.getDeclarationKind(f), argTypes.build(), this.getFormulaType(f), logic.getSymRef(f)));
    }
}

