/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt;

import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtFormulaCreator;
import org.sosy_lab.java_smt.solvers.opensmt.api.Logic;
import org.sosy_lab.java_smt.solvers.opensmt.api.PTRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SymRef;

public class OpenSmtArrayFormulaManager
extends AbstractArrayFormulaManager<PTRef, SRef, Logic, SymRef> {
    private final Logic logic;

    public OpenSmtArrayFormulaManager(OpenSmtFormulaCreator pFormulaCreator) {
        super(pFormulaCreator);
        this.logic = (Logic)pFormulaCreator.getEnv();
    }

    @Override
    protected PTRef select(PTRef pArray, PTRef pIndex) {
        return this.logic.mkSelect(pArray, pIndex);
    }

    @Override
    protected PTRef store(PTRef pArray, PTRef pIndex, PTRef pValue) {
        return this.logic.mkStore(pArray, pIndex, pValue);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> PTRef internalMakeArray(String pName, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        SRef osmtArrayType = (SRef)this.toSolverType(FormulaType.getArrayType(pIndexType, pElementType));
        return (PTRef)this.getFormulaCreator().makeVariable(osmtArrayType, pName);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> PTRef internalMakeArray(FormulaType<TI> pIndexType, FormulaType<TE> pElementType, PTRef defaultElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected PTRef equivalence(PTRef pArray1, PTRef pArray2) {
        return this.logic.mkEq(pArray1, pArray2);
    }
}

