/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Evaluator;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractProverWithAllSat;
import org.sosy_lab.java_smt.basicimpl.ShutdownHook;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtEvaluator;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtFormulaCreator;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtModel;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtSolverContext;
import org.sosy_lab.java_smt.solvers.opensmt.api.Logic;
import org.sosy_lab.java_smt.solvers.opensmt.api.MainSolver;
import org.sosy_lab.java_smt.solvers.opensmt.api.PTRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SMTConfig;
import org.sosy_lab.java_smt.solvers.opensmt.api.SMTOption;
import org.sosy_lab.java_smt.solvers.opensmt.api.SRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SymRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.Symbol;
import org.sosy_lab.java_smt.solvers.opensmt.api.sstat;

public abstract class OpenSmtAbstractProver<T>
extends AbstractProverWithAllSat<T> {
    protected final OpenSmtFormulaCreator creator;
    protected final MainSolver osmtSolver;
    protected final SMTConfig osmtConfig;
    private boolean changedSinceLastSatQuery = false;

    protected OpenSmtAbstractProver(OpenSmtFormulaCreator pFormulaCreator, FormulaManager pMgr, ShutdownNotifier pShutdownNotifier, SMTConfig pConfig, Set<SolverContext.ProverOptions> pOptions) {
        super(pOptions, pMgr.getBooleanFormulaManager(), pShutdownNotifier);
        this.creator = pFormulaCreator;
        this.osmtConfig = pConfig;
        this.osmtSolver = new MainSolver((Logic)this.creator.getEnv(), pConfig, "JavaSmt");
    }

    protected static SMTConfig getConfigInstance(Set<SolverContext.ProverOptions> pOptions, OpenSmtSolverContext.OpenSMTOptions pSolverOptions, boolean interpolation) {
        SMTConfig config = new SMTConfig();
        config.setOption(":random-seed", new SMTOption(pSolverOptions.randomSeed));
        config.setOption(":produce-models", new SMTOption(pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_MODELS) || pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_ALL_SAT)));
        config.setOption(":produce-unsat-cores", new SMTOption(pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE)));
        config.setOption(":produce-interpolants", new SMTOption(interpolation));
        if (interpolation) {
            config.setOption(":interpolation-bool-algorithm", new SMTOption(pSolverOptions.algBool));
            config.setOption(":interpolation-euf-algorithm", new SMTOption(pSolverOptions.algUf));
            config.setOption(":interpolation-lra-algorithm", new SMTOption(pSolverOptions.algLra));
        }
        return config;
    }

    final MainSolver getOsmtSolver() {
        return this.osmtSolver;
    }

    @Override
    protected void pushImpl() {
        this.setChanged();
        this.osmtSolver.push();
    }

    @Override
    protected void popImpl() {
        this.setChanged();
        this.osmtSolver.pop();
    }

    protected abstract @Nullable T addConstraintImpl(PTRef var1) throws InterruptedException;

    @Override
    protected @Nullable T addConstraintImpl(BooleanFormula pF) throws InterruptedException {
        this.setChanged();
        PTRef f = this.creator.extractInfo(pF);
        return this.addConstraintImpl(f);
    }

    @Override
    public Model getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateModels();
        OpenSmtModel model = new OpenSmtModel(this, this.creator, Collections2.transform(this.getAssertedFormulas(), this.creator::extractInfo));
        return this.registerEvaluator(model);
    }

    @Override
    public Evaluator getEvaluator() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateModels();
        return this.getEvaluatorWithoutChecks();
    }

    @Override
    protected Evaluator getEvaluatorWithoutChecks() {
        return this.registerEvaluator(new OpenSmtEvaluator(this, this.creator));
    }

    protected void setChanged() {
        if (!this.changedSinceLastSatQuery) {
            this.changedSinceLastSatQuery = true;
            this.closeAllEvaluators();
        }
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.changedSinceLastSatQuery ? 1 : 0) != 0);
        return super.getModelAssignments();
    }

    private String getReasonFromSolverFeatures() {
        Logic osmtLogic = (Logic)this.creator.getEnv();
        HashMap<String, PTRef> userDeclarations = new HashMap<String, PTRef>();
        for (PTRef asserted : Collections2.transform(this.getAssertedFormulas(), this.creator::extractInfo)) {
            userDeclarations.putAll(this.creator.extractVariablesAndUFs(asserted, true));
        }
        boolean usesUFs = false;
        boolean usesIntegers = false;
        boolean usesReals = false;
        boolean usesArrays = false;
        for (PTRef term : userDeclarations.values()) {
            SRef sort;
            SymRef ref = osmtLogic.getSymRef(term);
            Symbol sym = osmtLogic.getSym(ref);
            if (sym.size() > 1) {
                usesUFs = true;
            }
            if (osmtLogic.isArraySort(sort = sym.rsort())) {
                usesArrays = true;
            }
            if (sort.equals(this.creator.getIntegerType())) {
                usesIntegers = true;
            }
            if (!sort.equals(this.creator.getRationalType())) continue;
            usesReals = true;
        }
        return this.getReasonFromSolverFeatures(usesUFs, usesIntegers, usesReals, usesArrays);
    }

    protected String getReasonFromSolverFeatures(boolean usesUFs, boolean usesIntegers, boolean usesReals, boolean usesArrays) {
        if (usesIntegers && usesReals) {
            return "OpenSMT does not support mixed integer-real arithmetics.";
        }
        ArrayList<String> errors = new ArrayList<String>();
        if (usesUFs && !this.creator.getLogic().doesLogicSupportUFs()) {
            errors.add("uninterpreted function");
        }
        if (usesIntegers && !this.creator.getLogic().doesLogicSupportIntegers()) {
            errors.add("integer");
        }
        if (usesReals && !this.creator.getLogic().doesLogicSupportReals()) {
            errors.add("real");
        }
        if (usesArrays && !this.creator.getLogic().doesLogicSupportArrays()) {
            errors.add("array");
        }
        if (errors.isEmpty()) {
            return "Unknown reason.";
        }
        return String.format("Assertions use features %s that are not supported by the specified logic %s.", new Object[]{errors, this.creator.getLogic()});
    }

    @Override
    public boolean isUnsat() throws InterruptedException, SolverException {
        sstat result;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.closeAllEvaluators();
        this.changedSinceLastSatQuery = false;
        try (ShutdownHook listener = new ShutdownHook(this.shutdownNotifier, () -> ((MainSolver)this.osmtSolver).stop());){
            this.shutdownNotifier.shutdownIfNecessary();
            try {
                result = this.osmtSolver.check();
            }
            catch (Exception e) {
                if (e.getMessage().isEmpty()) {
                    String reason = String.format(" Most likely reason: %s", this.getReasonFromSolverFeatures());
                    throw new SolverException(String.format("OpenSMT crashed while checking satisfiability. Most likely reason: %s", reason));
                }
                throw new SolverException("OpenSMT crashed while checking satisfiability.", e);
            }
            this.shutdownNotifier.shutdownIfNecessary();
        }
        if (result.equals((Object)sstat.Error())) {
            throw new SolverException("OpenSMT crashed while checking satisfiability.");
        }
        if (result.equals((Object)sstat.Undef())) {
            throw new InterruptedException();
        }
        return result.equals((Object)sstat.False());
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateUnsatCores();
        Preconditions.checkState((!this.changedSinceLastSatQuery ? 1 : 0) != 0);
        ImmutableList.Builder result = ImmutableList.builder();
        for (PTRef r : this.osmtSolver.getUnsatCore()) {
            result.add((Object)this.creator.encapsulateBoolean(r));
        }
        return result.build();
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("OpenSMT does not support solving with assumptions.");
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("OpenSMT does not support solving with assumptions.");
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.osmtSolver.delete();
        }
        super.close();
    }
}

