/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc5;

import com.google.common.collect.ImmutableMap;
import io.github.cvc5.DatatypeConstructorDecl;
import io.github.cvc5.Kind;
import io.github.cvc5.Solver;
import io.github.cvc5.Sort;
import io.github.cvc5.Term;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractEnumerationFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;

public class CVC5EnumerationFormulaManager
extends AbstractEnumerationFormulaManager<Term, Sort, Solver, Term> {
    private final Solver solver;

    protected CVC5EnumerationFormulaManager(FormulaCreator<Term, Sort, Solver, Term> pCreator) {
        super(pCreator);
        this.solver = pCreator.getEnv();
    }

    @Override
    protected AbstractEnumerationFormulaManager.EnumType declareEnumeration0(FormulaType.EnumerationFormulaType pType) {
        DatatypeConstructorDecl[] constructors = (DatatypeConstructorDecl[])pType.getElements().stream().map(arg_0 -> ((Solver)this.solver).mkDatatypeConstructorDecl(arg_0)).toArray(DatatypeConstructorDecl[]::new);
        Sort enumType = this.solver.declareDatatype(pType.getName(), constructors);
        ImmutableMap.Builder constantsMapping = ImmutableMap.builder();
        for (String element : pType.getElements()) {
            Term decl = enumType.getDatatype().getConstructor(element).getTerm();
            constantsMapping.put((Object)element, (Object)this.solver.mkTerm(Kind.APPLY_CONSTRUCTOR, decl));
        }
        return new AbstractEnumerationFormulaManager.EnumType(pType, enumType, constantsMapping.buildOrThrow());
    }

    @Override
    protected Term equivalenceImpl(Term pF1, Term pF2) {
        return this.solver.mkTerm(Kind.EQUAL, pF1, pF2);
    }
}

