/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc5;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.github.cvc5.CVC5ApiException;
import io.github.cvc5.Result;
import io.github.cvc5.Solver;
import io.github.cvc5.Term;
import io.github.cvc5.UnknownExplanation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Evaluator;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractProverWithAllSat;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5Evaluator;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FormulaCreator;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5Model;

abstract class CVC5AbstractProver<T>
extends AbstractProverWithAllSat<T> {
    private static final UniqueIdGenerator ID_GENERATOR = new UniqueIdGenerator();
    private final FormulaManager mgr;
    protected final CVC5FormulaCreator creator;
    protected final Solver solver;
    private boolean changedSinceLastSatQuery = false;
    protected final Deque<PersistentMap<String, Term>> assertedTerms = new ArrayDeque<PersistentMap<String, Term>>();
    protected final boolean incremental;

    protected CVC5AbstractProver(CVC5FormulaCreator pFormulaCreator, ShutdownNotifier pShutdownNotifier, int randomSeed, Set<SolverContext.ProverOptions> pOptions, FormulaManager pMgr, ImmutableMap<String, String> pFurtherOptionsMap) {
        super(pOptions, pMgr.getBooleanFormulaManager(), pShutdownNotifier);
        this.mgr = pMgr;
        this.creator = pFormulaCreator;
        this.incremental = !this.enableSL;
        this.solver = new Solver();
        this.assertedTerms.add((PersistentMap<String, Term>)PathCopyingPersistentTreeMap.of());
        this.setSolverOptions(randomSeed, pOptions, pFurtherOptionsMap, this.solver);
    }

    protected void setSolverOptions(int randomSeed, Set<SolverContext.ProverOptions> pOptions, ImmutableMap<String, String> pFurtherOptionsMap, Solver pSolver) {
        if (this.incremental) {
            pSolver.setOption("incremental", "true");
        }
        if (pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_MODELS)) {
            pSolver.setOption("produce-models", "true");
        }
        if (pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE)) {
            pSolver.setOption("produce-unsat-cores", "true");
        }
        pSolver.setOption("produce-assertions", "true");
        pSolver.setOption("dump-models", "true");
        pSolver.setOption("output-language", "smt2");
        pSolver.setOption("seed", String.valueOf(randomSeed));
        pSolver.setOption("strings-exp", "true");
        pSolver.setOption("full-saturate-quant", "true");
        for (Map.Entry option : pFurtherOptionsMap.entrySet()) {
            pSolver.setOption((String)option.getKey(), (String)option.getValue());
        }
    }

    @Override
    protected void pushImpl() throws InterruptedException {
        this.setChanged();
        this.assertedTerms.push(this.assertedTerms.peek());
        if (this.incremental) {
            try {
                this.solver.push();
            }
            catch (CVC5ApiException e) {
                throw new IllegalStateException("You tried to use push() on an CVC5 assertion stack illegally.", e);
            }
        }
    }

    @Override
    protected void popImpl() {
        this.setChanged();
        if (this.incremental) {
            try {
                this.solver.pop();
            }
            catch (CVC5ApiException e) {
                throw new IllegalStateException("You tried to use pop() on an CVC5 assertion stack illegally.", e);
            }
        }
        this.assertedTerms.pop();
    }

    @CanIgnoreReturnValue
    protected String addConstraint0(BooleanFormula pF) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.setChanged();
        Term exp = this.creator.extractInfo(pF);
        if (this.incremental) {
            this.solver.assertFormula(exp);
        }
        String id = "ID_" + ID_GENERATOR.getFreshId();
        this.assertedTerms.push((PersistentMap<String, Term>)this.assertedTerms.pop().putAndCopy((Object)id, (Object)exp));
        return id;
    }

    @Override
    public CVC5Model getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.changedSinceLastSatQuery ? 1 : 0) != 0);
        this.checkGenerateModels();
        return this.registerEvaluator(new CVC5Model(this, this.mgr, this.creator, Collections2.transform(this.getAssertedFormulas(), this.creator::extractInfo)));
    }

    @Override
    public Evaluator getEvaluator() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateModels();
        return this.getEvaluatorWithoutChecks();
    }

    @Override
    protected Evaluator getEvaluatorWithoutChecks() {
        return this.registerEvaluator(new CVC5Evaluator(this, this.creator));
    }

    protected void setChanged() {
        if (!this.changedSinceLastSatQuery) {
            this.changedSinceLastSatQuery = true;
            this.closeAllEvaluators();
        }
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.changedSinceLastSatQuery ? 1 : 0) != 0);
        return super.getModelAssignments();
    }

    @Override
    public boolean isUnsat() throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.closeAllEvaluators();
        this.changedSinceLastSatQuery = false;
        if (!this.incremental) {
            this.getAssertedFormulas().forEach(f -> this.solver.assertFormula(this.creator.extractInfo((Formula)f)));
        }
        Result result = this.solver.checkSat();
        this.shutdownNotifier.shutdownIfNecessary();
        return this.convertSatResult(result);
    }

    private boolean convertSatResult(Result result) throws InterruptedException, SolverException {
        if (result.isUnknown()) {
            if (result.getUnknownExplanation().equals((Object)UnknownExplanation.INTERRUPTED)) {
                throw new InterruptedException();
            }
            throw new SolverException("CVC5 returned null or unknown on sat check. Exact result: " + result + ".");
        }
        return result.isUnsat();
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateUnsatCores();
        Preconditions.checkState((!this.changedSinceLastSatQuery ? 1 : 0) != 0);
        ArrayList<BooleanFormula> converted = new ArrayList<BooleanFormula>();
        for (Term aCore : this.solver.getUnsatCore()) {
            converted.add(this.creator.encapsulateBoolean(aCore));
        }
        return converted;
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.assertedTerms.clear();
            this.solver.deletePointer();
        }
        super.close();
    }
}

