/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.bitwuzla;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.basicimpl.AbstractModel;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFormulaCreator;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaTheoremProver;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Bitwuzla;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Kind;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Sort;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Term;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Vector_Term;

class BitwuzlaModel
extends AbstractModel<Term, Sort, Void> {
    private final Bitwuzla bitwuzlaEnv;
    private final BitwuzlaTheoremProver prover;
    private final BitwuzlaFormulaCreator bitwuzlaCreator;
    private final ImmutableList<Term> assertedTerms;

    protected BitwuzlaModel(Bitwuzla bitwuzlaEnv, BitwuzlaTheoremProver prover, BitwuzlaFormulaCreator bitwuzlaCreator, Collection<Term> assertedTerms) {
        super(prover, bitwuzlaCreator);
        this.bitwuzlaEnv = bitwuzlaEnv;
        this.prover = prover;
        this.bitwuzlaCreator = bitwuzlaCreator;
        this.assertedTerms = ImmutableList.copyOf(assertedTerms);
    }

    @Override
    public ImmutableList<Model.ValueAssignment> asList() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Preconditions.checkState((!this.prover.isClosed() ? 1 : 0) != 0, (Object)"Cannot use model after prover is closed");
        ImmutableSet.Builder variablesBuilder = ImmutableSet.builder();
        ArrayDeque<Term> queue = new ArrayDeque<Term>((Collection<Term>)this.assertedTerms);
        while (!queue.isEmpty()) {
            Term term = (Term)queue.removeFirst();
            Sort sort = term.sort();
            Vector_Term children = term.children();
            if (sort.is_rm()) continue;
            if (term.kind() == Kind.APPLY) {
                variablesBuilder.add((Object)this.getUFAssignment(term));
                for (int i = 1; i < children.size(); ++i) {
                    queue.addLast(children.get(i));
                }
                continue;
            }
            if (sort.is_bv() && term.is_const()) {
                variablesBuilder.add((Object)this.getSimpleAssignment(term));
                continue;
            }
            if (sort.is_bool() && term.is_const()) {
                variablesBuilder.add((Object)this.getSimpleAssignment(term));
                continue;
            }
            if (sort.is_fp() && term.is_const()) {
                variablesBuilder.add((Object)this.getSimpleAssignment(term));
                continue;
            }
            if (sort.is_array() && term.is_const()) {
                variablesBuilder.addAll(this.getArrayAssignment(term));
                continue;
            }
            for (Term child : children) {
                queue.addLast(child);
            }
        }
        return variablesBuilder.build().asList();
    }

    private Model.ValueAssignment getSimpleAssignment(Term pTerm) {
        ArrayList argumentInterpretation = new ArrayList();
        Term valueTerm = this.bitwuzlaEnv.get_value(pTerm);
        String name = pTerm.symbol();
        assert (name != null);
        return new Model.ValueAssignment(this.bitwuzlaCreator.encapsulateWithTypeOf(pTerm), this.bitwuzlaCreator.encapsulateWithTypeOf(valueTerm), this.bitwuzlaCreator.encapsulateBoolean(this.buildEqForTwoTerms(pTerm, valueTerm)), name, this.bitwuzlaCreator.convertValue(valueTerm), argumentInterpretation);
    }

    private Collection<Model.ValueAssignment> getArrayAssignment(Term pTerm) {
        return this.getArrayAssignments(pTerm, (List<Object>)ImmutableList.of());
    }

    private Collection<Model.ValueAssignment> getArrayAssignments(Term pTerm, List<Object> upperIndices) {
        Term array = pTerm;
        ArrayList<Model.ValueAssignment> assignments = new ArrayList<Model.ValueAssignment>();
        HashSet<Term> indices = new HashSet<Term>();
        while (array.sort().is_array()) {
            Term index;
            Vector_Term children = array.children();
            ArrayList<Object> innerIndices = new ArrayList<Object>(upperIndices);
            String name = this.getArrayName(array);
            assert (name != null);
            if (children.isEmpty()) {
                return assignments;
            }
            if (children.size() == 2) {
                index = children.get(1);
                if (!indices.add(index)) continue;
                Term indexValue = this.bitwuzlaEnv.get_value(index);
                innerIndices.add(this.evaluateImpl(indexValue));
                Term valueTerm = this.bitwuzlaEnv.get_value(array);
                assignments.add(new Model.ValueAssignment(this.bitwuzlaCreator.encapsulateWithTypeOf(array), this.bitwuzlaCreator.encapsulateWithTypeOf(valueTerm), this.creator.encapsulateBoolean(this.buildEqForTwoTerms(array, valueTerm)), name, this.evaluateImpl(valueTerm), innerIndices));
                array = children.get(0);
                continue;
            }
            assert (children.size() == 3);
            index = children.get(1);
            Term content = children.get(2);
            if (!indices.add(index)) continue;
            Term indexValue = this.bitwuzlaEnv.get_value(index);
            Term contentValue = this.bitwuzlaEnv.get_value(content);
            innerIndices.add(this.evaluateImpl(indexValue));
            assignments.add(new Model.ValueAssignment(this.bitwuzlaCreator.encapsulateWithTypeOf(array), this.bitwuzlaCreator.encapsulateWithTypeOf(content), this.creator.encapsulateBoolean(this.buildEqForTwoTerms(array, contentValue)), name, this.evaluateImpl(contentValue), innerIndices));
            array = children.get(0);
            assignments.addAll(this.getArrayAssignments(array, innerIndices));
        }
        return assignments;
    }

    private String getArrayName(Term array) {
        String name = array.symbol();
        if (name != null) {
            return name;
        }
        return this.getArrayName(array.get(0L));
    }

    private Term buildEqForTwoTerms(Term left, Term right) {
        assert (left.sort().equals((Object)right.sort()));
        Kind kind = Kind.EQUAL;
        if (left.sort().is_fp() || right.sort().is_fp()) {
            kind = Kind.FP_EQUAL;
        }
        return this.bitwuzlaCreator.getTermManager().mk_term(kind, left, right);
    }

    private Model.ValueAssignment getUFAssignment(Term pTerm) {
        Term valueTerm = this.bitwuzlaEnv.get_value(pTerm);
        Vector_Term children = pTerm.children();
        String name = children.get(0).symbol();
        assert (name != null);
        ArrayList<Object> argumentInterpretation = new ArrayList<Object>();
        for (int i = 1; i < children.size(); ++i) {
            Term child = children.get(i);
            Term childValue = this.bitwuzlaEnv.get_value(child);
            argumentInterpretation.add(this.creator.convertValue(childValue));
        }
        return new Model.ValueAssignment(this.bitwuzlaCreator.encapsulateWithTypeOf(pTerm), this.bitwuzlaCreator.encapsulateWithTypeOf(valueTerm), this.bitwuzlaCreator.encapsulateBoolean(this.buildEqForTwoTerms(pTerm, valueTerm)), name, this.bitwuzlaCreator.convertValue(valueTerm), argumentInterpretation);
    }

    @Override
    protected @Nullable Term evalImpl(Term formula) {
        Preconditions.checkState((!this.prover.isClosed() ? 1 : 0) != 0, (Object)"Cannot use model after prover is closed");
        return this.bitwuzlaEnv.get_value(formula);
    }
}

