/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.bitwuzla;

import com.google.errorprone.annotations.Immutable;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointRoundingModeFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Term;

@Immutable
abstract class BitwuzlaFormula
implements Formula {
    private final Term bitwuzlaTerm;

    BitwuzlaFormula(Term term) {
        this.bitwuzlaTerm = term;
    }

    final Term getTerm() {
        return this.bitwuzlaTerm;
    }

    @Override
    public String toString() {
        return this.bitwuzlaTerm.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BitwuzlaFormula)) {
            return false;
        }
        Term otherTerm = ((BitwuzlaFormula)other).getTerm();
        return this.bitwuzlaTerm.equals((Object)otherTerm);
    }

    @Override
    public int hashCode() {
        return this.bitwuzlaTerm.hashCode();
    }

    @Immutable
    static final class BitwuzlaBooleanFormula
    extends BitwuzlaFormula
    implements BooleanFormula {
        BitwuzlaBooleanFormula(Term pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class BitwuzlaFloatingPointRoundingModeFormula
    extends BitwuzlaFormula
    implements FloatingPointRoundingModeFormula {
        BitwuzlaFloatingPointRoundingModeFormula(Term pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class BitwuzlaFloatingPointFormula
    extends BitwuzlaFormula
    implements FloatingPointFormula {
        BitwuzlaFloatingPointFormula(Term pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class BitwuzlaBitvectorFormula
    extends BitwuzlaFormula
    implements BitvectorFormula {
        BitwuzlaBitvectorFormula(Term pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class BitwuzlaArrayFormula<TI extends Formula, TE extends Formula>
    extends BitwuzlaFormula
    implements ArrayFormula<TI, TE> {
        private final FormulaType<TI> indexType;
        private final FormulaType<TE> elementType;

        BitwuzlaArrayFormula(Term pTerm, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
            super(pTerm);
            this.indexType = pIndexType;
            this.elementType = pElementType;
        }

        public FormulaType<TI> getIndexType() {
            return this.indexType;
        }

        public FormulaType<TE> getElementType() {
            return this.elementType;
        }
    }
}

