/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example.nqueens_user_propagator;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.example.nqueens_user_propagator.NQueensConstraintPropagator;
import org.sosy_lab.java_smt.example.nqueens_user_propagator.NQueensEnumeratingPropagator;

public class NQueens {
    private static final String HELP_TEXT = "Please specify two numbers: the size N of the NQueens problem and a method M for solving it. The method M can be one of:\n0: plain SMT solving,\n1: plain SMT solving using ALL_SAT,\n2: with enumerating propagation,\n3: with more propagation";
    private final SolverContext context;
    private final BooleanFormulaManager bmgr;
    private final int n;

    public NQueens(SolverContext pContext, int n) {
        this.context = pContext;
        this.bmgr = this.context.getFormulaManager().getBooleanFormulaManager();
        this.n = n;
    }

    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, SolverContextFactory.Solvers.Z3);
             ProverEnvironment prover = context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS, SolverContext.ProverOptions.GENERATE_ALL_SAT);){
            int solutions;
            Method method;
            int n;
            if (args == null || args.length != 2) {
                System.out.println(HELP_TEXT);
                return;
            }
            try {
                n = Integer.parseInt(args[0]);
                method = Method.of(Integer.parseInt(args[1]));
            }
            catch (NumberFormatException e) {
                System.out.println(HELP_TEXT);
                if (prover != null) {
                    prover.close();
                }
                if (context != null) {
                    context.close();
                }
                return;
            }
            long timeSnapshot = System.currentTimeMillis();
            NQueens myQueen = new NQueens(context, n);
            switch (method) {
                case SMT: {
                    System.out.println("Enumerating NQueens solutions with classical blocking clauses.");
                    solutions = myQueen.enumerateSolutionsClassic(prover);
                    break;
                }
                case SMT_ALL_SAT: {
                    System.out.println("Enumerating NQueens solutions with classical blocking clauses using all-sat iteration.");
                    solutions = myQueen.enumerateSolutionsClassicAllSat(prover);
                    break;
                }
                case ENUMERATING_PROPAGATOR: {
                    System.out.println("Enumerating NQueens solutions with enumerating propagator.");
                    solutions = myQueen.enumerateSolutionsWithPropagator(prover);
                    break;
                }
                case CONSTRAINTS_PROPAGATOR: {
                    System.out.println("Enumerating NQueens solutions with enumerating and constraining propagator.");
                    solutions = myQueen.enumerateSolutionsWithConstraintPropagator(prover);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected method for solving  NQueens: " + method);
                }
            }
            long passedMillis = System.currentTimeMillis() - timeSnapshot;
            System.out.printf("Found %d solutions in %.2f seconds%n", solutions, (double)passedMillis / 1000.0);
        }
        catch (UnsatisfiedLinkError | InvalidConfigurationException e) {
            logger.logUserException(Level.INFO, e, "Solver Z3 is not available.");
        }
        catch (UnsupportedOperationException e) {
            logger.logUserException(Level.INFO, (Throwable)e, e.getMessage());
        }
    }

    private BooleanFormula[][] getSymbols() {
        BooleanFormula[][] symbols = new BooleanFormula[this.n][this.n];
        for (int row = 0; row < this.n; ++row) {
            for (int col = 0; col < this.n; ++col) {
                symbols[row][col] = this.bmgr.makeVariable("q_" + row + "_" + col);
            }
        }
        return symbols;
    }

    private List<BooleanFormula> rowRule1(BooleanFormula[][] symbols) {
        ArrayList<BooleanFormula> rules = new ArrayList<BooleanFormula>();
        for (BooleanFormula[] rowSymbols : symbols) {
            ArrayList<BooleanFormula> clause = new ArrayList<BooleanFormula>();
            for (int i = 0; i < this.n; ++i) {
                clause.add(rowSymbols[i]);
            }
            rules.add(this.bmgr.or(clause));
        }
        return rules;
    }

    private List<BooleanFormula> rowRule2(BooleanFormula[][] symbols) {
        ArrayList<BooleanFormula> rules = new ArrayList<BooleanFormula>();
        for (BooleanFormula[] rowSymbol : symbols) {
            for (int j1 = 0; j1 < this.n; ++j1) {
                for (int j2 = j1 + 1; j2 < this.n; ++j2) {
                    rules.add(this.bmgr.not(this.bmgr.and(rowSymbol[j1], rowSymbol[j2])));
                }
            }
        }
        return rules;
    }

    private List<BooleanFormula> columnRule(BooleanFormula[][] symbols) {
        ArrayList<BooleanFormula> rules = new ArrayList<BooleanFormula>();
        for (int j = 0; j < this.n; ++j) {
            for (int i1 = 0; i1 < this.n; ++i1) {
                for (int i2 = i1 + 1; i2 < this.n; ++i2) {
                    rules.add(this.bmgr.not(this.bmgr.and(symbols[i1][j], symbols[i2][j])));
                }
            }
        }
        return rules;
    }

    private List<BooleanFormula> diagonalRule(BooleanFormula[][] symbols) {
        ArrayList<BooleanFormula> rules = new ArrayList<BooleanFormula>();
        int numDiagonals = 2 * this.n - 1;
        BooleanFormula[][] downwardDiagonal = new BooleanFormula[numDiagonals][this.n];
        BooleanFormula[][] upwardDiagonal = new BooleanFormula[numDiagonals][this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                downwardDiagonal[i + j][i] = symbols[i][j];
                upwardDiagonal[i - j + this.n - 1][i] = symbols[i][j];
            }
        }
        for (int d = 0; d < numDiagonals; ++d) {
            int j;
            int i;
            BooleanFormula[] diagonal1 = downwardDiagonal[d];
            BooleanFormula[] diagonal2 = upwardDiagonal[d];
            ArrayList<BooleanFormula> downwardDiagonalQueen = new ArrayList<BooleanFormula>();
            ArrayList<BooleanFormula> upwardDiagonalQueen = new ArrayList<BooleanFormula>();
            for (i = 0; i < this.n; ++i) {
                if (diagonal1[i] != null) {
                    downwardDiagonalQueen.add(diagonal1[i]);
                }
                if (diagonal2[i] == null) continue;
                upwardDiagonalQueen.add(diagonal2[i]);
            }
            for (i = 0; i < downwardDiagonalQueen.size(); ++i) {
                for (j = i + 1; j < downwardDiagonalQueen.size(); ++j) {
                    rules.add(this.bmgr.not(this.bmgr.and((BooleanFormula)downwardDiagonalQueen.get(i), (BooleanFormula)downwardDiagonalQueen.get(j))));
                }
            }
            for (i = 0; i < upwardDiagonalQueen.size(); ++i) {
                for (j = i + 1; j < upwardDiagonalQueen.size(); ++j) {
                    rules.add(this.bmgr.not(this.bmgr.and((BooleanFormula)upwardDiagonalQueen.get(i), (BooleanFormula)upwardDiagonalQueen.get(j))));
                }
            }
        }
        return rules;
    }

    private int enumerateSolutionsClassic(ProverEnvironment prover) throws InterruptedException, SolverException {
        BooleanFormula[][] symbols = this.getSymbols();
        ImmutableList rules = ImmutableList.builder().addAll(this.rowRule1(symbols)).addAll(this.rowRule2(symbols)).addAll(this.columnRule(symbols)).addAll(this.diagonalRule(symbols)).build();
        prover.addConstraint(this.bmgr.and((Collection<BooleanFormula>)rules));
        int numSolutions = 0;
        while (!prover.isUnsat()) {
            ImmutableList<Model.ValueAssignment> assignments = prover.getModelAssignments();
            BooleanFormula modelFormula = this.bmgr.makeTrue();
            for (Model.ValueAssignment assgn : assignments) {
                modelFormula = this.bmgr.and(modelFormula, assgn.getAssignmentAsFormula());
            }
            prover.addConstraint(this.bmgr.not(modelFormula));
            ++numSolutions;
        }
        return numSolutions;
    }

    private int enumerateSolutionsClassicAllSat(ProverEnvironment prover) throws InterruptedException, SolverException {
        BooleanFormula[][] symbols = this.getSymbols();
        ImmutableList rules = ImmutableList.builder().addAll(this.rowRule1(symbols)).addAll(this.rowRule2(symbols)).addAll(this.columnRule(symbols)).addAll(this.diagonalRule(symbols)).build();
        prover.addConstraint(this.bmgr.and((Collection<BooleanFormula>)rules));
        ArrayList<BooleanFormula> predicates = new ArrayList<BooleanFormula>();
        for (int row = 0; row < this.n; ++row) {
            for (int col = 0; col < this.n; ++col) {
                predicates.add(symbols[row][col]);
            }
        }
        BasicProverEnvironment.AllSatCallback<Integer> cb = new BasicProverEnvironment.AllSatCallback<Integer>(){
            int counter = 0;

            @Override
            public void apply(List<BooleanFormula> model) {
                ++this.counter;
            }

            @Override
            public Integer getResult() {
                return this.counter;
            }
        };
        int numSolutions = prover.allSat(cb, predicates);
        return numSolutions;
    }

    private int enumerateSolutionsWithPropagator(ProverEnvironment prover) throws InterruptedException, SolverException {
        BooleanFormula[][] symbols = this.getSymbols();
        ImmutableList rules = ImmutableList.builder().addAll(this.rowRule1(symbols)).addAll(this.rowRule2(symbols)).addAll(this.columnRule(symbols)).addAll(this.diagonalRule(symbols)).build();
        prover.addConstraint(this.bmgr.and((Collection<BooleanFormula>)rules));
        NQueensEnumeratingPropagator enumeratingPropagator = new NQueensEnumeratingPropagator();
        Verify.verify((boolean)prover.registerUserPropagator(enumeratingPropagator));
        BooleanFormula[][] booleanFormulaArray = symbols;
        int n = booleanFormulaArray.length;
        for (int i = 0; i < n; ++i) {
            BooleanFormula[] symbolRow;
            for (BooleanFormula symbol : symbolRow = booleanFormulaArray[i]) {
                enumeratingPropagator.registerExpression(symbol);
            }
        }
        boolean isUnsat = prover.isUnsat();
        Verify.verify((boolean)isUnsat);
        return enumeratingPropagator.getNumOfSolutions();
    }

    private int enumerateSolutionsWithConstraintPropagator(ProverEnvironment prover) throws InterruptedException, SolverException {
        BooleanFormula[][] symbols = this.getSymbols();
        ImmutableList rules = ImmutableList.builder().addAll(this.rowRule1(symbols)).build();
        prover.addConstraint(this.bmgr.and((Collection<BooleanFormula>)rules));
        NQueensConstraintPropagator constraintPropagator = new NQueensConstraintPropagator(symbols);
        Verify.verify((boolean)prover.registerUserPropagator(constraintPropagator));
        BooleanFormula[][] booleanFormulaArray = symbols;
        int n = booleanFormulaArray.length;
        for (int i = 0; i < n; ++i) {
            BooleanFormula[] symbolRow;
            for (BooleanFormula symbol : symbolRow = booleanFormulaArray[i]) {
                constraintPropagator.registerExpression(symbol);
            }
        }
        boolean isUnsat = prover.isUnsat();
        Verify.verify((boolean)isUnsat);
        return constraintPropagator.getNumOfSolutions();
    }

    private static enum Method {
        SMT(0),
        SMT_ALL_SAT(1),
        ENUMERATING_PROPAGATOR(2),
        CONSTRAINTS_PROPAGATOR(3);

        private final int idx;

        private Method(int i) {
            this.idx = i;
        }

        static Method of(int i) {
            for (Method method : Method.values()) {
                if (method.idx != i) continue;
                return method;
            }
            throw new AssertionError((Object)("unexpected method: " + i));
        }
    }
}

