/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.collect.ImmutableList;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class NQueens {
    private final SolverContext context;
    private final BooleanFormulaManager bmgr;
    private final int n;

    private NQueens(SolverContext pContext, int n) {
        this.context = pContext;
        this.bmgr = this.context.getFormulaManager().getBooleanFormulaManager();
        this.n = n;
    }

    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        SolverContextFactory.Solvers solver = SolverContextFactory.Solvers.SMTINTERPOL;
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);
             Scanner sc = new Scanner(System.in, Charset.defaultCharset());){
            System.out.println("Enter the number of Queens to be placed on the board:");
            int n = sc.nextInt();
            NQueens myQueen = new NQueens(context, n);
            Optional<boolean[][]> solutions = myQueen.solve();
            if (solutions.isEmpty()) {
                System.out.println("No solutions found.");
            } else {
                System.out.println("Solution:");
                boolean[][] blArray = solutions.orElseThrow();
                int n2 = blArray.length;
                for (int i = 0; i < n2; ++i) {
                    boolean[] row;
                    for (boolean col : row = blArray[i]) {
                        System.out.print(col ? "Q " : "_ ");
                    }
                    System.out.println();
                }
                System.out.println();
            }
        }
        catch (UnsatisfiedLinkError | InvalidConfigurationException e) {
            logger.logUserException(Level.INFO, e, "Solver " + solver + " is not available.");
        }
        catch (UnsupportedOperationException e) {
            logger.logUserException(Level.INFO, (Throwable)e, e.getMessage());
        }
    }

    private BooleanFormula[][] getSymbols() {
        BooleanFormula[][] symbols = new BooleanFormula[this.n][this.n];
        for (int row = 0; row < this.n; ++row) {
            for (int col = 0; col < this.n; ++col) {
                symbols[row][col] = this.bmgr.makeVariable("q_" + row + "_" + col);
            }
        }
        return symbols;
    }

    private List<BooleanFormula> rowRule1(BooleanFormula[][] symbols) {
        ArrayList<BooleanFormula> rules = new ArrayList<BooleanFormula>();
        for (BooleanFormula[] rowSymbols : symbols) {
            ArrayList<BooleanFormula> clause = new ArrayList<BooleanFormula>();
            for (int i = 0; i < this.n; ++i) {
                clause.add(rowSymbols[i]);
            }
            rules.add(this.bmgr.or(clause));
        }
        return rules;
    }

    private List<BooleanFormula> rowRule2(BooleanFormula[][] symbols) {
        ArrayList<BooleanFormula> rules = new ArrayList<BooleanFormula>();
        for (BooleanFormula[] rowSymbol : symbols) {
            for (int j1 = 0; j1 < this.n; ++j1) {
                for (int j2 = j1 + 1; j2 < this.n; ++j2) {
                    rules.add(this.bmgr.not(this.bmgr.and(rowSymbol[j1], rowSymbol[j2])));
                }
            }
        }
        return rules;
    }

    private List<BooleanFormula> columnRule(BooleanFormula[][] symbols) {
        ArrayList<BooleanFormula> rules = new ArrayList<BooleanFormula>();
        for (int j = 0; j < this.n; ++j) {
            for (int i1 = 0; i1 < this.n; ++i1) {
                for (int i2 = i1 + 1; i2 < this.n; ++i2) {
                    rules.add(this.bmgr.not(this.bmgr.and(symbols[i1][j], symbols[i2][j])));
                }
            }
        }
        return rules;
    }

    private List<BooleanFormula> diagonalRule(BooleanFormula[][] symbols) {
        ArrayList<BooleanFormula> rules = new ArrayList<BooleanFormula>();
        int numDiagonals = 2 * this.n - 1;
        BooleanFormula[][] downwardDiagonal = new BooleanFormula[numDiagonals][this.n];
        BooleanFormula[][] upwardDiagonal = new BooleanFormula[numDiagonals][this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                downwardDiagonal[i + j][i] = symbols[i][j];
                upwardDiagonal[i - j + this.n - 1][i] = symbols[i][j];
            }
        }
        for (int d = 0; d < numDiagonals; ++d) {
            int j;
            int i;
            BooleanFormula[] diagonal1 = downwardDiagonal[d];
            BooleanFormula[] diagonal2 = upwardDiagonal[d];
            ArrayList<BooleanFormula> downwardDiagonalQueen = new ArrayList<BooleanFormula>();
            ArrayList<BooleanFormula> upwardDiagonalQueen = new ArrayList<BooleanFormula>();
            for (i = 0; i < this.n; ++i) {
                if (diagonal1[i] != null) {
                    downwardDiagonalQueen.add(diagonal1[i]);
                }
                if (diagonal2[i] == null) continue;
                upwardDiagonalQueen.add(diagonal2[i]);
            }
            for (i = 0; i < downwardDiagonalQueen.size(); ++i) {
                for (j = i + 1; j < downwardDiagonalQueen.size(); ++j) {
                    rules.add(this.bmgr.not(this.bmgr.and((BooleanFormula)downwardDiagonalQueen.get(i), (BooleanFormula)downwardDiagonalQueen.get(j))));
                }
            }
            for (i = 0; i < upwardDiagonalQueen.size(); ++i) {
                for (j = i + 1; j < upwardDiagonalQueen.size(); ++j) {
                    rules.add(this.bmgr.not(this.bmgr.and((BooleanFormula)upwardDiagonalQueen.get(i), (BooleanFormula)upwardDiagonalQueen.get(j))));
                }
            }
        }
        return rules;
    }

    private boolean getValue(BooleanFormula[][] symbols, Model model, int row, int col) {
        return Boolean.TRUE.equals(model.evaluate(symbols[row][col]));
    }

    private Optional<boolean[][]> solve() throws InterruptedException, SolverException {
        BooleanFormula[][] symbols = this.getSymbols();
        ImmutableList rules = ImmutableList.builder().addAll(this.rowRule1(symbols)).addAll(this.rowRule2(symbols)).addAll(this.columnRule(symbols)).addAll(this.diagonalRule(symbols)).build();
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(this.bmgr.and((Collection<BooleanFormula>)rules));
            boolean isUnsolvable = prover.isUnsat();
            if (isUnsolvable) {
                Optional<boolean[][]> optional = Optional.empty();
                return optional;
            }
            boolean[][] solution = new boolean[this.n][this.n];
            Model model = prover.getModel();
            try {
                for (int row = 0; row < this.n; ++row) {
                    for (int col = 0; col < this.n; ++col) {
                        solution[row][col] = this.getValue(symbols, model, row, col);
                    }
                }
                Optional<boolean[][]> optional = Optional.of(solution);
                if (model != null) {
                    model.close();
                }
                return optional;
            }
            catch (Throwable throwable) {
                if (model != null) {
                    try {
                        model.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }
}

