/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class Binoxxo {
    private static final char[][] UNSOLVABLE_BINOXXO = null;

    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException, IOException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        char[][] grid = Binoxxo.readGridFromStdin();
        SolverContextFactory.Solvers solver = SolverContextFactory.Solvers.Z3;
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);){
            for (BinoxxoSolver binoxxoSolver : List.of(new IntegerBasedBinoxxoSolver(context), new BooleanBasedBinoxxoSolver(context))) {
                long start = System.currentTimeMillis();
                char[][] solution = binoxxoSolver.solve(grid);
                if (solution == UNSOLVABLE_BINOXXO) {
                    System.out.println("Binoxxo has no solution.");
                } else {
                    System.out.println("Binoxxo has a solution:");
                    for (char[] line : solution) {
                        System.out.println(line);
                    }
                }
                long end = System.currentTimeMillis();
                System.out.println("    Used strategy: " + binoxxoSolver.getClass().getSimpleName());
                System.out.println("    Time to solve: " + (end - start) + " ms");
            }
        }
        catch (UnsatisfiedLinkError | InvalidConfigurationException e) {
            logger.logUserException(Level.INFO, e, "Solver " + solver + " is not available.");
        }
        catch (UnsupportedOperationException e) {
            logger.logUserException(Level.INFO, (Throwable)e, e.getMessage());
        }
    }

    private Binoxxo() {
    }

    private static char[][] readGridFromStdin() {
        Scanner scanner = new Scanner(System.in, Charset.defaultCharset());
        System.out.println("Please insert a square for Binxxo.\nUse 'X', 'O' as values any any other char as missing value.\nUse an empty line to terminate your input.");
        String line = scanner.nextLine();
        ArrayList<String> lines = new ArrayList<String>();
        while (!line.isEmpty()) {
            lines.add(line.toUpperCase(Locale.getDefault()));
            line = scanner.nextLine();
        }
        int size = lines.size();
        Preconditions.checkArgument((size % 2 == 0 ? 1 : 0) != 0, (Object)"Invalid Binoxxo: size is not divisibl by 2");
        char[][] grid = new char[size][size];
        for (int i = 0; i < size; ++i) {
            Preconditions.checkArgument((((String)lines.get(i)).length() == size ? 1 : 0) != 0, (Object)"Invalid Binoxxo: no square");
            for (int j = 0; j < size; ++j) {
                int value = ((String)lines.get(i)).charAt(j);
                grid[i][j] = value == 88 || value == 79 ? value : 46;
            }
        }
        return grid;
    }

    public static class BooleanBasedBinoxxoSolver
    extends BinoxxoSolver<BooleanFormula[][]> {
        final IntegerFormulaManager imgr;

        public BooleanBasedBinoxxoSolver(SolverContext context) {
            super(context);
            this.imgr = context.getFormulaManager().getIntegerFormulaManager();
        }

        @Override
        BooleanFormula[][] getSymbols(char[][] grid) {
            BooleanFormula[][] symbols = new BooleanFormula[grid.length][];
            for (int row = 0; row < grid.length; ++row) {
                symbols[row] = new BooleanFormula[grid[row].length];
                for (int col = 0; col < grid[row].length; ++col) {
                    symbols[row][col] = this.bmgr.makeVariable("x_" + row + "_" + col);
                }
            }
            return symbols;
        }

        @Override
        List<BooleanFormula> getRules(BooleanFormula[][] symbols) {
            int col;
            ArrayList<NumeralFormula.IntegerFormula> lst;
            int row;
            ArrayList<BooleanFormula> rules = new ArrayList<BooleanFormula>();
            int size = symbols.length;
            Preconditions.checkArgument((size % 2 == 0 ? 1 : 0) != 0);
            NumeralFormula.IntegerFormula halfSize = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(size / 2);
            NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
            NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
            for (row = 0; row < size; ++row) {
                lst = new ArrayList<NumeralFormula.IntegerFormula>();
                for (int col2 = 0; col2 < size; ++col2) {
                    lst.add(this.bmgr.ifThenElse(symbols[row][col2], one, zero));
                }
                rules.add(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.sum(lst), halfSize));
            }
            for (col = 0; col < size; ++col) {
                lst = new ArrayList();
                for (int row2 = 0; row2 < size; ++row2) {
                    lst.add(this.bmgr.ifThenElse(symbols[row2][col], one, zero));
                }
                rules.add(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.sum(lst), halfSize));
            }
            for (row = 0; row < size; ++row) {
                for (int col3 = 0; col3 < size - 2; ++col3) {
                    List<BooleanFormula> lst2 = List.of(symbols[row][col3], symbols[row][col3 + 1], symbols[row][col3 + 2]);
                    rules.add(this.bmgr.not(this.bmgr.and(lst2)));
                    rules.add(this.bmgr.or(lst2));
                }
            }
            for (col = 0; col < size; ++col) {
                for (int row3 = 0; row3 < size - 2; ++row3) {
                    List<BooleanFormula> lst3 = List.of(symbols[row3][col], symbols[row3 + 1][col], symbols[row3 + 2][col]);
                    rules.add(this.bmgr.not(this.bmgr.and(lst3)));
                    rules.add(this.bmgr.or(lst3));
                }
            }
            return rules;
        }

        @Override
        BooleanFormula getAssignment(BooleanFormula[][] symbols, int row, int col, char value) {
            return value == 'O' ? this.bmgr.not(symbols[row][col]) : symbols[row][col];
        }

        @Override
        char getValue(BooleanFormula[][] symbols, Model model, int row, int col) {
            @Nullable Boolean value = model.evaluate(symbols[row][col]);
            return (char)(value == null ? 46 : (value != false ? 88 : 79));
        }
    }

    public static class IntegerBasedBinoxxoSolver
    extends BinoxxoSolver<NumeralFormula.IntegerFormula[][]> {
        final IntegerFormulaManager imgr;

        public IntegerBasedBinoxxoSolver(SolverContext context) {
            super(context);
            this.imgr = context.getFormulaManager().getIntegerFormulaManager();
        }

        @Override
        NumeralFormula.IntegerFormula[][] getSymbols(char[][] grid) {
            NumeralFormula.IntegerFormula[][] symbols = new NumeralFormula.IntegerFormula[grid.length][];
            for (int row = 0; row < grid.length; ++row) {
                symbols[row] = new NumeralFormula.IntegerFormula[grid[row].length];
                for (int col = 0; col < grid[row].length; ++col) {
                    symbols[row][col] = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x_" + row + "_" + col);
                }
            }
            return symbols;
        }

        @Override
        List<BooleanFormula> getRules(NumeralFormula.IntegerFormula[][] symbols) {
            NumeralFormula.IntegerFormula sum;
            int col;
            int row;
            ArrayList<BooleanFormula> rules = new ArrayList<BooleanFormula>();
            int size = symbols.length;
            Preconditions.checkArgument((size % 2 == 0 ? 1 : 0) != 0);
            NumeralFormula.IntegerFormula halfSize = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(size / 2);
            NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
            NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
            NumeralFormula.IntegerFormula two = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
            for (row = 0; row < size; ++row) {
                for (int col2 = 0; col2 < size; ++col2) {
                    rules.add(this.bmgr.or(this.imgr.equal(zero, symbols[row][col2]), this.imgr.equal(one, symbols[row][col2])));
                }
            }
            for (row = 0; row < size; ++row) {
                ArrayList<NumeralFormula.IntegerFormula> lst = new ArrayList<NumeralFormula.IntegerFormula>();
                for (int col3 = 0; col3 < size; ++col3) {
                    lst.add(symbols[row][col3]);
                }
                rules.add(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.sum(lst), halfSize));
            }
            for (col = 0; col < size; ++col) {
                ArrayList<NumeralFormula.IntegerFormula> lst = new ArrayList<NumeralFormula.IntegerFormula>();
                for (int row2 = 0; row2 < size; ++row2) {
                    lst.add(symbols[row2][col]);
                }
                rules.add(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.sum(lst), halfSize));
            }
            for (row = 0; row < size; ++row) {
                for (int col4 = 0; col4 < size - 2; ++col4) {
                    List<NumeralFormula.IntegerFormula> lst = List.of(symbols[row][col4], symbols[row][col4 + 1], symbols[row][col4 + 2]);
                    sum = (NumeralFormula.IntegerFormula)this.imgr.sum(lst);
                    rules.add(this.bmgr.or(this.imgr.equal(one, sum), this.imgr.equal(two, sum)));
                }
            }
            for (col = 0; col < size; ++col) {
                for (int row3 = 0; row3 < size - 2; ++row3) {
                    List<NumeralFormula.IntegerFormula> lst = List.of(symbols[row3][col], symbols[row3 + 1][col], symbols[row3 + 2][col]);
                    sum = (NumeralFormula.IntegerFormula)this.imgr.sum(lst);
                    rules.add(this.bmgr.or(this.imgr.equal(one, sum), this.imgr.equal(two, sum)));
                }
            }
            return rules;
        }

        @Override
        BooleanFormula getAssignment(NumeralFormula.IntegerFormula[][] symbols, int row, int col, char value) {
            return this.imgr.equal(symbols[row][col], (NumeralFormula.IntegerFormula)this.imgr.makeNumber(value == 'O' ? 0L : 1L));
        }

        @Override
        char getValue(NumeralFormula.IntegerFormula[][] symbols, Model model, int row, int col) {
            @Nullable BigInteger value = model.evaluate(symbols[row][col]);
            return (char)(value == null ? 46 : (value.intValue() == 0 ? 79 : 88));
        }
    }

    public static abstract class BinoxxoSolver<S> {
        private final SolverContext context;
        final BooleanFormulaManager bmgr;

        private BinoxxoSolver(SolverContext pContext) {
            this.context = pContext;
            this.bmgr = this.context.getFormulaManager().getBooleanFormulaManager();
        }

        abstract S getSymbols(char[][] var1);

        abstract List<BooleanFormula> getRules(S var1);

        private List<BooleanFormula> getAssignments(S symbols, char[][] grid) {
            ArrayList<BooleanFormula> assignments = new ArrayList<BooleanFormula>();
            for (int row = 0; row < grid.length; ++row) {
                for (int col = 0; col < grid[row].length; ++col) {
                    char value = grid[row][col];
                    if (value == '.') continue;
                    assignments.add(this.getAssignment(symbols, row, col, value));
                }
            }
            return assignments;
        }

        abstract BooleanFormula getAssignment(S var1, int var2, int var3, char var4);

        abstract char getValue(S var1, Model var2, int var3, int var4);

        public char[][] solve(char[][] grid) throws InterruptedException, SolverException {
            S symbols = this.getSymbols(grid);
            List<BooleanFormula> rules = this.getRules(symbols);
            List<BooleanFormula> assignments = this.getAssignments(symbols, grid);
            try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
                prover.push(this.bmgr.and(rules));
                prover.push(this.bmgr.and(assignments));
                boolean isUnsolvable = prover.isUnsat();
                if (isUnsolvable) {
                    char[][] cArray = UNSOLVABLE_BINOXXO;
                    return cArray;
                }
                char[][] solution = new char[grid.length][];
                try (Model model = prover.getModel();){
                    for (int row = 0; row < grid.length; ++row) {
                        solution[row] = new char[grid[row].length];
                        for (int col = 0; col < grid[row].length; ++col) {
                            solution[row][col] = this.getValue(symbols, model, row, col);
                        }
                    }
                }
                char[][] cArrayArray = solution;
                return cArrayArray;
            }
        }
    }
}

