/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.synchronize;

import com.google.common.base.Preconditions;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.ArrayFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.SolverContext;

class SynchronizedArrayFormulaManager
implements ArrayFormulaManager {
    private final ArrayFormulaManager delegate;
    private final SolverContext sync;

    SynchronizedArrayFormulaManager(ArrayFormulaManager pDelegate, SolverContext pSync) {
        this.delegate = (ArrayFormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.sync = (SolverContext)Preconditions.checkNotNull((Object)pSync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <TI extends Formula, TE extends Formula> TE select(ArrayFormula<TI, TE> pArray, TI pIndex) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.select(pArray, pIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> store(ArrayFormula<TI, TE> pArray, TI pIndex, TE pValue) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.store(pArray, pIndex, pValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <TI extends Formula, TE extends Formula, FTI extends FormulaType<TI>, FTE extends FormulaType<TE>> ArrayFormula<TI, TE> makeArray(String pName, FTI pIndexType, FTE pElementType) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.makeArray(pName, pIndexType, pElementType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <TI extends Formula, TE extends Formula, FTI extends FormulaType<TI>, FTE extends FormulaType<TE>> ArrayFormula<TI, TE> makeArray(FTI pIndexType, FTE pElementType, TE defaultElement) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.makeArray(pIndexType, pElementType, defaultElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <TI extends Formula, TE extends Formula> BooleanFormula equivalence(ArrayFormula<TI, TE> pArray1, ArrayFormula<TI, TE> pArray2) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.equivalence(pArray1, pArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <TI extends Formula> FormulaType<TI> getIndexType(ArrayFormula<TI, ?> pArray) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.getIndexType(pArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <TE extends Formula> FormulaType<TE> getElementType(ArrayFormula<?, TE> pArray) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.getElementType(pArray);
        }
    }
}

