/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.statistics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.EnumerationFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointNumber;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.StringFormula;
import org.sosy_lab.java_smt.delegate.statistics.SolverStatistics;

class StatisticsModel
implements Model {
    private final Model delegate;
    private final SolverStatistics stats;

    StatisticsModel(Model pDelegate, SolverStatistics pStats) {
        this.delegate = (Model)Preconditions.checkNotNull((Object)pDelegate);
        this.stats = (SolverStatistics)Preconditions.checkNotNull((Object)pStats);
    }

    @Override
    public <T extends Formula> @Nullable T eval(T pFormula) {
        this.stats.modelEvaluations.getAndIncrement();
        return this.delegate.eval(pFormula);
    }

    @Override
    public @Nullable Object evaluate(Formula pF) {
        this.stats.modelEvaluations.getAndIncrement();
        return this.delegate.evaluate(pF);
    }

    @Override
    public @Nullable BigInteger evaluate(NumeralFormula.IntegerFormula pF) {
        this.stats.modelEvaluations.getAndIncrement();
        return this.delegate.evaluate(pF);
    }

    @Override
    public @Nullable Rational evaluate(NumeralFormula.RationalFormula pF) {
        this.stats.modelEvaluations.getAndIncrement();
        return this.delegate.evaluate(pF);
    }

    @Override
    public @Nullable Boolean evaluate(BooleanFormula pF) {
        this.stats.modelEvaluations.getAndIncrement();
        return this.delegate.evaluate(pF);
    }

    @Override
    public @Nullable BigInteger evaluate(BitvectorFormula pF) {
        this.stats.modelEvaluations.getAndIncrement();
        return this.delegate.evaluate(pF);
    }

    @Override
    public @Nullable String evaluate(StringFormula pF) {
        this.stats.modelEvaluations.getAndIncrement();
        return this.delegate.evaluate(pF);
    }

    @Override
    public @Nullable String evaluate(EnumerationFormula pF) {
        this.stats.modelEvaluations.getAndIncrement();
        return this.delegate.evaluate(pF);
    }

    @Override
    public @Nullable FloatingPointNumber evaluate(FloatingPointFormula pF) {
        this.stats.modelEvaluations.getAndIncrement();
        return this.delegate.evaluate(pF);
    }

    @Override
    public ImmutableList<Model.ValueAssignment> asList() {
        this.stats.modelListings.getAndIncrement();
        return this.delegate.asList();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

