/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormulaManager;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;

public class DebuggingFloatingPointFormulaManager
implements FloatingPointFormulaManager {
    private final FloatingPointFormulaManager delegate;
    private final DebuggingAssertions debugging;

    public DebuggingFloatingPointFormulaManager(FloatingPointFormulaManager pDelegate, DebuggingAssertions pDebugging) {
        this.delegate = pDelegate;
        this.debugging = pDebugging;
    }

    @Override
    public FloatingPointFormula makeNumber(double n, FormulaType.FloatingPointType type) {
        this.debugging.assertThreadLocal();
        FloatingPointFormula result = this.delegate.makeNumber(n, type);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula makeNumber(double n, FormulaType.FloatingPointType type, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        this.debugging.assertThreadLocal();
        FloatingPointFormula result = this.delegate.makeNumber(n, type, pFloatingPointRoundingMode);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula makeNumber(BigDecimal n, FormulaType.FloatingPointType type) {
        this.debugging.assertThreadLocal();
        FloatingPointFormula result = this.delegate.makeNumber(n, type);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula makeNumber(BigDecimal n, FormulaType.FloatingPointType type, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        this.debugging.assertThreadLocal();
        FloatingPointFormula result = this.delegate.makeNumber(n, type, pFloatingPointRoundingMode);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula makeNumber(String n, FormulaType.FloatingPointType type) {
        this.debugging.assertThreadLocal();
        FloatingPointFormula result = this.delegate.makeNumber(n, type);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula makeNumber(String n, FormulaType.FloatingPointType type, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        this.debugging.assertThreadLocal();
        FloatingPointFormula result = this.delegate.makeNumber(n, type, pFloatingPointRoundingMode);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula makeNumber(Rational n, FormulaType.FloatingPointType type) {
        this.debugging.assertThreadLocal();
        FloatingPointFormula result = this.delegate.makeNumber(n, type);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula makeNumber(Rational n, FormulaType.FloatingPointType type, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        this.debugging.assertThreadLocal();
        FloatingPointFormula result = this.delegate.makeNumber(n, type, pFloatingPointRoundingMode);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula makeNumber(BigInteger exponent, BigInteger mantissa, boolean signBit, FormulaType.FloatingPointType type) {
        this.debugging.assertThreadLocal();
        FloatingPointFormula result = this.delegate.makeNumber(exponent, mantissa, signBit, type);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula makeVariable(String pVar, FormulaType.FloatingPointType type) {
        this.debugging.assertThreadLocal();
        FloatingPointFormula result = this.delegate.makeVariable(pVar, type);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula makePlusInfinity(FormulaType.FloatingPointType type) {
        this.debugging.assertThreadLocal();
        FloatingPointFormula result = this.delegate.makePlusInfinity(type);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula makeMinusInfinity(FormulaType.FloatingPointType type) {
        this.debugging.assertThreadLocal();
        FloatingPointFormula result = this.delegate.makeMinusInfinity(type);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula makeNaN(FormulaType.FloatingPointType type) {
        this.debugging.assertThreadLocal();
        FloatingPointFormula result = this.delegate.makeNaN(type);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public <T extends Formula> T castTo(FloatingPointFormula source, boolean signed, FormulaType<T> targetType) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(source);
        T result = this.delegate.castTo(source, signed, targetType);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public <T extends Formula> T castTo(FloatingPointFormula source, boolean signed, FormulaType<T> targetType, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(source);
        T result = this.delegate.castTo(source, signed, targetType, pFloatingPointRoundingMode);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public FloatingPointFormula castFrom(Formula source, boolean signed, FormulaType.FloatingPointType targetType) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(source);
        FloatingPointFormula result = this.delegate.castFrom(source, signed, targetType);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula castFrom(Formula source, boolean signed, FormulaType.FloatingPointType targetType, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(source);
        FloatingPointFormula result = this.delegate.castFrom(source, signed, targetType, pFloatingPointRoundingMode);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula fromIeeeBitvector(BitvectorFormula number, FormulaType.FloatingPointType pTargetType) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        FloatingPointFormula result = this.delegate.fromIeeeBitvector(number, pTargetType);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula toIeeeBitvector(FloatingPointFormula number) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        BitvectorFormula result = this.delegate.toIeeeBitvector(number);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula round(FloatingPointFormula formula, FloatingPointRoundingMode roundingMode) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(formula);
        FloatingPointFormula result = this.delegate.round(formula, roundingMode);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula negate(FloatingPointFormula number) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        FloatingPointFormula result = this.delegate.negate(number);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula abs(FloatingPointFormula number) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        FloatingPointFormula result = this.delegate.abs(number);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula max(FloatingPointFormula number1, FloatingPointFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        FloatingPointFormula result = this.delegate.max(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula min(FloatingPointFormula number1, FloatingPointFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        FloatingPointFormula result = this.delegate.min(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula sqrt(FloatingPointFormula number) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        FloatingPointFormula result = this.delegate.sqrt(number);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula sqrt(FloatingPointFormula number, FloatingPointRoundingMode roundingMode) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        FloatingPointFormula result = this.delegate.sqrt(number, roundingMode);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula add(FloatingPointFormula number1, FloatingPointFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        FloatingPointFormula result = this.delegate.add(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula add(FloatingPointFormula number1, FloatingPointFormula number2, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        FloatingPointFormula result = this.delegate.add(number1, number2, pFloatingPointRoundingMode);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula subtract(FloatingPointFormula number1, FloatingPointFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        FloatingPointFormula result = this.delegate.subtract(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula subtract(FloatingPointFormula number1, FloatingPointFormula number2, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        FloatingPointFormula result = this.delegate.subtract(number1, number2, pFloatingPointRoundingMode);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula divide(FloatingPointFormula number1, FloatingPointFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        FloatingPointFormula result = this.delegate.divide(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula divide(FloatingPointFormula number1, FloatingPointFormula number2, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        FloatingPointFormula result = this.delegate.divide(number1, number2, pFloatingPointRoundingMode);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula multiply(FloatingPointFormula number1, FloatingPointFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        FloatingPointFormula result = this.delegate.multiply(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula multiply(FloatingPointFormula number1, FloatingPointFormula number2, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        FloatingPointFormula result = this.delegate.multiply(number1, number2, pFloatingPointRoundingMode);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public FloatingPointFormula remainder(FloatingPointFormula dividend, FloatingPointFormula divisor) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(dividend);
        this.debugging.assertFormulaInContext(divisor);
        FloatingPointFormula result = this.delegate.remainder(dividend, divisor);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula assignment(FloatingPointFormula number1, FloatingPointFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BooleanFormula result = this.delegate.assignment(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula equalWithFPSemantics(FloatingPointFormula number1, FloatingPointFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BooleanFormula result = this.delegate.equalWithFPSemantics(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula greaterThan(FloatingPointFormula number1, FloatingPointFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BooleanFormula result = this.delegate.greaterThan(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula greaterOrEquals(FloatingPointFormula number1, FloatingPointFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BooleanFormula result = this.delegate.greaterOrEquals(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula lessThan(FloatingPointFormula number1, FloatingPointFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BooleanFormula result = this.delegate.lessThan(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula lessOrEquals(FloatingPointFormula number1, FloatingPointFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BooleanFormula result = this.delegate.lessOrEquals(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula isNaN(FloatingPointFormula number) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        BooleanFormula result = this.delegate.isNaN(number);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula isInfinity(FloatingPointFormula number) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        BooleanFormula result = this.delegate.isInfinity(number);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula isZero(FloatingPointFormula number) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        BooleanFormula result = this.delegate.isZero(number);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula isNormal(FloatingPointFormula number) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        BooleanFormula result = this.delegate.isNormal(number);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula isSubnormal(FloatingPointFormula number) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        BooleanFormula result = this.delegate.isSubnormal(number);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula isNegative(FloatingPointFormula number) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        BooleanFormula result = this.delegate.isNegative(number);
        this.debugging.addFormulaTerm(result);
        return result;
    }
}

