/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import java.util.Set;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.EnumerationFormula;
import org.sosy_lab.java_smt.api.EnumerationFormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;

public class DebuggingEnumerationFormulaManager
implements EnumerationFormulaManager {
    private final EnumerationFormulaManager delegate;
    private final DebuggingAssertions debugging;

    public DebuggingEnumerationFormulaManager(EnumerationFormulaManager pDelegate, DebuggingAssertions pDebugging) {
        this.delegate = pDelegate;
        this.debugging = pDebugging;
    }

    @Override
    public FormulaType.EnumerationFormulaType declareEnumeration(String pName, Set<String> ppElementNames) {
        this.debugging.assertThreadLocal();
        return this.delegate.declareEnumeration(pName, ppElementNames);
    }

    @Override
    public EnumerationFormula makeConstant(String pName, FormulaType.EnumerationFormulaType pType) {
        this.debugging.assertThreadLocal();
        EnumerationFormula result = this.delegate.makeConstant(pName, pType);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public EnumerationFormula makeVariable(String pVar, FormulaType.EnumerationFormulaType pType) {
        this.debugging.assertThreadLocal();
        EnumerationFormula result = this.delegate.makeVariable(pVar, pType);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula equivalence(EnumerationFormula pEnumeration1, EnumerationFormula pEnumeration2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(pEnumeration1);
        this.debugging.assertFormulaInContext(pEnumeration2);
        BooleanFormula result = this.delegate.equivalence(pEnumeration1, pEnumeration2);
        this.debugging.addFormulaTerm(result);
        return result;
    }
}

