/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaTransformationVisitor;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;

public class DebuggingBooleanFormulaManager
implements BooleanFormulaManager {
    private final BooleanFormulaManager delegate;
    private final DebuggingAssertions debugging;

    public DebuggingBooleanFormulaManager(BooleanFormulaManager pDelegate, DebuggingAssertions pDebugging) {
        this.delegate = (BooleanFormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.debugging = pDebugging;
    }

    @Override
    public BooleanFormula makeTrue() {
        this.debugging.assertThreadLocal();
        BooleanFormula result = this.delegate.makeTrue();
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula makeFalse() {
        this.debugging.assertThreadLocal();
        BooleanFormula result = this.delegate.makeFalse();
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula makeVariable(String pVar) {
        this.debugging.assertThreadLocal();
        BooleanFormula result = this.delegate.makeVariable(pVar);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula equivalence(BooleanFormula formula1, BooleanFormula formula2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(formula1);
        this.debugging.assertFormulaInContext(formula2);
        BooleanFormula result = this.delegate.equivalence(formula1, formula2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula implication(BooleanFormula formula1, BooleanFormula formula2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(formula1);
        this.debugging.assertFormulaInContext(formula2);
        BooleanFormula result = this.delegate.implication(formula1, formula2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public boolean isTrue(BooleanFormula formula) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(formula);
        return this.delegate.isTrue(formula);
    }

    @Override
    public boolean isFalse(BooleanFormula formula) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(formula);
        return this.delegate.isFalse(formula);
    }

    @Override
    public <T extends Formula> T ifThenElse(BooleanFormula cond, T f1, T f2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(cond);
        this.debugging.assertFormulaInContext(f1);
        this.debugging.assertFormulaInContext(f2);
        T result = this.delegate.ifThenElse(cond, f1, f2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula not(BooleanFormula bits) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(bits);
        BooleanFormula result = this.delegate.not(bits);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula and(BooleanFormula bits1, BooleanFormula bits2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(bits1);
        this.debugging.assertFormulaInContext(bits2);
        BooleanFormula result = this.delegate.and(bits1, bits2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula and(Collection<BooleanFormula> bits) {
        this.debugging.assertThreadLocal();
        for (BooleanFormula f : bits) {
            this.debugging.assertFormulaInContext(f);
        }
        BooleanFormula result = this.delegate.and(bits);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula and(BooleanFormula ... bits) {
        this.debugging.assertThreadLocal();
        for (BooleanFormula f : bits) {
            this.debugging.assertFormulaInContext(f);
        }
        BooleanFormula result = this.delegate.and(bits);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public Collector<BooleanFormula, ?, BooleanFormula> toConjunction() {
        return Collectors.collectingAndThen(Collectors.toList(), terms -> {
            for (BooleanFormula f : terms) {
                this.debugging.assertFormulaInContext(f);
            }
            BooleanFormula result = this.and((Collection<BooleanFormula>)terms);
            this.debugging.addFormulaTerm(result);
            return result;
        });
    }

    @Override
    public BooleanFormula or(BooleanFormula bits1, BooleanFormula bits2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(bits1);
        this.debugging.assertFormulaInContext(bits2);
        BooleanFormula result = this.delegate.or(bits1, bits2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula or(Collection<BooleanFormula> bits) {
        this.debugging.assertThreadLocal();
        for (BooleanFormula f : bits) {
            this.debugging.assertFormulaInContext(f);
        }
        BooleanFormula result = this.delegate.or(bits);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula or(BooleanFormula ... bits) {
        this.debugging.assertThreadLocal();
        for (BooleanFormula f : bits) {
            this.debugging.assertFormulaInContext(f);
        }
        BooleanFormula result = this.delegate.or(bits);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public Collector<BooleanFormula, ?, BooleanFormula> toDisjunction() {
        return Collectors.collectingAndThen(Collectors.toList(), terms -> {
            for (BooleanFormula f : terms) {
                this.debugging.assertFormulaInContext(f);
            }
            BooleanFormula result = this.or((Collection<BooleanFormula>)terms);
            this.debugging.addFormulaTerm(result);
            return result;
        });
    }

    @Override
    public BooleanFormula xor(BooleanFormula bits1, BooleanFormula bits2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(bits1);
        this.debugging.assertFormulaInContext(bits2);
        BooleanFormula result = this.delegate.xor(bits1, bits2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public <R> R visit(BooleanFormula pFormula, BooleanFormulaVisitor<R> visitor) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(pFormula);
        return this.delegate.visit(pFormula, visitor);
    }

    @Override
    public void visitRecursively(BooleanFormula f, BooleanFormulaVisitor<TraversalProcess> rFormulaVisitor) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(f);
        this.delegate.visitRecursively(f, rFormulaVisitor);
    }

    @Override
    public BooleanFormula transformRecursively(BooleanFormula f, BooleanFormulaTransformationVisitor pVisitor) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(f);
        BooleanFormula result = this.delegate.transformRecursively(f, pVisitor);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public Set<BooleanFormula> toConjunctionArgs(BooleanFormula f, boolean flatten) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(f);
        Set<BooleanFormula> result = this.delegate.toConjunctionArgs(f, flatten);
        for (BooleanFormula r : result) {
            this.debugging.addFormulaTerm(r);
        }
        return result;
    }

    @Override
    public Set<BooleanFormula> toDisjunctionArgs(BooleanFormula f, boolean flatten) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(f);
        Set<BooleanFormula> result = this.delegate.toDisjunctionArgs(f, flatten);
        for (BooleanFormula r : result) {
            this.debugging.addFormulaTerm(r);
        }
        return result;
    }
}

